/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graphmodel.fragment;

import com.intellij.util.Function;
import com.intellij.vcs.log.graph.Graph;
import com.intellij.vcs.log.graph.elements.Edge;
import com.intellij.vcs.log.graph.elements.Node;
import com.intellij.vcs.log.graphmodel.GraphFragment;
import com.intellij.vcs.log.graphmodel.fragment.elements.SimpleGraphFragment;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShortFragmentGenerator {
    private static final int MAX_FRAGMENT_SIZE = 100;
    private final Graph graph;
    private Function<Node, Boolean> isUnconcealedNodes = new Function<Node, Boolean>(){

        @NotNull
        public Boolean fun(@NotNull Node key) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graphmodel/fragment/ShortFragmentGenerator$1", "fun"));
            }
            Boolean bl = false;
            if (bl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graphmodel/fragment/ShortFragmentGenerator$1", "fun"));
            }
            return bl;
        }
    };

    public ShortFragmentGenerator(Graph graph) {
        this.graph = graph;
    }

    public void setUnconcealedNodeFunction(Function<Node, Boolean> isUnconcealedNodes) {
        this.isUnconcealedNodes = isUnconcealedNodes;
    }

    private void addDownNodeToSet(@NotNull Set<Node> nodes, @NotNull Node node) {
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graphmodel/fragment/ShortFragmentGenerator", "addDownNodeToSet"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/graphmodel/fragment/ShortFragmentGenerator", "addDownNodeToSet"));
        }
        for (Edge edge : node.getDownEdges()) {
            Node downNode = edge.getDownNode();
            nodes.add(downNode);
        }
    }

    private boolean allUpNodeHere(@NotNull Set<Node> here, @NotNull Node node) {
        if (here == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graphmodel/fragment/ShortFragmentGenerator", "allUpNodeHere"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/graphmodel/fragment/ShortFragmentGenerator", "allUpNodeHere"));
        }
        for (Edge upEdge : node.getUpEdges()) {
            if (here.contains(upEdge.getUpNode())) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public GraphFragment getDownShortFragment(@NotNull Node startNode) {
        if (startNode == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graphmodel/fragment/ShortFragmentGenerator", "getDownShortFragment"));
        }
        HashSet<Node> upNodes = new HashSet<Node>();
        upNodes.add(startNode);
        HashSet<Node> notAddedNodes = new HashSet<Node>();
        this.addDownNodeToSet(notAddedNodes, startNode);
        Node endNode = null;
        int startRowIndex = startNode.getRowIndex() + 1;
        int lastIndex = this.graph.getNodeRows().size() - 1;
        int countNodes = 0;
        boolean isEnd = false;
        block0: for (int currentRowIndex = startRowIndex; currentRowIndex <= lastIndex && !isEnd; ++currentRowIndex) {
            for (Node node : this.graph.getNodeRows().get(currentRowIndex).getNodes()) {
                if (!notAddedNodes.remove(node)) continue;
                if (++countNodes > 100) {
                    isEnd = true;
                    continue block0;
                }
                if (notAddedNodes.isEmpty() && node.getType() == Node.NodeType.COMMIT_NODE) {
                    if (this.allUpNodeHere(upNodes, node)) {
                        endNode = node;
                    }
                    isEnd = true;
                    continue block0;
                }
                if (!this.allUpNodeHere(upNodes, node) || ((Boolean)this.isUnconcealedNodes.fun((Object)node)).booleanValue()) {
                    isEnd = true;
                }
                upNodes.add(node);
                this.addDownNodeToSet(notAddedNodes, node);
            }
        }
        if (endNode == null) {
            return null;
        }
        upNodes.remove(startNode);
        return new SimpleGraphFragment(startNode, endNode, upNodes);
    }

    private void addUpNodeToSet(@NotNull Set<Node> nodes, @NotNull Node node) {
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graphmodel/fragment/ShortFragmentGenerator", "addUpNodeToSet"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/graphmodel/fragment/ShortFragmentGenerator", "addUpNodeToSet"));
        }
        for (Edge edge : node.getUpEdges()) {
            Node upNode = edge.getUpNode();
            nodes.add(upNode);
        }
    }

    private boolean allDownNodeHere(@NotNull Set<Node> here, @NotNull Node node) {
        if (here == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graphmodel/fragment/ShortFragmentGenerator", "allDownNodeHere"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/graphmodel/fragment/ShortFragmentGenerator", "allDownNodeHere"));
        }
        for (Edge downEdge : node.getDownEdges()) {
            if (here.contains(downEdge.getDownNode())) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public GraphFragment getUpShortFragment(@NotNull Node startNode) {
        if (startNode == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graphmodel/fragment/ShortFragmentGenerator", "getUpShortFragment"));
        }
        HashSet<Node> downNodes = new HashSet<Node>();
        downNodes.add(startNode);
        HashSet<Node> notAddedNodes = new HashSet<Node>();
        this.addUpNodeToSet(notAddedNodes, startNode);
        Node endNode = null;
        int startRowIndex = startNode.getRowIndex() - 1;
        int lastIndex = 0;
        boolean isEnd = false;
        block0: for (int currentRowIndex = startRowIndex; currentRowIndex >= lastIndex && !isEnd; --currentRowIndex) {
            for (Node node : this.graph.getNodeRows().get(currentRowIndex).getNodes()) {
                if (!notAddedNodes.remove(node)) continue;
                if (notAddedNodes.isEmpty() && node.getType() == Node.NodeType.COMMIT_NODE) {
                    if (this.allDownNodeHere(downNodes, node)) {
                        endNode = node;
                    }
                    isEnd = true;
                    continue block0;
                }
                if (!this.allDownNodeHere(downNodes, node) || ((Boolean)this.isUnconcealedNodes.fun((Object)node)).booleanValue()) {
                    isEnd = true;
                }
                downNodes.add(node);
                this.addUpNodeToSet(notAddedNodes, node);
            }
        }
        if (endNode == null) {
            return null;
        }
        downNodes.remove(startNode);
        return new SimpleGraphFragment(endNode, startNode, downNodes);
    }
}

