/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.render;

import com.intellij.ui.JBColor;
import com.intellij.vcs.log.graph.elements.Edge;
import com.intellij.vcs.log.graph.elements.GraphElement;
import com.intellij.vcs.log.graph.elements.Node;
import com.intellij.vcs.log.graph.render.ColorGenerator;
import com.intellij.vcs.log.graph.render.GraphCellPainter;
import com.intellij.vcs.log.graph.render.PositionUtil;
import com.intellij.vcs.log.printmodel.GraphPrintCell;
import com.intellij.vcs.log.printmodel.ShortEdge;
import com.intellij.vcs.log.printmodel.SpecialPrintElement;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleGraphCellPainter
implements GraphCellPainter {
    private static final Color MARK_COLOR = JBColor.BLACK;
    private Graphics2D g2;
    private final Stroke usual = new BasicStroke(1.5f, 1, 2);
    private final Stroke hide = new BasicStroke(1.5f, 1, 2, 0.0f, new float[]{7.0f}, 0.0f);
    private final Stroke selectUsual = new BasicStroke(2.5f, 1, 2);
    private final Stroke selectHide = new BasicStroke(2.5f, 1, 2, 0.0f, new float[]{7.0f}, 0.0f);

    private void paintUpLine(int from, int to, Color color) {
        int x1 = 15 * from + 7;
        int y1 = 11;
        int x2 = 15 * to + 7;
        int y2 = -11;
        this.g2.setColor(color);
        this.g2.drawLine(x2, y2, x1, y1);
    }

    private void paintDownLine(int from, int to, Color color) {
        int x1 = 15 * from + 7;
        int y1 = 11;
        int x2 = 15 * to + 7;
        int y2 = 33;
        this.g2.setColor(color);
        this.g2.drawLine(x1, y1, x2, y2);
    }

    private void paintAbove(int position, Color color) {
        int x1 = 15 * position + 3;
        int y = 4;
        int x2 = 15 * position + 15 - 4;
        this.g2.setColor(color);
        this.g2.drawLine(x1, y, x2, y);
    }

    private void paintBelow(int position, Color color) {
        int x1 = 15 * position + 3;
        int y = 18;
        int x2 = 15 * position + 15 - 4;
        this.g2.setColor(color);
        this.g2.drawLine(x1, y, x2, y);
    }

    private void paintCircle(int position, Color color, boolean select) {
        int x0 = 15 * position + 7;
        int y0 = 11;
        int r = 4;
        if (select) {
            r = 5;
        }
        Ellipse2D.Double circle = new Ellipse2D.Double((double)(x0 - r) + 0.5, (double)(y0 - r) + 0.5, 2 * r, 2 * r);
        this.g2.setColor(color);
        this.g2.fill(circle);
    }

    private void paintHide(int position, Color color) {
        int x0 = 15 * position + 7;
        int y0 = 11;
        int r = 4;
        this.g2.setColor(color);
        this.g2.drawLine(x0, y0, x0, y0 + r);
        this.g2.drawLine(x0, y0 + r, x0 + r, y0);
        this.g2.drawLine(x0, y0 + r, x0 - r, y0);
    }

    private void paintShow(int position, Color color) {
        int x0 = 15 * position + 7;
        int y0 = 11;
        int r = 4;
        this.g2.setColor(color);
        this.g2.drawLine(x0, y0, x0, y0 - r);
        this.g2.drawLine(x0, y0 - r, x0 + r, y0);
        this.g2.drawLine(x0, y0 - r, x0 - r, y0);
    }

    private void setStroke(boolean usual, boolean select) {
        if (usual) {
            if (select) {
                this.g2.setStroke(this.selectUsual);
            } else {
                this.g2.setStroke(this.usual);
            }
        } else if (select) {
            this.g2.setStroke(this.selectHide);
        } else {
            this.g2.setStroke(this.hide);
        }
    }

    private void drawLogic(boolean selected, boolean marked, boolean isUsual, Color usualColor, LitePrinter printer) {
        if (selected) {
            this.setStroke(isUsual, true);
            printer.print(MARK_COLOR);
            this.setStroke(isUsual, false);
            printer.print(usualColor);
        } else {
            this.setStroke(isUsual, marked);
            printer.print(usualColor);
        }
    }

    @Override
    public void draw(@NotNull Graphics2D g2, @NotNull GraphPrintCell row) {
        if (g2 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graph/render/SimpleGraphCellPainter", "draw"));
        }
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/graph/render/SimpleGraphCellPainter", "draw"));
        }
        this.g2 = g2;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (final ShortEdge edge : row.getUpEdges()) {
            this.drawLogic(edge.isSelected(), edge.isMarked(), edge.isUsual(), ColorGenerator.getColor(edge.getEdge().getBranch().getBranchNumber()), new LitePrinter(){

                @Override
                public void print(Color color) {
                    SimpleGraphCellPainter.this.paintUpLine(edge.getDownPosition(), edge.getUpPosition(), color);
                }
            });
        }
        for (final ShortEdge edge : row.getDownEdges()) {
            this.drawLogic(edge.isSelected(), edge.isMarked(), edge.isUsual(), ColorGenerator.getColor(edge.getEdge().getBranch().getBranchNumber()), new LitePrinter(){

                @Override
                public void print(Color color) {
                    SimpleGraphCellPainter.this.paintDownLine(edge.getUpPosition(), edge.getDownPosition(), color);
                }
            });
        }
        block7: for (final SpecialPrintElement printElement : row.getSpecialPrintElements()) {
            switch (printElement.getType()) {
                case COMMIT_NODE: {
                    Node node = printElement.getGraphElement().getNode();
                    assert (node != null);
                    if (printElement.isSelected()) {
                        this.paintCircle(printElement.getPosition(), MARK_COLOR, true);
                        this.paintCircle(printElement.getPosition(), ColorGenerator.getColor(node.getBranch().getBranchNumber()), false);
                        continue block7;
                    }
                    this.paintCircle(printElement.getPosition(), ColorGenerator.getColor(node.getBranch().getBranchNumber()), printElement.isMarked());
                    continue block7;
                }
                case UP_ARROW: {
                    Edge edge = printElement.getGraphElement().getEdge();
                    assert (edge != null);
                    this.drawLogic(printElement.isSelected(), printElement.isMarked(), edge.getType() == Edge.EdgeType.USUAL, ColorGenerator.getColor(edge.getBranch().getBranchNumber()), new LitePrinter(){

                        @Override
                        public void print(Color color) {
                            SimpleGraphCellPainter.this.paintShow(printElement.getPosition(), color);
                        }
                    });
                    continue block7;
                }
                case DOWN_ARROW: {
                    Edge edge = printElement.getGraphElement().getEdge();
                    assert (edge != null);
                    this.drawLogic(printElement.isSelected(), printElement.isMarked(), edge.getType() == Edge.EdgeType.USUAL, ColorGenerator.getColor(edge.getBranch().getBranchNumber()), new LitePrinter(){

                        @Override
                        public void print(Color color) {
                            SimpleGraphCellPainter.this.paintHide(printElement.getPosition(), color);
                        }
                    });
                    continue block7;
                }
            }
            throw new IllegalStateException();
        }
        for (final SpecialPrintElement printElement : row.getSpecialPrintElements()) {
            if (printElement.getType() != SpecialPrintElement.Type.COMMIT_NODE || printElement.getDragAndDropSelect() == 0) continue;
            Node node = printElement.getGraphElement().getNode();
            assert (node != null);
            if (printElement.getDragAndDropSelect() > 0) {
                this.paintAbove(printElement.getPosition(), ColorGenerator.getColor(node.getBranch().getBranchNumber()));
                continue;
            }
            this.paintBelow(printElement.getPosition(), ColorGenerator.getColor(node.getBranch().getBranchNumber()));
        }
    }

    @Override
    @Nullable
    public GraphElement mouseOver(@NotNull GraphPrintCell row, int x, int y) {
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graph/render/SimpleGraphCellPainter", "mouseOver"));
        }
        for (SpecialPrintElement printElement : row.getSpecialPrintElements()) {
            if (printElement.getType() != SpecialPrintElement.Type.COMMIT_NODE || !PositionUtil.overNode(printElement.getPosition(), x, y)) continue;
            return printElement.getGraphElement();
        }
        for (ShortEdge edge : row.getUpEdges()) {
            if (!PositionUtil.overUpEdge(edge, x, y)) continue;
            return edge.getEdge();
        }
        for (ShortEdge edge : row.getDownEdges()) {
            if (!PositionUtil.overDownEdge(edge, x, y)) continue;
            return edge.getEdge();
        }
        return null;
    }

    @Override
    @Nullable
    public SpecialPrintElement mouseOverArrow(@NotNull GraphPrintCell row, int x, int y) {
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graph/render/SimpleGraphCellPainter", "mouseOverArrow"));
        }
        for (SpecialPrintElement printElement : row.getSpecialPrintElements()) {
            if (printElement.getType() == SpecialPrintElement.Type.COMMIT_NODE || !PositionUtil.overNode(printElement.getPosition(), x, y)) continue;
            return printElement;
        }
        return null;
    }

    private static interface LitePrinter {
        public void print(Color var1);
    }
}

