/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.render;

import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ColorGenerator {
    private static final Map<Integer, Color> ourColorMap = ContainerUtil.newHashMap();

    @NotNull
    public static Color getColor(int branchNumber) {
        Color color = ourColorMap.get(branchNumber);
        if (color == null) {
            color = ColorGenerator.calcColor(branchNumber);
            ourColorMap.put(branchNumber, color);
        }
        Color color2 = color;
        if (color2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/render/ColorGenerator", "getColor"));
        }
        return color2;
    }

    private static int rangeFix(int n) {
        return Math.abs(n) % 100 + 70;
    }

    @NotNull
    private static Color calcColor(int indexColor) {
        Color color;
        block2: {
            int r = indexColor * 200 + 30;
            int g = indexColor * 130 + 50;
            int b = indexColor * 90 + 100;
            try {
                color = new Color(ColorGenerator.rangeFix(r), ColorGenerator.rangeFix(g), ColorGenerator.rangeFix(b));
                if (color != null) break block2;
            }
            catch (IllegalArgumentException a) {
                throw new IllegalArgumentException("indexColor: " + indexColor + " " + r % 256 + " " + g % 256 + " " + b % 256);
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/render/ColorGenerator", "calcColor"));
        }
        return color;
    }
}

