/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.elements;

import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsRef;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Branch {
    private final int upCommitHash;
    private final int downCommitHash;
    @Nullable
    private final VcsRef myColoredRef;
    private final int myOneOfHeads;

    public Branch(int upCommitHash, int downCommitHash, @NotNull Collection<VcsRef> refs, int oneOfHeads) {
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/vcs/log/graph/elements/Branch", "<init>"));
        }
        this.upCommitHash = upCommitHash;
        this.downCommitHash = downCommitHash;
        this.myOneOfHeads = oneOfHeads;
        this.myColoredRef = Branch.findRefForBranchColor(refs);
    }

    @Nullable
    private static VcsRef findRefForBranchColor(@NotNull Collection<VcsRef> refs) {
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graph/elements/Branch", "findRefForBranchColor"));
        }
        return (VcsRef)ContainerUtil.find(refs, (Condition)new Condition<VcsRef>(){

            public boolean value(VcsRef ref) {
                return ref.getType().isBranch();
            }
        });
    }

    public Branch(int commit, @NotNull Collection<VcsRef> refs, int oneOfHeads) {
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/graph/elements/Branch", "<init>"));
        }
        this(commit, commit, refs, oneOfHeads);
    }

    public int getUpCommitHash() {
        return this.upCommitHash;
    }

    public int getDownCommitHash() {
        return this.downCommitHash;
    }

    public int getBranchNumber() {
        if (this.myColoredRef == null) {
            return this.upCommitHash + 73 * this.downCommitHash;
        }
        return this.myColoredRef.getName().hashCode();
    }

    public int hashCode() {
        return this.upCommitHash + 73 * this.downCommitHash;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass() == Branch.class) {
            Branch anBranch = (Branch)obj;
            return anBranch.upCommitHash == this.upCommitHash && anBranch.downCommitHash == this.downCommitHash;
        }
        return false;
    }

    public String toString() {
        if (this.upCommitHash == this.downCommitHash) {
            return String.valueOf(this.upCommitHash);
        }
        return String.valueOf(this.upCommitHash) + '#' + String.valueOf(this.downCommitHash);
    }

    public int getOneOfHeads() {
        return this.myOneOfHeads;
    }
}

