/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.compressedlist.UpdateRequest;
import com.intellij.vcs.log.graph.ChangeCursorActionRequest;
import com.intellij.vcs.log.graph.ClickGraphAction;
import com.intellij.vcs.log.graph.GraphAction;
import com.intellij.vcs.log.graph.GraphActionRequest;
import com.intellij.vcs.log.graph.GraphAnswer;
import com.intellij.vcs.log.graph.GraphChange;
import com.intellij.vcs.log.graph.GraphColorManager;
import com.intellij.vcs.log.graph.GraphFacade;
import com.intellij.vcs.log.graph.GraphInfoProvider;
import com.intellij.vcs.log.graph.JumpToRowActionRequest;
import com.intellij.vcs.log.graph.LinearBranchesExpansionAction;
import com.intellij.vcs.log.graph.LongEdgesAction;
import com.intellij.vcs.log.graph.MouseOverAction;
import com.intellij.vcs.log.graph.PaintInfo;
import com.intellij.vcs.log.graph.elements.Edge;
import com.intellij.vcs.log.graph.elements.GraphElement;
import com.intellij.vcs.log.graph.elements.Node;
import com.intellij.vcs.log.graph.elements.NodeRow;
import com.intellij.vcs.log.graph.render.SimpleGraphCellPainter;
import com.intellij.vcs.log.graphmodel.FragmentManager;
import com.intellij.vcs.log.graphmodel.GraphFragment;
import com.intellij.vcs.log.graphmodel.GraphModel;
import com.intellij.vcs.log.printmodel.GraphPrintCell;
import com.intellij.vcs.log.printmodel.GraphPrintCellModel;
import com.intellij.vcs.log.printmodel.SelectController;
import com.intellij.vcs.log.printmodel.SpecialPrintElement;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GraphFacadeImpl
implements GraphFacade {
    private static final Logger LOG = Logger.getInstance(GraphFacadeImpl.class);
    private static final Function<Node, Boolean> ALL_NODES_VISIBLE = new Function<Node, Boolean>(){

        public Boolean fun(Node node) {
            return true;
        }
    };
    private static final int IMAGE_WIDTH_RESERVE = 75;
    @NotNull
    private final GraphModel myGraphModel;
    @NotNull
    private final GraphPrintCellModel myPrintCellModel;
    @NotNull
    private final GraphColorManager myColorManager;
    @NotNull
    private final SimpleGraphCellPainter myGraphPainter;
    @Nullable
    private GraphElement prevGraphElement;

    public GraphFacadeImpl(@NotNull GraphModel graphModel, @NotNull GraphPrintCellModel printCellModel, @NotNull GraphColorManager colorManager) {
        if (graphModel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graph/GraphFacadeImpl", "<init>"));
        }
        if (printCellModel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/graph/GraphFacadeImpl", "<init>"));
        }
        if (colorManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/vcs/log/graph/GraphFacadeImpl", "<init>"));
        }
        this.myGraphModel = graphModel;
        this.myPrintCellModel = printCellModel;
        this.myColorManager = colorManager;
        this.myGraphPainter = new SimpleGraphCellPainter();
    }

    @NotNull
    public PaintInfo paint(int visibleRow) {
        GraphPrintCell cell = this.myPrintCellModel.getGraphPrintCell(visibleRow);
        int imageWidth = GraphFacadeImpl.calcImageWidth(cell);
        int bufferWidth = imageWidth + 75;
        BufferedImage image = UIUtil.createImage((int)bufferWidth, (int)22, (int)2);
        Graphics2D g2 = image.createGraphics();
        this.myGraphPainter.draw(g2, cell);
        PaintInfoImpl paintInfoImpl = new PaintInfoImpl(image, imageWidth);
        if (paintInfoImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/GraphFacadeImpl", "paint"));
        }
        return paintInfoImpl;
    }

    private static int calcImageWidth(@NotNull GraphPrintCell cell) {
        if (cell == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graph/GraphFacadeImpl", "calcImageWidth"));
        }
        return cell.countCell() * 15;
    }

    @Nullable
    public GraphAnswer performAction(@NotNull GraphAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graph/GraphFacadeImpl", "performAction"));
        }
        if (action instanceof LinearBranchesExpansionAction) {
            FragmentManager fragmentManager = this.myGraphModel.getFragmentManager();
            if (((LinearBranchesExpansionAction)action).shouldExpand()) {
                fragmentManager.showAll();
            } else {
                fragmentManager.hideAll();
            }
        } else if (action instanceof LongEdgesAction) {
            this.myPrintCellModel.setLongEdgeVisibility(((LongEdgesAction)action).shouldShowLongEdges());
        } else {
            if (action instanceof ClickGraphAction) {
                return this.handleClick((ClickGraphAction)action);
            }
            if (action instanceof MouseOverAction) {
                return this.handleMouseOver((MouseOverAction)action);
            }
        }
        return null;
    }

    @Nullable
    private GraphAnswer handleMouseOver(MouseOverAction action) {
        GraphPrintCell printCell = this.myPrintCellModel.getGraphPrintCell(action.getRow());
        Node jumpToNode = this.arrowToNode(action.getRelativePoint(), printCell);
        if (jumpToNode != null) {
            this.over(null);
            return new ChangeCursorAnswer(Cursor.getPredefinedCursor(12));
        }
        this.over(this.overCell(action.getRelativePoint(), printCell));
        return new ChangeCursorAnswer(Cursor.getDefaultCursor());
    }

    @Nullable
    private GraphAnswer handleClick(@NotNull ClickGraphAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graph/GraphFacadeImpl", "handleClick"));
        }
        if (action.getRelativePoint() == null) {
            return this.handleRowSelection(action.getRow());
        }
        GraphPrintCell printCell = this.myPrintCellModel.getGraphPrintCell(action.getRow());
        return this.handleMouseClick(action.getRow(), action.getRelativePoint(), printCell);
    }

    @Nullable
    private GraphAnswer handleRowSelection(int row) {
        this.myPrintCellModel.getCommitSelectController().deselectAll();
        Node node = this.myGraphModel.getGraph().getCommitNodeInRow(row);
        if (node != null) {
            FragmentManager fragmentController = this.myGraphModel.getFragmentManager();
            this.myPrintCellModel.getCommitSelectController().select(fragmentController.allCommitsCurrentBranch(node));
        }
        return null;
    }

    @Nullable
    private GraphAnswer handleMouseClick(int row, @NotNull Point point, @Nullable GraphPrintCell printCell) {
        if (point == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/graph/GraphFacadeImpl", "handleMouseClick"));
        }
        Node jumpToNode = this.arrowToNode(point, printCell);
        if (jumpToNode != null) {
            return new JumpToRowAnswer(jumpToNode.getRowIndex());
        }
        GraphElement graphElement = this.overCell(point, printCell);
        this.myPrintCellModel.getSelectController().deselectAll();
        if (graphElement == null) {
            return this.handleRowSelection(row);
        }
        return this.click(graphElement);
    }

    @Nullable
    private Node arrowToNode(@NotNull Point point, @Nullable GraphPrintCell row) {
        if (point == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graph/GraphFacadeImpl", "arrowToNode"));
        }
        if (row == null) {
            return null;
        }
        SpecialPrintElement printElement = this.myGraphPainter.mouseOverArrow(row, point.x, point.y);
        if (printElement == null) {
            return null;
        }
        Edge edge = printElement.getGraphElement().getEdge();
        if (edge == null) {
            return null;
        }
        return printElement.getType() == SpecialPrintElement.Type.DOWN_ARROW ? edge.getDownNode() : edge.getUpNode();
    }

    @Nullable
    public GraphAnswer click(@Nullable GraphElement graphElement) {
        FragmentManager fragmentController = this.myGraphModel.getFragmentManager();
        if (graphElement == null) {
            return null;
        }
        GraphFragment fragment = fragmentController.relateFragment(graphElement);
        if (fragment == null) {
            return null;
        }
        UpdateRequest updateRequest = fragmentController.changeVisibility(fragment);
        return new JumpToRowAnswer(updateRequest.from());
    }

    public void over(@Nullable GraphElement graphElement) {
        SelectController selectController = this.myPrintCellModel.getSelectController();
        FragmentManager fragmentManager = this.myGraphModel.getFragmentManager();
        if (graphElement == this.prevGraphElement) {
            return;
        }
        this.prevGraphElement = graphElement;
        selectController.deselectAll();
        if (graphElement != null) {
            GraphFragment graphFragment = fragmentManager.relateFragment(graphElement);
            selectController.select(graphFragment);
        }
    }

    @NotNull
    public List<Integer> getAllCommits() {
        throw new UnsupportedOperationException();
    }

    @Nullable
    private GraphElement overCell(@NotNull Point point, @Nullable GraphPrintCell row) {
        if (point == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graph/GraphFacadeImpl", "overCell"));
        }
        int y = point.y;
        int x = point.x;
        return row != null ? this.myGraphPainter.mouseOver(row, x, y) : null;
    }

    public int getCommitAtRow(int visibleRow) {
        NodeRow row = this.myGraphModel.getGraph().getNodeRows().get(visibleRow);
        return GraphFacadeImpl.getCommit(row);
    }

    private static int getCommit(@NotNull NodeRow nodeRow) {
        if (nodeRow == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graph/GraphFacadeImpl", "getCommit"));
        }
        List<Node> nodes = nodeRow.getNodes();
        if (nodes.size() < 1) {
            LOG.error("No nodes for nodeRow: " + nodeRow);
            return -1;
        }
        if (nodes.size() > 1 && GraphFacadeImpl.existsNotEndNode(nodes)) {
            LOG.error("Too many nodes for nodeRow: " + nodeRow);
        }
        return nodes.get(0).getCommitIndex();
    }

    public int getVisibleCommitCount() {
        return this.myGraphModel.getGraph().getNodeRows().size();
    }

    private static boolean existsNotEndNode(@NotNull List<Node> nodes) {
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graph/GraphFacadeImpl", "existsNotEndNode"));
        }
        return ContainerUtil.exists(nodes, (Condition)new Condition<Node>(){

            public boolean value(Node node) {
                return node.getType() != Node.NodeType.END_COMMIT_NODE;
            }
        });
    }

    public void setVisibleBranches(final @Nullable Collection<Integer> heads) {
        this.myGraphModel.setVisibleBranchesNodes(heads == null ? ALL_NODES_VISIBLE : new Function<Node, Boolean>(){

            public Boolean fun(Node node) {
                return heads.contains(node.getCommitIndex());
            }
        });
    }

    public void setFilter(@NotNull Condition<Integer> visibilityPredicate) {
        if (visibilityPredicate == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graph/GraphFacadeImpl", "setFilter"));
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public GraphInfoProvider getInfoProvider() {
        GraphInfoProviderImpl graphInfoProviderImpl = new GraphInfoProviderImpl();
        if (graphInfoProviderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/GraphFacadeImpl", "getInfoProvider"));
        }
        return graphInfoProviderImpl;
    }

    private static class PaintInfoImpl
    implements PaintInfo {
        private final Image myImage;
        private final int myWidth;

        public PaintInfoImpl(Image image, int width) {
            this.myImage = image;
            this.myWidth = width;
        }

        @NotNull
        public Image getImage() {
            Image image = this.myImage;
            if (image == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/GraphFacadeImpl$PaintInfoImpl", "getImage"));
            }
            return image;
        }

        public int getWidth() {
            return this.myWidth;
        }
    }

    private static class ChangeCursorAnswer
    implements GraphAnswer {
        private final Cursor myCursor;

        public ChangeCursorAnswer(@NotNull Cursor cursor) {
            if (cursor == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graph/GraphFacadeImpl$ChangeCursorAnswer", "<init>"));
            }
            this.myCursor = cursor;
        }

        @Nullable
        public GraphChange getGraphChange() {
            return null;
        }

        @Nullable
        public GraphActionRequest getActionRequest() {
            return new ChangeCursorActionRequest(this.myCursor);
        }
    }

    private static class JumpToRowAnswer
    implements GraphAnswer {
        private final int myRow;

        public JumpToRowAnswer(int row) {
            this.myRow = row;
        }

        @Nullable
        public GraphChange getGraphChange() {
            return null;
        }

        @Nullable
        public GraphActionRequest getActionRequest() {
            return new JumpToRowActionRequest(this.myRow);
        }
    }

    private class RowInfoImpl
    implements GraphInfoProvider.RowInfo {
        private final int myVisibleRow;

        public RowInfoImpl(int visibleRow) {
            this.myVisibleRow = visibleRow;
        }

        public int getOneOfHeads() {
            Node node = GraphFacadeImpl.this.myGraphModel.getGraph().getCommitNodeInRow(this.myVisibleRow);
            assert (node != null) : "node is null for row " + this.myVisibleRow;
            return node.getBranch().getOneOfHeads();
        }
    }

    private class GraphInfoProviderImpl
    implements GraphInfoProvider {
        private GraphInfoProviderImpl() {
        }

        @NotNull
        public Set<Integer> getContainingBranches(int visibleRow) {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public GraphInfoProvider.RowInfo getRowInfo(int visibleRow) {
            RowInfoImpl rowInfoImpl = new RowInfoImpl(visibleRow);
            if (rowInfoImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/GraphFacadeImpl$GraphInfoProviderImpl", "getRowInfo"));
            }
            return rowInfoImpl;
        }

        public boolean areLongEdgesHidden() {
            return GraphFacadeImpl.this.myPrintCellModel.areLongEdgesHidden();
        }
    }
}

