/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Interner;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.impl.VcsUserImpl;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;

public class VcsUserRegistry {
    private final Interner<VcsUser> myUserMap = new Interner();
    private final ReadWriteLock myLock = new ReentrantReadWriteLock();

    @NotNull
    public VcsUser createUser(@NotNull String name, @NotNull String email) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/data/VcsUserRegistry", "createUser"));
        }
        if (email == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/data/VcsUserRegistry", "createUser"));
        }
        VcsUser vcsUser = this.addUser(new VcsUserImpl(name, email));
        if (vcsUser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsUserRegistry", "createUser"));
        }
        return vcsUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public VcsUser addUser(@NotNull VcsUser user) {
        if (user == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/data/VcsUserRegistry", "addUser"));
        }
        this.myLock.writeLock().lock();
        VcsUser vcsUser = (VcsUser)this.myUserMap.intern((Object)user);
        VcsUser vcsUser2 = vcsUser;
        if (vcsUser2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsUserRegistry", "addUser"));
        }
        return vcsUser2;
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Set<VcsUser> getUsers() {
        this.myLock.readLock().lock();
        HashSet hashSet = ContainerUtil.newHashSet((Iterable)this.myUserMap.getValues());
        HashSet hashSet2 = hashSet;
        if (hashSet2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsUserRegistry", "getUsers"));
        }
        return hashSet2;
        finally {
            this.myLock.readLock().unlock();
        }
    }
}

