/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentEnumerator;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.impl.HashImpl;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class VcsLogHashMap
implements Disposable {
    private static final File LOG_CACHE_APP_DIR = new File(PathManager.getSystemPath(), "vcs-log");
    private static final Logger LOG = Logger.getInstance(VcsLogHashMap.class);
    private final PersistentEnumerator<Hash> myPersistentEnumerator;

    VcsLogHashMap(@NotNull Project project) throws IOException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/data/VcsLogHashMap", "<init>"));
        }
        final File myMapFile = new File(LOG_CACHE_APP_DIR, project.getName() + "." + project.getLocationHash());
        this.myPersistentEnumerator = (PersistentEnumerator)IOUtil.openCleanOrResetBroken((ThrowableComputable)new ThrowableComputable<PersistentEnumerator<Hash>, IOException>(){

            public PersistentEnumerator<Hash> compute() throws IOException {
                return new PersistentEnumerator(myMapFile, (KeyDescriptor)new MyHashKeyDescriptor(), 4096);
            }
        }, (File)myMapFile);
    }

    @Nullable
    Hash getHash(int index) throws IOException {
        return (Hash)this.myPersistentEnumerator.valueOf(index);
    }

    int getOrPut(@NotNull Hash hash) throws IOException {
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/data/VcsLogHashMap", "getOrPut"));
        }
        return this.myPersistentEnumerator.enumerate((Object)hash);
    }

    void flush() {
        this.myPersistentEnumerator.force();
    }

    public void dispose() {
        try {
            this.myPersistentEnumerator.close();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    @Nullable
    Hash findHash(final @NotNull Condition<Hash> condition) throws IOException {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/data/VcsLogHashMap", "findHash"));
        }
        final Ref hashRef = Ref.create();
        this.myPersistentEnumerator.iterateData((Processor)new CommonProcessors.FindProcessor<Hash>(){

            protected boolean accept(Hash hash) {
                boolean matches = condition.value((Object)hash);
                if (matches) {
                    hashRef.set((Object)hash);
                }
                return matches;
            }
        });
        return (Hash)hashRef.get();
    }

    private static class MyHashKeyDescriptor
    implements KeyDescriptor<Hash> {
        private MyHashKeyDescriptor() {
        }

        public void save(@NotNull DataOutput out, Hash value) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/data/VcsLogHashMap$MyHashKeyDescriptor", "save"));
            }
            out.writeUTF(value.asString());
        }

        public Hash read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/data/VcsLogHashMap$MyHashKeyDescriptor", "read"));
            }
            return HashImpl.build(in.readUTF());
        }

        public int getHashCode(Hash value) {
            return value.hashCode();
        }

        public boolean isEqual(Hash val1, Hash val2) {
            return val1.equals(val2);
        }
    }
}

