/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Ref;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.InvalidRequestException;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogDetailsFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.LoadMoreStage;
import com.intellij.vcs.log.data.VcsLogDataHolder;
import com.intellij.vcs.log.graph.GraphFacade;
import com.intellij.vcs.log.impl.VcsLogUtil;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.ui.tables.AbstractVcsLogTableModel;
import com.intellij.vcs.log.ui.tables.EmptyTableModel;
import com.intellij.vcs.log.ui.tables.GraphTableModel;
import gnu.trove.TIntHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogFilterer {
    private static final Logger LOG = Logger.getInstance(VcsLogFilterer.class);
    private static final int LOAD_MORE_COMMITS_FIRST_STEP_LIMIT = 200;
    @NotNull
    private final VcsLogDataHolder myLogDataHolder;
    @NotNull
    private final VcsLogUiImpl myUI;

    public VcsLogFilterer(@NotNull VcsLogDataHolder logDataHolder, @NotNull VcsLogUiImpl ui) {
        if (logDataHolder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/data/VcsLogFilterer", "<init>"));
        }
        if (ui == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/data/VcsLogFilterer", "<init>"));
        }
        this.myLogDataHolder = logDataHolder;
        this.myUI = ui;
    }

    @NotNull
    public AbstractVcsLogTableModel applyFiltersAndUpdateUi(@NotNull DataPack dataPack, @NotNull VcsLogFilterCollection filters) {
        if (dataPack == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/data/VcsLogFilterer", "applyFiltersAndUpdateUi"));
        }
        if (filters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/data/VcsLogFilterer", "applyFiltersAndUpdateUi"));
        }
        VcsLogFilterer.resetFilters(dataPack);
        List detailsFilters = filters.getDetailsFilters();
        this.applyGraphFilters(dataPack, filters.getBranchFilter());
        AbstractVcsLogTableModel abstractVcsLogTableModel = this.applyDetailsFilter(dataPack, detailsFilters);
        if (abstractVcsLogTableModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogFilterer", "applyFiltersAndUpdateUi"));
        }
        return abstractVcsLogTableModel;
    }

    private static void resetFilters(@NotNull DataPack dataPack) {
        if (dataPack == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/data/VcsLogFilterer", "resetFilters"));
        }
        GraphFacade facade = dataPack.getGraphFacade();
        facade.setVisibleBranches(null);
        facade.setFilter(null);
    }

    private AbstractVcsLogTableModel applyDetailsFilter(DataPack dataPack, List<VcsLogDetailsFilter> detailsFilters) {
        if (!detailsFilters.isEmpty()) {
            List<Hash> filteredCommits = this.filterInMemory(dataPack, detailsFilters);
            if (filteredCommits.isEmpty()) {
                return new EmptyTableModel(dataPack, this.myLogDataHolder, this.myUI, LoadMoreStage.INITIAL);
            }
            Condition<Integer> filter = this.getFilterFromCommits(filteredCommits);
            dataPack.getGraphFacade().setFilter(filter);
        } else {
            dataPack.getGraphFacade().setFilter(null);
        }
        return new GraphTableModel(dataPack, this.myLogDataHolder, this.myUI, LoadMoreStage.INITIAL);
    }

    private Condition<Integer> getFilterFromCommits(List<Hash> filteredCommits) {
        final Set commitSet = ContainerUtil.map2Set(filteredCommits, (Function)new Function<Hash, Integer>(){

            public Integer fun(Hash hash) {
                return VcsLogFilterer.this.myLogDataHolder.getCommitIndex(hash);
            }
        });
        return new Condition<Integer>(){

            public boolean value(Integer integer) {
                return commitSet.contains(integer);
            }
        };
    }

    public void requestVcs(final @NotNull DataPack dataPack, @NotNull VcsLogFilterCollection filters, final @NotNull LoadMoreStage loadMoreStage, final @NotNull Runnable onSuccess) {
        if (dataPack == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/data/VcsLogFilterer", "requestVcs"));
        }
        if (filters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/data/VcsLogFilterer", "requestVcs"));
        }
        if (loadMoreStage == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/vcs/log/data/VcsLogFilterer", "requestVcs"));
        }
        if (onSuccess == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/vcs/log/data/VcsLogFilterer", "requestVcs"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        int maxCount = loadMoreStage == LoadMoreStage.INITIAL ? 200 : -1;
        this.myLogDataHolder.getFilteredDetailsFromTheVcs(filters, new Consumer<List<Hash>>(){

            public void consume(List<Hash> hashes) {
                AbstractVcsLogTableModel model;
                LoadMoreStage newLoadMoreStage = VcsLogFilterer.advanceLoadMoreStage(loadMoreStage);
                TIntHashSet previouslySelected = VcsLogFilterer.this.myUI.getSelectedCommits();
                if (hashes.isEmpty()) {
                    model = new EmptyTableModel(dataPack, VcsLogFilterer.this.myLogDataHolder, VcsLogFilterer.this.myUI, newLoadMoreStage);
                } else {
                    dataPack.getGraphFacade().setFilter(VcsLogFilterer.this.getFilterFromCommits(hashes));
                    model = new GraphTableModel(dataPack, VcsLogFilterer.this.myLogDataHolder, VcsLogFilterer.this.myUI, newLoadMoreStage);
                }
                VcsLogFilterer.this.myUI.setModel(model, dataPack, previouslySelected);
                VcsLogFilterer.this.myUI.repaintUI();
                onSuccess.run();
            }
        }, maxCount);
    }

    @NotNull
    private static LoadMoreStage advanceLoadMoreStage(@NotNull LoadMoreStage loadMoreStage) {
        LoadMoreStage newLoadMoreStage;
        if (loadMoreStage == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/data/VcsLogFilterer", "advanceLoadMoreStage"));
        }
        if (loadMoreStage == LoadMoreStage.INITIAL) {
            newLoadMoreStage = LoadMoreStage.LOADED_MORE;
        } else if (loadMoreStage == LoadMoreStage.LOADED_MORE) {
            newLoadMoreStage = LoadMoreStage.ALL_REQUESTED;
        } else {
            LOG.warn("Incorrect previous load more stage: " + (Object)((Object)loadMoreStage));
            newLoadMoreStage = LoadMoreStage.ALL_REQUESTED;
        }
        LoadMoreStage loadMoreStage2 = newLoadMoreStage;
        if (loadMoreStage2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogFilterer", "advanceLoadMoreStage"));
        }
        return loadMoreStage2;
    }

    private void applyGraphFilters(@NotNull DataPack dataPack, @Nullable VcsLogBranchFilter branchFilter) {
        if (dataPack == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/data/VcsLogFilterer", "applyGraphFilters"));
        }
        try {
            dataPack.getGraphFacade().setVisibleBranches(branchFilter != null ? VcsLogFilterer.getMatchingHeads(dataPack, branchFilter) : null);
        }
        catch (InvalidRequestException e) {
            if (!this.myLogDataHolder.isFullLogShowing()) {
                this.myLogDataHolder.showFullLog(EmptyRunnable.getInstance());
                throw new ProcessCanceledException();
            }
            throw e;
        }
    }

    @NotNull
    private static Collection<Integer> getMatchingHeads(@NotNull DataPack dataPack, @NotNull VcsLogBranchFilter branchFilter) {
        if (dataPack == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/data/VcsLogFilterer", "getMatchingHeads"));
        }
        if (branchFilter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/data/VcsLogFilterer", "getMatchingHeads"));
        }
        HashSet branchNames = new HashSet(branchFilter.getBranchNames());
        List list = ContainerUtil.mapNotNull(dataPack.getRefsModel().getAllRefs(), (Function)new Function<VcsRef, Integer>((Collection)branchNames){
            final /* synthetic */ Collection val$branchNames;
            {
                this.val$branchNames = collection;
            }

            public Integer fun(VcsRef ref) {
                if (this.val$branchNames.contains(ref.getName())) {
                    return ref.getCommitIndex();
                }
                return null;
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogFilterer", "getMatchingHeads"));
        }
        return list;
    }

    @NotNull
    private List<Hash> filterInMemory(@NotNull DataPack dataPack, @NotNull List<VcsLogDetailsFilter> detailsFilters) {
        int visibleCommit;
        VcsCommitMetadata data;
        if (dataPack == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/data/VcsLogFilterer", "filterInMemory"));
        }
        if (detailsFilters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/data/VcsLogFilterer", "filterInMemory"));
        }
        ArrayList result = ContainerUtil.newArrayList();
        Iterator<Integer> i$ = VcsLogUtil.getVisibleCommits(dataPack.getGraphFacade()).iterator();
        while (i$.hasNext() && (data = this.getDetailsFromCache(visibleCommit = i$.next().intValue())) != null) {
            if (!VcsLogFilterer.matchesAllFilters(data, detailsFilters)) continue;
            result.add(data.getHash());
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogFilterer", "filterInMemory"));
        }
        return arrayList;
    }

    private static boolean matchesAllFilters(final @NotNull VcsCommitMetadata commit, @NotNull List<VcsLogDetailsFilter> detailsFilters) {
        if (commit == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/data/VcsLogFilterer", "matchesAllFilters"));
        }
        if (detailsFilters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/data/VcsLogFilterer", "matchesAllFilters"));
        }
        return !ContainerUtil.exists(detailsFilters, (Condition)new Condition<VcsLogDetailsFilter>(){

            public boolean value(VcsLogDetailsFilter filter) {
                return !filter.matches(commit);
            }
        });
    }

    @Nullable
    private VcsCommitMetadata getDetailsFromCache(int commitIndex) {
        final Hash hash = this.myLogDataHolder.getHash(commitIndex);
        VcsCommitMetadata details = this.myLogDataHolder.getTopCommitDetails(hash);
        if (details != null) {
            return details;
        }
        final Ref ref = Ref.create();
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                ref.set(VcsLogFilterer.this.myLogDataHolder.getCommitDetailsGetter().getCommitDataIfAvailable(hash));
            }
        });
        return (VcsCommitMetadata)ref.get();
    }
}

