/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.BackgroundTaskQueue;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.PairConsumer;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.GraphCommit;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogDataProvider;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogSettings;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.data.CommitDetailsGetter;
import com.intellij.vcs.log.data.ContainingBranchesGetter;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.MiniDetailsGetter;
import com.intellij.vcs.log.data.VcsLogHashMap;
import com.intellij.vcs.log.data.VcsLogJoiner;
import com.intellij.vcs.log.data.VcsLogMultiRepoJoiner;
import com.intellij.vcs.log.data.VcsLogRefreshListener;
import com.intellij.vcs.log.data.VcsLogSorter;
import com.intellij.vcs.log.data.VcsUserRegistry;
import com.intellij.vcs.log.util.StopWatch;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogDataHolder
implements Disposable,
VcsLogDataProvider {
    public static final Topic<VcsLogRefreshListener> REFRESH_COMPLETED = Topic.create((String)"Vcs.Log.Completed", VcsLogRefreshListener.class);
    private static final Logger LOG = Logger.getInstance(VcsLogDataHolder.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final VcsLogObjectsFactory myFactory;
    @NotNull
    private final Map<VirtualFile, VcsLogProvider> myLogProviders;
    @NotNull
    private final BackgroundTaskQueue myDataLoaderQueue;
    @NotNull
    private final MiniDetailsGetter myMiniDetailsGetter;
    @NotNull
    private final CommitDetailsGetter myDetailsGetter;
    @NotNull
    private final VcsLogJoiner myLogJoiner;
    @NotNull
    private final VcsLogMultiRepoJoiner myMultiRepoJoiner;
    @NotNull
    private final VcsLogSettings mySettings;
    private final Map<VirtualFile, VcsUser> myCurrentUser;
    private volatile LogData myLogData;
    private volatile boolean myFullLogShowing;
    @NotNull
    private final Map<Hash, VcsCommitMetadata> myTopCommitsDetailsCache;
    private final AtomicBoolean myLoadMoreInProgress;
    private CountDownLatch myEntireLogLoadWaiter;
    private final VcsUserRegistry myUserRegistry;
    private final VcsLogHashMap myHashMap;
    private final NotNullFunction<Integer, Hash> myHashGetter;
    private final NotNullFunction<Hash, Integer> myIndexGetter;
    private final ContainingBranchesGetter myContainingBranchesGetter;

    public VcsLogDataHolder(@NotNull Project project, @NotNull Disposable parentDisposable, @NotNull Map<VirtualFile, VcsLogProvider> logProviders, @NotNull VcsLogSettings settings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/data/VcsLogDataHolder", "<init>"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/data/VcsLogDataHolder", "<init>"));
        }
        if (logProviders == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/vcs/log/data/VcsLogDataHolder", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/vcs/log/data/VcsLogDataHolder", "<init>"));
        }
        this.myCurrentUser = ContainerUtil.newHashMap();
        this.myTopCommitsDetailsCache = ContainerUtil.newConcurrentMap();
        this.myLoadMoreInProgress = new AtomicBoolean(false);
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.myProject = project;
        this.myLogProviders = logProviders;
        this.myDataLoaderQueue = new BackgroundTaskQueue(project, "Loading history...");
        this.myMiniDetailsGetter = new MiniDetailsGetter(this, logProviders);
        this.myDetailsGetter = new CommitDetailsGetter(this, logProviders);
        this.myLogJoiner = new VcsLogJoiner();
        this.myMultiRepoJoiner = new VcsLogMultiRepoJoiner();
        this.myFactory = (VcsLogObjectsFactory)ServiceManager.getService((Project)this.myProject, VcsLogObjectsFactory.class);
        this.mySettings = settings;
        this.myUserRegistry = new VcsUserRegistry();
        try {
            this.myHashMap = new VcsLogHashMap(this.myProject);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.myHashGetter = new NotNullFunction<Integer, Hash>(){

            @NotNull
            public Hash fun(Integer integer) {
                Hash hash = VcsLogDataHolder.this.getHash(integer);
                if (hash == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogDataHolder$1", "fun"));
                }
                return hash;
            }
        };
        this.myIndexGetter = new NotNullFunction<Hash, Integer>(){

            @NotNull
            public Integer fun(Hash hash) {
                Integer n = VcsLogDataHolder.this.getCommitIndex(hash);
                if (n == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogDataHolder$2", "fun"));
                }
                return n;
            }
        };
        this.myContainingBranchesGetter = new ContainingBranchesGetter(this, this);
    }

    @NotNull
    public Hash getHash(int commitIndex) {
        Hash hash;
        try {
            Hash hash2 = this.myHashMap.getHash(commitIndex);
            if (hash2 == null) {
                throw new RuntimeException("Unknown commit index: " + commitIndex);
            }
            hash = hash2;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (hash == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogDataHolder", "getHash"));
        }
        return hash;
    }

    public int getCommitIndex(@NotNull Hash hash) {
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/data/VcsLogDataHolder", "getCommitIndex"));
        }
        try {
            return this.myHashMap.getOrPut(hash);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void initialize(final @NotNull PairConsumer<VcsLogDataHolder, DataPack> onInitialized) {
        if (onInitialized == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/data/VcsLogDataHolder", "initialize"));
        }
        final StopWatch initSw = StopWatch.start("initialize");
        this.myDataLoaderQueue.clear();
        this.runInBackground(new ThrowableConsumer<ProgressIndicator, VcsException>(){

            public void consume(ProgressIndicator indicator) throws VcsException {
                VcsLogDataHolder.this.resetState();
                VcsLogDataHolder.this.readCurrentUser();
                VcsLogDataHolder.this.loadFromVcs(VcsLogDataHolder.this.mySettings.getRecentCommitsCount(), indicator, (Consumer<DataPack>)((Consumer)new Consumer<DataPack>(){

                    public void consume(DataPack dataPack) {
                        VcsLogDataHolder.this.myEntireLogLoadWaiter.countDown();
                        VcsLogDataHolder.this.myEntireLogLoadWaiter = new CountDownLatch(1);
                        onInitialized.consume((Object)VcsLogDataHolder.this, (Object)dataPack);
                        VcsLogDataHolder.this.loadAllLog();
                    }
                }));
                initSw.report();
            }
        }, "Loading recent history...");
    }

    private void readCurrentUser() {
        StopWatch sw = StopWatch.start("readCurrentUser");
        for (Map.Entry<VirtualFile, VcsLogProvider> entry : this.myLogProviders.entrySet()) {
            VirtualFile root = entry.getKey();
            try {
                VcsUser me = entry.getValue().getCurrentUser(root);
                if (me != null) {
                    this.myCurrentUser.put(root, me);
                    continue;
                }
                LOG.info("Username not configured for root " + root);
            }
            catch (VcsException e) {
                LOG.warn("Couldn't read the username from root " + root, (Throwable)e);
            }
        }
        sw.report();
    }

    private void resetState() {
        this.myFullLogShowing = false;
        this.myTopCommitsDetailsCache.clear();
        this.myLoadMoreInProgress.set(false);
        if (this.myEntireLogLoadWaiter != null) {
            this.myEntireLogLoadWaiter.countDown();
        }
        this.myEntireLogLoadWaiter = new CountDownLatch(1);
    }

    private void loadAllLog() {
        this.runInBackground(new ThrowableConsumer<ProgressIndicator, VcsException>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void consume(ProgressIndicator indicator) throws VcsException {
                StopWatch methodLog = StopWatch.start("loadAllLog");
                try {
                    Consumer<VcsUser> userRegistry = new Consumer<VcsUser>(){

                        public void consume(VcsUser user) {
                            VcsLogDataHolder.this.myUserRegistry.addUser(user);
                        }
                    };
                    HashMap logs = ContainerUtil.newHashMap();
                    HashMap refs = ContainerUtil.newHashMap();
                    for (Map.Entry entry : VcsLogDataHolder.this.myLogProviders.entrySet()) {
                        VirtualFile root = (VirtualFile)entry.getKey();
                        VcsLogProvider logProvider = (VcsLogProvider)entry.getValue();
                        StopWatch sw = StopWatch.start("readAllHashes for " + root.getName());
                        List allCommits = logProvider.readAllHashes(root, (Consumer)userRegistry);
                        sw.report();
                        logs.put(root, VcsLogDataHolder.this.compactHashes(allCommits));
                        refs.put(root, logProvider.readAllRefs(root));
                    }
                    DataPack existingDataPack = VcsLogDataHolder.this.myLogData.getDataPack();
                    VcsLogDataHolder.this.myLogData = new LogData(logs, refs, VcsLogDataHolder.this.myLogData.getTopCommits(), existingDataPack, true);
                    methodLog.report();
                }
                finally {
                    VcsLogDataHolder.this.myEntireLogLoadWaiter.countDown();
                }
            }
        }, "Loading log structure...");
    }

    @NotNull
    private List<CompactCommit> compactHashes(@NotNull List<? extends TimedVcsCommit> commits) {
        if (commits == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/data/VcsLogDataHolder", "compactHashes"));
        }
        List compactedHashes = ContainerUtil.map(commits, (Function)new Function<TimedVcsCommit, CompactCommit>(){

            public CompactCommit fun(TimedVcsCommit commit) {
                return commit instanceof CompactCommit ? (CompactCommit)commit : new CompactCommit(commit);
            }
        });
        this.myHashMap.flush();
        List list = compactedHashes;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogDataHolder", "compactHashes"));
        }
        return list;
    }

    public void showFullLog(final @NotNull Runnable onSuccess) {
        if (onSuccess == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/data/VcsLogDataHolder", "showFullLog"));
        }
        if (this.myFullLogShowing) {
            return;
        }
        this.runInBackground(new ThrowableConsumer<ProgressIndicator, VcsException>(){

            public void consume(ProgressIndicator indicator) throws VcsException {
                if (VcsLogDataHolder.this.myFullLogShowing) {
                    return;
                }
                List<? extends TimedVcsCommit> compoundLog = VcsLogDataHolder.this.myMultiRepoJoiner.join(VcsLogDataHolder.this.myLogData.myLogsByRoot.values());
                final DataPack fullDataPack = DataPack.build(VcsLogDataHolder.this.convertToGraphCommits(compoundLog), VcsLogDataHolder.this.myLogData.getAllRefs(), indicator, (NotNullFunction<Hash, Integer>)VcsLogDataHolder.this.myIndexGetter, (NotNullFunction<Integer, Hash>)VcsLogDataHolder.this.myHashGetter, VcsLogDataHolder.this.myLogProviders);
                VcsLogDataHolder.this.myLogData = new LogData(VcsLogDataHolder.this.myLogData.getLogs(), VcsLogDataHolder.this.myLogData.getRefs(), VcsLogDataHolder.this.myLogData.getTopCommits(), fullDataPack, true);
                VcsLogDataHolder.this.myFullLogShowing = true;
                VcsLogDataHolder.this.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        VcsLogDataHolder.this.notifyAboutDataRefresh(fullDataPack);
                        onSuccess.run();
                    }
                });
            }
        }, "Building full log...");
    }

    private List<? extends GraphCommit> convertToGraphCommits(List<? extends TimedVcsCommit> log) {
        return this.compactHashes(log);
    }

    public boolean isFullLogShowing() {
        return this.myFullLogShowing;
    }

    private void smartRefresh(ProgressIndicator indicator, Consumer<DataPack> onSuccess) throws VcsException {
        if (this.myLogData == null || !this.myLogData.isFullLogReady()) {
            LOG.error("The full log is not ready!");
        }
        StopWatch methodLog = StopWatch.start("smartRefresh");
        HashMap logsToBuild = ContainerUtil.newHashMap();
        HashMap refsByRoot = ContainerUtil.newHashMap();
        int topCommitCount = this.myLogData.getTopCommitsCount();
        for (Map.Entry<VirtualFile, RecentCommitsInfo> entry : this.collectInfoFromVcs(false, this.mySettings.getRecentCommitsCount())) {
            VirtualFile root = entry.getKey();
            RecentCommitsInfo info = entry.getValue();
            Collection<VcsRef> oldRefs = this.myLogData.getRefs(root);
            Pair<List<TimedVcsCommit>, Integer> joinResult = this.myLogJoiner.addCommits(this.myLogData.getLog(root), oldRefs, info.firstBlockCommits, info.newRefs);
            if (!Comparing.haveEqualElements(oldRefs, info.newRefs)) {
                this.myContainingBranchesGetter.clearCache();
            }
            List refreshedLog = (List)joinResult.getFirst();
            int newCommitsCount = (Integer)joinResult.getSecond();
            topCommitCount += newCommitsCount;
            logsToBuild.put(root, refreshedLog);
            refsByRoot.put(root, info.newRefs);
        }
        List<? extends TimedVcsCommit> compoundLog = this.myMultiRepoJoiner.join(logsToBuild.values());
        List<? extends TimedVcsCommit> topPartOfTheLog = compoundLog.subList(0, topCommitCount);
        List<? extends TimedVcsCommit> logToBuild = this.myFullLogShowing ? compoundLog : topPartOfTheLog;
        DataPack dataPack = DataPack.build(this.convertToGraphCommits(logToBuild), VcsLogDataHolder.collectAllRefs(refsByRoot), indicator, this.myIndexGetter, this.myHashGetter, this.myLogProviders);
        this.myLogData = new LogData(logsToBuild, refsByRoot, topPartOfTheLog, dataPack, true);
        this.handleOnSuccessInEdt(onSuccess, dataPack);
        methodLog.report();
    }

    private void loadFromVcs(int commitCount, ProgressIndicator indicator, Consumer<DataPack> onSuccess) throws VcsException {
        StopWatch methodSW = StopWatch.start("loadFromVcs");
        HashMap logsToBuild = ContainerUtil.newHashMap();
        HashMap refsByRoot = ContainerUtil.newHashMap();
        for (Map.Entry<VirtualFile, RecentCommitsInfo> entry : this.collectInfoFromVcs(true, commitCount)) {
            VirtualFile root = entry.getKey();
            RecentCommitsInfo info = entry.getValue();
            List<TimedVcsCommit> firstBlockCommits = info.firstBlockCommits;
            if (this.getLogProvider(root).supportsFastUnorderedCommits()) {
                firstBlockCommits = new VcsLogSorter<TimedVcsCommit>().sortByDateTopoOrder(firstBlockCommits);
                firstBlockCommits = new ArrayList<TimedVcsCommit>(firstBlockCommits.subList(0, Math.min(firstBlockCommits.size(), commitCount)));
            }
            logsToBuild.put(root, firstBlockCommits);
            refsByRoot.put(root, info.newRefs);
        }
        StopWatch sw = StopWatch.start("multi-repo join");
        List<? extends TimedVcsCommit> compoundLog = this.myMultiRepoJoiner.join(logsToBuild.values());
        sw.report();
        sw = StopWatch.start("DataPack.build");
        DataPack dataPack = DataPack.build(this.convertToGraphCommits(compoundLog), VcsLogDataHolder.collectAllRefs(refsByRoot), indicator, this.myIndexGetter, this.myHashGetter, this.myLogProviders);
        sw.report();
        this.myLogData = this.myLogData != null && this.myLogData.isFullLogReady() ? new LogData(this.myLogData.getLogs(), this.myLogData.getRefs(), compoundLog, dataPack, true) : new LogData(logsToBuild, refsByRoot, compoundLog, dataPack, false);
        this.myContainingBranchesGetter.clearCache();
        this.handleOnSuccessInEdt(onSuccess, dataPack);
        methodSW.report();
    }

    private Set<Map.Entry<VirtualFile, RecentCommitsInfo>> collectInfoFromVcs(boolean ordered, int commitsCount) throws VcsException {
        StopWatch methodTime = StopWatch.start("collectInfoFromVcs");
        HashMap infoByRoot = ContainerUtil.newHashMap();
        for (Map.Entry<VirtualFile, VcsLogProvider> entry : this.myLogProviders.entrySet()) {
            VirtualFile root = entry.getKey();
            VcsLogProvider logProvider = entry.getValue();
            StopWatch sw = StopWatch.start("readFirstBlock for " + root.getName());
            boolean orderedForRepo = ordered && !logProvider.supportsFastUnorderedCommits();
            int commitCountForRepo = orderedForRepo ? commitsCount : commitsCount * 2;
            List firstBlockDetails = logProvider.readFirstBlock(root, orderedForRepo, commitCountForRepo);
            sw.report();
            sw = StopWatch.start("readAllRefs for" + root.getName());
            Collection newRefs = logProvider.readAllRefs(root);
            sw.report();
            this.storeTopCommitsDetailsInCache(firstBlockDetails);
            this.storeUsers(firstBlockDetails);
            List<TimedVcsCommit> firstBlockCommits = this.getCommitsFromDetails(firstBlockDetails);
            infoByRoot.put(root, new RecentCommitsInfo(firstBlockCommits, newRefs));
        }
        methodTime.report();
        return infoByRoot.entrySet();
    }

    private void storeUsers(@NotNull List<? extends VcsCommitMetadata> details) {
        if (details == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/data/VcsLogDataHolder", "storeUsers"));
        }
        for (VcsCommitMetadata vcsCommitMetadata : details) {
            this.myUserRegistry.addUser(vcsCommitMetadata.getAuthor());
            this.myUserRegistry.addUser(vcsCommitMetadata.getCommitter());
        }
    }

    @NotNull
    public Set<VcsUser> getAllUsers() {
        Set<VcsUser> set = this.myUserRegistry.getUsers();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogDataHolder", "getAllUsers"));
        }
        return set;
    }

    public void getFilteredDetailsFromTheVcs(final @NotNull VcsLogFilterCollection filterCollection, final @NotNull Consumer<List<Hash>> success, final int maxCount) {
        if (filterCollection == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/data/VcsLogDataHolder", "getFilteredDetailsFromTheVcs"));
        }
        if (success == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/data/VcsLogDataHolder", "getFilteredDetailsFromTheVcs"));
        }
        this.runInBackground(new ThrowableConsumer<ProgressIndicator, VcsException>(){

            public void consume(ProgressIndicator indicator) throws VcsException {
                ArrayList logs = ContainerUtil.newArrayList();
                for (Map.Entry entry : VcsLogDataHolder.this.myLogProviders.entrySet()) {
                    VirtualFile root = (VirtualFile)entry.getKey();
                    if (filterCollection.getStructureFilter() != null && filterCollection.getStructureFilter().getFiles(root).isEmpty() || filterCollection.getUserFilter() != null && filterCollection.getUserFilter().getUserNames(root).isEmpty()) continue;
                    List matchingCommits = ((VcsLogProvider)entry.getValue()).getCommitsMatchingFilter(root, filterCollection, maxCount);
                    logs.add(matchingCommits);
                }
                List<? extends TimedVcsCommit> compoundLog = VcsLogDataHolder.this.myMultiRepoJoiner.join(logs);
                final List list = ContainerUtil.map(compoundLog, (Function)new Function<TimedVcsCommit, Hash>(){

                    public Hash fun(TimedVcsCommit commit) {
                        return commit.getHash();
                    }
                });
                VcsLogDataHolder.this.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        success.consume((Object)list);
                    }
                });
            }
        }, "Looking for more results...");
    }

    @NotNull
    public Map<VirtualFile, VcsUser> getCurrentUser() {
        Map<VirtualFile, VcsUser> map = this.myCurrentUser;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogDataHolder", "getCurrentUser"));
        }
        return map;
    }

    public boolean isMultiRoot() {
        return this.myLogProviders.size() > 1;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogDataHolder", "getProject"));
        }
        return project;
    }

    public VcsUserRegistry getUserRegistry() {
        return this.myUserRegistry;
    }

    @NotNull
    public Collection<VirtualFile> getRoots() {
        Set<VirtualFile> set = this.myLogProviders.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogDataHolder", "getRoots"));
        }
        return set;
    }

    @NotNull
    public Collection<VcsLogProvider> getLogProviders() {
        Collection<VcsLogProvider> collection = this.myLogProviders.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogDataHolder", "getLogProviders"));
        }
        return collection;
    }

    @NotNull
    public VcsLogSettings getSettings() {
        VcsLogSettings vcsLogSettings = this.mySettings;
        if (vcsLogSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogDataHolder", "getSettings"));
        }
        return vcsLogSettings;
    }

    public ContainingBranchesGetter getContainingBranchesGetter() {
        return this.myContainingBranchesGetter;
    }

    @Nullable
    public Hash findHashByString(@NotNull String string) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/data/VcsLogDataHolder", "findHashByString"));
        }
        final String pHash = string.toLowerCase();
        try {
            return this.myHashMap.findHash(new Condition<Hash>(){

                public boolean value(@NotNull Hash hash) {
                    if (hash == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/data/VcsLogDataHolder$8", "value"));
                    }
                    return hash.toString().toLowerCase().startsWith(pHash);
                }
            });
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private static Collection<VcsRef> collectAllRefs(Map<VirtualFile, Collection<VcsRef>> refsByRoot) {
        ArrayList<VcsRef> allRefs = new ArrayList<VcsRef>();
        for (Collection<VcsRef> refs : refsByRoot.values()) {
            allRefs.addAll(refs);
        }
        return allRefs;
    }

    private void handleOnSuccessInEdt(final Consumer<DataPack> onSuccess, final DataPack dataPack) {
        this.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                onSuccess.consume((Object)dataPack);
            }
        });
    }

    private void storeTopCommitsDetailsInCache(List<? extends VcsCommitMetadata> firstBlockDetails) {
        for (VcsCommitMetadata vcsCommitMetadata : firstBlockDetails) {
            this.myTopCommitsDetailsCache.put(vcsCommitMetadata.getHash(), vcsCommitMetadata);
        }
    }

    private List<TimedVcsCommit> getCommitsFromDetails(List<? extends VcsCommitMetadata> firstBlockDetails) {
        List commits = ContainerUtil.map(firstBlockDetails, (Function)new Function<VcsCommitMetadata, TimedVcsCommit>(){

            public TimedVcsCommit fun(VcsCommitMetadata details) {
                return new CompactCommit(details.getHash(), details.getParents(), details.getTime());
            }
        });
        this.myHashMap.flush();
        return commits;
    }

    private void runInBackground(final ThrowableConsumer<ProgressIndicator, VcsException> task, String title) {
        this.myDataLoaderQueue.run(new Task.Backgroundable(this.myProject, title){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/data/VcsLogDataHolder$11", "run"));
                }
                try {
                    task.consume((Object)indicator);
                }
                catch (VcsException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private void refresh(final @NotNull Consumer<DataPack> onSuccess) {
        if (onSuccess == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/data/VcsLogDataHolder", "refresh"));
        }
        this.runInBackground(new ThrowableConsumer<ProgressIndicator, VcsException>(){

            public void consume(ProgressIndicator indicator) throws VcsException {
                Consumer<DataPack> success = new Consumer<DataPack>(){

                    public void consume(DataPack dataPack) {
                        onSuccess.consume((Object)dataPack);
                    }
                };
                if (VcsLogDataHolder.this.myLogData.isFullLogReady()) {
                    VcsLogDataHolder.this.smartRefresh(indicator, (Consumer<DataPack>)((Consumer)success));
                } else {
                    VcsLogDataHolder.this.loadFromVcs(VcsLogDataHolder.this.mySettings.getRecentCommitsCount(), indicator, (Consumer<DataPack>)((Consumer)success));
                }
            }
        }, "Refreshing history...");
    }

    public void refreshCompletely() {
        this.initialize(new PairConsumer<VcsLogDataHolder, DataPack>(){

            public void consume(VcsLogDataHolder holder, DataPack dataPack) {
                VcsLogDataHolder.this.notifyAboutDataRefresh(dataPack);
            }
        });
    }

    public void refresh(@NotNull VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/data/VcsLogDataHolder", "refresh"));
        }
        this.refresh(new Consumer<DataPack>(){

            public void consume(@NotNull DataPack dataPack) {
                if (dataPack == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/data/VcsLogDataHolder$14", "consume"));
                }
                VcsLogDataHolder.this.notifyAboutDataRefresh(dataPack);
            }
        });
    }

    public void refreshRefs(@NotNull VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/data/VcsLogDataHolder", "refreshRefs"));
        }
        this.refresh(root);
    }

    @Nullable
    public VcsCommitMetadata getTopCommitDetails(@NotNull Hash hash) {
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/data/VcsLogDataHolder", "getTopCommitDetails"));
        }
        return this.myTopCommitsDetailsCache.get(hash);
    }

    private void notifyAboutDataRefresh(DataPack dataPack) {
        if (!this.myProject.isDisposed()) {
            ((VcsLogRefreshListener)this.myProject.getMessageBus().syncPublisher(REFRESH_COMPLETED)).refresh(dataPack);
        }
    }

    public CommitDetailsGetter getCommitDetailsGetter() {
        return this.myDetailsGetter;
    }

    @NotNull
    public MiniDetailsGetter getMiniDetailsGetter() {
        MiniDetailsGetter miniDetailsGetter = this.myMiniDetailsGetter;
        if (miniDetailsGetter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogDataHolder", "getMiniDetailsGetter"));
        }
        return miniDetailsGetter;
    }

    public void dispose() {
        this.myDataLoaderQueue.clear();
        this.myLogData = null;
        this.resetState();
    }

    @NotNull
    public VcsLogProvider getLogProvider(@NotNull VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/data/VcsLogDataHolder", "getLogProvider"));
        }
        VcsLogProvider vcsLogProvider = this.myLogProviders.get(root);
        if (vcsLogProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogDataHolder", "getLogProvider"));
        }
        return vcsLogProvider;
    }

    private void invokeAndWait(final Runnable task) {
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!Disposer.isDisposed((Disposable)VcsLogDataHolder.this)) {
                    task.run();
                }
            }
        });
    }

    private class CompactCommit
    implements TimedVcsCommit,
    GraphCommit {
        private final int myHashIndex;
        private final int myParent;
        private final int[] myOtherParents;
        private final long myTime;

        public CompactCommit(TimedVcsCommit commit) {
            this(commit.getHash(), commit.getParents(), commit.getTime());
        }

        public CompactCommit(Hash hash, List<Hash> parents, long time) {
            this.myHashIndex = VcsLogDataHolder.this.getCommitIndex(hash);
            this.myTime = time;
            if (!parents.isEmpty()) {
                this.myParent = VcsLogDataHolder.this.getCommitIndex(parents.get(0));
                if (parents.size() > 1) {
                    this.myOtherParents = new int[parents.size() - 1];
                    for (int i = 0; i < parents.size() - 1; ++i) {
                        this.myOtherParents[i] = VcsLogDataHolder.this.getCommitIndex(parents.get(i + 1));
                    }
                } else {
                    this.myOtherParents = null;
                }
            } else {
                this.myParent = -1;
                this.myOtherParents = null;
            }
        }

        public long getTime() {
            return this.myTime;
        }

        @NotNull
        public Hash getHash() {
            Hash hash = VcsLogDataHolder.this.getHash(this.myHashIndex);
            if (hash == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogDataHolder$CompactCommit", "getHash"));
            }
            return hash;
        }

        @NotNull
        public List<Hash> getParents() {
            SmartList parents = new SmartList();
            if (this.myParent > -1) {
                parents.add(VcsLogDataHolder.this.getHash(this.myParent));
            }
            if (this.myOtherParents != null) {
                for (int parent : this.myOtherParents) {
                    parents.add(VcsLogDataHolder.this.getHash(parent));
                }
            }
            SmartList smartList = parents;
            if (smartList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogDataHolder$CompactCommit", "getParents"));
            }
            return smartList;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CompactCommit commit = (CompactCommit)o;
            return this.myHashIndex == commit.myHashIndex;
        }

        public int hashCode() {
            return this.myHashIndex;
        }

        @Override
        public int getIndex() {
            return this.myHashIndex;
        }

        @Override
        public int[] getParentIndices() {
            if (this.myParent < 0) {
                return ArrayUtil.EMPTY_INT_ARRAY;
            }
            if (this.myOtherParents == null) {
                return new int[]{this.myParent};
            }
            int[] parents = new int[this.myOtherParents.length + 1];
            parents[0] = this.myParent;
            System.arraycopy(this.myOtherParents, 0, parents, 1, this.myOtherParents.length);
            return parents;
        }
    }

    private static class LogData {
        @NotNull
        private final Map<VirtualFile, List<? extends TimedVcsCommit>> myLogsByRoot;
        @NotNull
        private final Map<VirtualFile, Collection<VcsRef>> myRefsByRoot;
        @NotNull
        private final List<? extends TimedVcsCommit> myCompoundTopCommits;
        @NotNull
        private final DataPack myDataPack;
        private final boolean myFullLog;

        private LogData(@NotNull Map<VirtualFile, List<? extends TimedVcsCommit>> logsByRoot, @NotNull Map<VirtualFile, Collection<VcsRef>> refsByRoot, @NotNull List<? extends TimedVcsCommit> compoundTopCommits, @NotNull DataPack dataPack, boolean fullLog) {
            if (logsByRoot == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/data/VcsLogDataHolder$LogData", "<init>"));
            }
            if (refsByRoot == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/data/VcsLogDataHolder$LogData", "<init>"));
            }
            if (compoundTopCommits == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/vcs/log/data/VcsLogDataHolder$LogData", "<init>"));
            }
            if (dataPack == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/vcs/log/data/VcsLogDataHolder$LogData", "<init>"));
            }
            this.myLogsByRoot = logsByRoot;
            this.myRefsByRoot = refsByRoot;
            this.myCompoundTopCommits = compoundTopCommits;
            this.myDataPack = dataPack;
            this.myFullLog = fullLog;
        }

        @NotNull
        public List<? extends TimedVcsCommit> getLog(@NotNull VirtualFile root) {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/data/VcsLogDataHolder$LogData", "getLog"));
            }
            List<? extends TimedVcsCommit> list = this.myLogsByRoot.get(root);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogDataHolder$LogData", "getLog"));
            }
            return list;
        }

        @NotNull
        public Collection<VcsRef> getRefs(@NotNull VirtualFile root) {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/data/VcsLogDataHolder$LogData", "getRefs"));
            }
            Collection<VcsRef> collection = this.myRefsByRoot.get(root);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogDataHolder$LogData", "getRefs"));
            }
            return collection;
        }

        @NotNull
        public Collection<VcsRef> getAllRefs() {
            HashSet allRefs = new HashSet();
            for (Collection<VcsRef> refs : this.myRefsByRoot.values()) {
                allRefs.addAll(refs);
            }
            HashSet hashSet = allRefs;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogDataHolder$LogData", "getAllRefs"));
            }
            return hashSet;
        }

        @NotNull
        public DataPack getDataPack() {
            DataPack dataPack = this.myDataPack;
            if (dataPack == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogDataHolder$LogData", "getDataPack"));
            }
            return dataPack;
        }

        public boolean isFullLogReady() {
            return this.myFullLog && this.getTopCommitsCount() > 0;
        }

        @NotNull
        public Map<VirtualFile, List<? extends TimedVcsCommit>> getLogs() {
            Map<VirtualFile, List<? extends TimedVcsCommit>> map = this.myLogsByRoot;
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogDataHolder$LogData", "getLogs"));
            }
            return map;
        }

        @NotNull
        public Map<VirtualFile, Collection<VcsRef>> getRefs() {
            Map<VirtualFile, Collection<VcsRef>> map = this.myRefsByRoot;
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogDataHolder$LogData", "getRefs"));
            }
            return map;
        }

        public int getTopCommitsCount() {
            return this.myCompoundTopCommits.size();
        }

        @NotNull
        public List<? extends TimedVcsCommit> getTopCommits() {
            List<? extends TimedVcsCommit> list = this.myCompoundTopCommits;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogDataHolder$LogData", "getTopCommits"));
            }
            return list;
        }
    }

    private static class RecentCommitsInfo {
        List<TimedVcsCommit> firstBlockCommits;
        Collection<VcsRef> newRefs;

        RecentCommitsInfo(List<TimedVcsCommit> commits, Collection<VcsRef> refs) {
            this.firstBlockCommits = commits;
            this.newRefs = refs;
        }
    }
}

