/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.util.Condition;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.graph.GraphAction;
import com.intellij.vcs.log.graph.GraphAnswer;
import com.intellij.vcs.log.graph.GraphFacade;
import com.intellij.vcs.log.graph.GraphInfoProvider;
import com.intellij.vcs.log.graph.PaintInfo;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class EmptyGraphFacade
implements GraphFacade {
    public static final BufferedImage EMPTY_IMAGE = UIUtil.createImage((int)1, (int)1, (int)3);

    EmptyGraphFacade() {
    }

    @NotNull
    public PaintInfo paint(int visibleRow) {
        PaintInfo paintInfo = new PaintInfo(){

            @NotNull
            public Image getImage() {
                BufferedImage bufferedImage = EMPTY_IMAGE;
                if (bufferedImage == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/EmptyGraphFacade$1", "getImage"));
                }
                return bufferedImage;
            }

            public int getWidth() {
                return 0;
            }
        };
        if (paintInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/EmptyGraphFacade", "paint"));
        }
        return paintInfo;
    }

    @Nullable
    public GraphAnswer performAction(@NotNull GraphAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/data/EmptyGraphFacade", "performAction"));
        }
        return null;
    }

    @NotNull
    public List<Integer> getAllCommits() {
        List<Integer> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/EmptyGraphFacade", "getAllCommits"));
        }
        return list;
    }

    public int getCommitAtRow(int visibleRow) {
        return -1;
    }

    public int getVisibleCommitCount() {
        return 0;
    }

    public void setVisibleBranches(@Nullable Collection<Integer> heads) {
    }

    public void setFilter(@Nullable Condition<Integer> visibilityPredicate) {
    }

    @NotNull
    public GraphInfoProvider getInfoProvider() {
        GraphInfoProvider graphInfoProvider = new GraphInfoProvider(){

            @NotNull
            public Set<Integer> getContainingBranches(int visibleRow) {
                Set<Integer> set = Collections.emptySet();
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/EmptyGraphFacade$2", "getContainingBranches"));
                }
                return set;
            }

            @NotNull
            public GraphInfoProvider.RowInfo getRowInfo(int visibleRow) {
                GraphInfoProvider.RowInfo rowInfo = new GraphInfoProvider.RowInfo(){

                    public int getOneOfHeads() {
                        return -1;
                    }
                };
                if (rowInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/EmptyGraphFacade$2", "getRowInfo"));
                }
                return rowInfo;
            }

            public boolean areLongEdgesHidden() {
                return false;
            }
        };
        if (graphInfoProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/EmptyGraphFacade", "getInfoProvider"));
        }
        return graphInfoProvider;
    }
}

