/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.GraphCommit;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.EmptyGraphFacade;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.graph.GraphColorManagerImpl;
import com.intellij.vcs.log.graph.GraphFacade;
import com.intellij.vcs.log.newgraph.facade.GraphFacadeImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DataPack
implements VcsLogDataPack {
    private static final boolean USE_NEW_FACADE = true;
    @NotNull
    private final RefsModel myRefsModel;
    @NotNull
    private final GraphFacade myGraphFacade;
    @NotNull
    private final Map<VirtualFile, VcsLogProvider> myLogProviders;

    @NotNull
    public static DataPack build(@NotNull List<? extends GraphCommit> commits, @NotNull Collection<VcsRef> allRefs, @NotNull ProgressIndicator indicator, @NotNull NotNullFunction<Hash, Integer> indexGetter, @NotNull NotNullFunction<Integer, Hash> hashGetter, @NotNull Map<VirtualFile, VcsLogProvider> providers) {
        if (commits == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/data/DataPack", "build"));
        }
        if (allRefs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/data/DataPack", "build"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/vcs/log/data/DataPack", "build"));
        }
        if (indexGetter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/vcs/log/data/DataPack", "build"));
        }
        if (hashGetter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/vcs/log/data/DataPack", "build"));
        }
        if (providers == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "com/intellij/vcs/log/data/DataPack", "build"));
        }
        indicator.setText("Building graph...");
        RefsModel refsModel = new RefsModel(allRefs, indexGetter);
        GraphColorManagerImpl colorManager = new GraphColorManagerImpl(refsModel, hashGetter, DataPack.getRefManagerMap(providers));
        if (!commits.isEmpty()) {
            DataPack dataPack = new DataPack(refsModel, GraphFacadeImpl.newInstance(commits, DataPack.getBranchCommitHashIndexes(allRefs, indexGetter), colorManager), providers);
            if (dataPack == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/DataPack", "build"));
            }
            return dataPack;
        }
        DataPack dataPack = new DataPack(refsModel, new EmptyGraphFacade(), providers);
        if (dataPack == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/DataPack", "build"));
        }
        return dataPack;
    }

    @NotNull
    private static Set<Integer> getBranchCommitHashIndexes(@NotNull Collection<VcsRef> allRefs, @NotNull NotNullFunction<Hash, Integer> indexGetter) {
        if (allRefs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/data/DataPack", "getBranchCommitHashIndexes"));
        }
        if (indexGetter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/data/DataPack", "getBranchCommitHashIndexes"));
        }
        HashSet<Integer> result = new HashSet<Integer>();
        for (VcsRef vcsRef : allRefs) {
            if (!vcsRef.getType().isBranch()) continue;
            result.add((Integer)indexGetter.fun((Object)vcsRef.getCommitHash()));
        }
        HashSet<Integer> hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/DataPack", "getBranchCommitHashIndexes"));
        }
        return hashSet;
    }

    @NotNull
    private static Map<VirtualFile, VcsLogRefManager> getRefManagerMap(@NotNull Map<VirtualFile, VcsLogProvider> logProviders) {
        if (logProviders == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/data/DataPack", "getRefManagerMap"));
        }
        HashMap map = ContainerUtil.newHashMap();
        for (Map.Entry<VirtualFile, VcsLogProvider> entry : logProviders.entrySet()) {
            map.put(entry.getKey(), entry.getValue().getReferenceManager());
        }
        HashMap hashMap = map;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/DataPack", "getRefManagerMap"));
        }
        return hashMap;
    }

    private DataPack(@NotNull RefsModel refsModel, @NotNull GraphFacade graphFacade, @NotNull Map<VirtualFile, VcsLogProvider> providers) {
        if (refsModel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/data/DataPack", "<init>"));
        }
        if (graphFacade == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/data/DataPack", "<init>"));
        }
        if (providers == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/vcs/log/data/DataPack", "<init>"));
        }
        this.myRefsModel = refsModel;
        this.myGraphFacade = graphFacade;
        this.myLogProviders = providers;
    }

    @NotNull
    public GraphFacade getGraphFacade() {
        GraphFacade graphFacade = this.myGraphFacade;
        if (graphFacade == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/DataPack", "getGraphFacade"));
        }
        return graphFacade;
    }

    @NotNull
    public VcsLogRefs getRefs() {
        RefsModel refsModel = this.myRefsModel;
        if (refsModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/DataPack", "getRefs"));
        }
        return refsModel;
    }

    @NotNull
    public RefsModel getRefsModel() {
        RefsModel refsModel = this.myRefsModel;
        if (refsModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/DataPack", "getRefsModel"));
        }
        return refsModel;
    }

    @NotNull
    public Map<VirtualFile, VcsLogProvider> getLogProviders() {
        Map<VirtualFile, VcsLogProvider> map = this.myLogProviders;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/DataPack", "getLogProviders"));
        }
        return map;
    }
}

