/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.compressedlist;

public class UpdateRequest {
    public static UpdateRequest ID_UpdateRequest = new UpdateRequest(0, 0, 1);
    private final int from;
    private final int to;
    private final int addedElementCount;

    public static UpdateRequest buildFromToInterval(int oldFrom, int oldTo, int newFrom, int newTo) {
        if (oldFrom != newFrom || oldFrom > oldTo || newFrom > newTo) {
            throw new IllegalArgumentException("oldFrom: " + oldFrom + ", oldTo: " + oldTo + ", newFrom: " + newFrom + ", newTo: " + newTo);
        }
        return new UpdateRequest(oldFrom, oldTo, newTo - newFrom + 1);
    }

    public UpdateRequest(int from, int to, int addedElementCount) {
        if (from < 0 || from > to || addedElementCount < 0) {
            throw new IllegalArgumentException("from: " + from + "to: " + to + "addedElementCount: " + addedElementCount);
        }
        this.from = from;
        this.to = to;
        this.addedElementCount = addedElementCount;
    }

    public int from() {
        return this.from;
    }

    public int to() {
        return this.to;
    }

    public int addedElementCount() {
        return this.addedElementCount;
    }

    public int removedElementCount() {
        return this.to - this.from + 1;
    }

    public String toString() {
        return "UpdateRequest{from=" + this.from + ", to=" + this.to + ", addedElementCount=" + this.addedElementCount + '}';
    }
}

