/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.compressedlist;

import com.intellij.vcs.log.compressedlist.CompressedList;
import com.intellij.vcs.log.compressedlist.UpdateRequest;
import com.intellij.vcs.log.compressedlist.generator.Generator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class NoCompressedList<T>
implements CompressedList<T> {
    private final List<T> calcList;
    private final Generator<T> generator;
    private int size;

    public NoCompressedList(Generator<T> generator, int size) {
        assert (size >= 0) : "bad size";
        this.calcList = new ArrayList<T>(size);
        this.generator = generator;
        this.size = size;
        this.generate();
    }

    private void generate() {
        this.calcList.clear();
        T t = this.generator.generateFirst();
        this.calcList.add(t);
        for (int i = 1; i < this.size; ++i) {
            t = this.generator.generate(t, 1);
            this.calcList.add(t);
        }
    }

    @Override
    @NotNull
    public List<T> getList() {
        List<T> list = Collections.unmodifiableList(this.calcList);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/compressedlist/NoCompressedList", "getList"));
        }
        return list;
    }

    @Override
    public void recalculate(@NotNull UpdateRequest updateRequest) {
        if (updateRequest == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/compressedlist/NoCompressedList", "recalculate"));
        }
        if (updateRequest == UpdateRequest.ID_UpdateRequest) {
            return;
        }
        if (updateRequest.to() >= this.size) {
            throw new IllegalArgumentException("Bad updateRequest: " + updateRequest.from() + ", " + updateRequest.to() + ", " + updateRequest.addedElementCount());
        }
        this.size = updateRequest.addedElementCount() - updateRequest.removedElementCount() + this.size;
        this.generate();
    }
}

