/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolderImpl;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManager;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManagerImpl;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptor;
import com.intellij.util.xml.highlighting.DomElementsInspection;
import com.intellij.util.xml.impl.DomManagerImpl;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultDomAnnotator
implements Annotator {
    @Nullable
    private static DomElement getDomElement(PsiElement psiElement, DomManager myDomManager) {
        if (psiElement instanceof XmlTag) {
            return myDomManager.getDomElement((XmlTag)psiElement);
        }
        if (psiElement instanceof XmlAttribute) {
            return myDomManager.getDomElement((XmlAttribute)psiElement);
        }
        return null;
    }

    public <T extends DomElement> void runInspection(@Nullable DomElementsInspection<T> inspection, DomFileElement<T> fileElement, List<Annotation> toFill) {
        if (inspection == null) {
            return;
        }
        DomElementAnnotationsManagerImpl annotationsManager = this.getAnnotationsManager((DomElement)fileElement);
        if (DomElementAnnotationsManagerImpl.isHolderUpToDate(fileElement) && annotationsManager.getProblemHolder((DomElement)fileElement).isInspectionCompleted(inspection)) {
            return;
        }
        DomElementAnnotationHolderImpl annotationHolder = new DomElementAnnotationHolderImpl(true);
        inspection.checkFileElement(fileElement, (DomElementAnnotationHolder)annotationHolder);
        annotationsManager.appendProblems(fileElement, annotationHolder, inspection.getClass());
        Iterator i$ = annotationHolder.iterator();
        while (i$.hasNext()) {
            DomElementProblemDescriptor descriptor = (DomElementProblemDescriptor)i$.next();
            toFill.addAll(descriptor.getAnnotations());
        }
        toFill.addAll((Collection<Annotation>)annotationHolder.getAnnotations());
    }

    protected DomElementAnnotationsManagerImpl getAnnotationsManager(DomElement element) {
        return (DomElementAnnotationsManagerImpl)DomElementAnnotationsManager.getInstance((Project)element.getManager().getProject());
    }

    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        DomElement domElement;
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/xml/impl/DefaultDomAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/xml/impl/DefaultDomAnnotator", "annotate"));
        }
        List list = (List)holder;
        DomManagerImpl domManager = DomManagerImpl.getDomManager(psiElement.getProject());
        DomFileDescription<?> description = domManager.getDomFileDescription(psiElement);
        if (description != null && (domElement = DefaultDomAnnotator.getDomElement(psiElement, domManager)) != null) {
            this.runInspection(domElement, list);
        }
    }

    public final void runInspection(DomElement domElement, List<Annotation> list) {
        DomFileElement root = DomUtil.getFileElement((DomElement)domElement);
        this.runInspection(this.getAnnotationsManager(domElement).getMockInspection(root), root, list);
    }
}

