/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.socketConnection.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.socketConnection.AbstractRequest;
import com.intellij.util.io.socketConnection.AbstractResponse;
import com.intellij.util.io.socketConnection.ClientSocketConnection;
import com.intellij.util.io.socketConnection.ConnectionStatus;
import com.intellij.util.io.socketConnection.RequestResponseExternalizerFactory;
import com.intellij.util.io.socketConnection.impl.SocketConnectionBase;
import com.intellij.util.net.NetUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.jetbrains.annotations.NotNull;

public class SocketConnectionImpl<Request extends AbstractRequest, Response extends AbstractResponse>
extends SocketConnectionBase<Request, Response>
implements ClientSocketConnection<Request, Response> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.io.socketConnection.impl.SocketConnectionImpl");
    private static final int MAX_CONNECTION_ATTEMPTS = 60;
    private static final int CONNECTION_ATTEMPT_DELAY = 500;
    private final InetAddress myHost;
    private final int myInitialPort;
    private final int myPortsNumberToTry;

    public SocketConnectionImpl(InetAddress host, int initialPort, int portsNumberToTry, @NotNull RequestResponseExternalizerFactory<Request, Response> requestResponseRequestResponseExternalizerFactory) {
        if (requestResponseRequestResponseExternalizerFactory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/util/io/socketConnection/impl/SocketConnectionImpl", "<init>"));
        }
        super(requestResponseRequestResponseExternalizerFactory);
        this.myHost = host;
        this.myInitialPort = initialPort;
        this.myPortsNumberToTry = portsNumberToTry;
    }

    @Override
    public void open() throws IOException {
        final Socket socket = this.createSocket();
        this.setPort(socket.getPort());
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                try {
                    SocketConnectionImpl.this.attachToSocket(socket);
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                    SocketConnectionImpl.this.setStatus(ConnectionStatus.CONNECTION_FAILED, "Connection failed: " + e.getMessage());
                }
            }
        });
    }

    @NotNull
    private Socket createSocket() throws IOException {
        InetAddress host = this.myHost;
        if (host == null) {
            try {
                host = InetAddress.getLocalHost();
            }
            catch (UnknownHostException ignored) {
                host = NetUtils.getLoopbackAddress();
            }
        }
        IOException exc = null;
        for (int i = 0; i < this.myPortsNumberToTry; ++i) {
            Socket socket;
            block6: {
                int port = this.myInitialPort + i;
                try {
                    socket = new Socket(host, port);
                    if (socket != null) break block6;
                }
                catch (IOException e) {
                    exc = e;
                    LOG.debug((Throwable)e);
                    continue;
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/socketConnection/impl/SocketConnectionImpl", "createSocket"));
            }
            return socket;
        }
        throw exc;
    }

    public void connect() {
        this.setStatus(ConnectionStatus.WAITING_FOR_CONNECTION, null);
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                Exception exception = null;
                InetAddress host = SocketConnectionImpl.this.myHost;
                if (host == null) {
                    host = NetUtils.getLoopbackAddress();
                }
                for (int attempt = 0; attempt < 60; ++attempt) {
                    for (int i = 0; i < SocketConnectionImpl.this.myPortsNumberToTry; ++i) {
                        Socket socket;
                        try {
                            socket = new Socket(host, SocketConnectionImpl.this.myInitialPort + i);
                        }
                        catch (IOException e) {
                            LOG.debug((Throwable)e);
                            exception = e;
                            continue;
                        }
                        SocketConnectionImpl.this.setPort(socket.getPort());
                        try {
                            SocketConnectionImpl.this.attachToSocket(socket);
                        }
                        catch (IOException e) {
                            LOG.info((Throwable)e);
                        }
                        return;
                    }
                    try {
                        Thread.sleep(500L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        exception = e;
                        break;
                    }
                }
                SocketConnectionImpl.this.setStatus(ConnectionStatus.CONNECTION_FAILED, exception == null ? "Connection failed" : "Connection failed: " + exception.getMessage());
            }
        });
    }

    @Override
    public void startPolling() {
        this.setStatus(ConnectionStatus.WAITING_FOR_CONNECTION, null);
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                SocketConnectionImpl.this.addThreadToInterrupt();
                try {
                    for (int attempt = 0; attempt < 60; ++attempt) {
                        try {
                            SocketConnectionImpl.this.open();
                            return;
                        }
                        catch (IOException e) {
                            LOG.debug((Throwable)e);
                            Thread.sleep(500L);
                            continue;
                        }
                    }
                    SocketConnectionImpl.this.setStatus(ConnectionStatus.CONNECTION_FAILED, "Cannot connect to " + (SocketConnectionImpl.this.myHost != null ? SocketConnectionImpl.this.myHost : "localhost") + ", the maximum number of connection attempts exceeded");
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    SocketConnectionImpl.this.removeThreadToInterrupt();
                }
            }
        });
    }
}

