/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.TestFileSystemItem;

public class TestFileSystemBuilder {
    private final TestFileSystemItem myItem;
    private final TestFileSystemBuilder myParent;

    private TestFileSystemBuilder(TestFileSystemItem item, TestFileSystemBuilder parent) {
        this.myItem = item;
        this.myParent = parent;
    }

    public TestFileSystemItem build() {
        TestFileSystemBuilder builder = this;
        while (builder.myParent != null) {
            builder = builder.myParent;
        }
        return builder.myItem;
    }

    public TestFileSystemBuilder dir(String name) {
        TestFileSystemItem item = new TestFileSystemItem(name, false, true);
        this.myItem.addChild(item);
        return new TestFileSystemBuilder(item, this);
    }

    public TestFileSystemBuilder archive(String name) {
        TestFileSystemItem item = new TestFileSystemItem(name, true, false);
        this.myItem.addChild(item);
        return new TestFileSystemBuilder(item, this);
    }

    public TestFileSystemBuilder file(String name) {
        this.myItem.addChild(new TestFileSystemItem(name, false, false));
        return this;
    }

    public TestFileSystemBuilder file(String name, String content) {
        this.myItem.addChild(new TestFileSystemItem(name, false, false, content));
        return this;
    }

    public TestFileSystemBuilder end() {
        return this.myParent;
    }

    public static TestFileSystemBuilder fs() {
        return new TestFileSystemBuilder(new TestFileSystemItem("root", false, true), null);
    }
}

