/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.util.indexing.ChangeTrackingValueContainer;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.ValueContainerImpl;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentEnumeratorBase;
import com.intellij.util.io.PersistentHashMap;
import gnu.trove.TIntHashSet;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;

class ValueContainerMap<Key, Value>
extends PersistentHashMap<Key, ValueContainer<Value>> {
    @NotNull
    private final ValueContainerExternalizer<Value> myValueContainerExternalizer;

    ValueContainerMap(@NotNull File file, @NotNull KeyDescriptor<Key> keyKeyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/ValueContainerMap", "<init>"));
        }
        if (keyKeyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/indexing/ValueContainerMap", "<init>"));
        }
        if (valueExternalizer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/util/indexing/ValueContainerMap", "<init>"));
        }
        super(file, keyKeyDescriptor, new ValueContainerExternalizer(valueExternalizer));
        this.myValueContainerExternalizer = (ValueContainerExternalizer)this.myValueExternalizer;
    }

    @NotNull
    Object getDataAccessLock() {
        PersistentEnumeratorBase persistentEnumeratorBase = this.myEnumerator;
        if (persistentEnumeratorBase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/ValueContainerMap", "getDataAccessLock"));
        }
        return persistentEnumeratorBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPut(Key key, ValueContainer<Value> container) throws IOException {
        PersistentEnumeratorBase persistentEnumeratorBase = this.myEnumerator;
        synchronized (persistentEnumeratorBase) {
            ChangeTrackingValueContainer valueContainer = (ChangeTrackingValueContainer)container;
            if (!valueContainer.needsCompacting()) {
                ValueContainer toAppend;
                final BufferExposingByteArrayOutputStream bytes = new BufferExposingByteArrayOutputStream();
                DataOutputStream _out = new DataOutputStream((OutputStream)bytes);
                TIntHashSet set = valueContainer.getInvalidated();
                if (set != null && set.size() > 0) {
                    for (int inputId : set.toArray()) {
                        ValueContainerExternalizer.saveInvalidateCommand((DataOutput)_out, inputId);
                    }
                }
                if ((toAppend = valueContainer.getAddedDelta()) != null && toAppend.size() > 0) {
                    this.myValueContainerExternalizer.save((DataOutput)_out, toAppend);
                }
                this.appendData(key, new PersistentHashMap.ValueDataAppender(){

                    public void append(@NotNull DataOutput out) throws IOException {
                        if (out == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/ValueContainerMap$1", "append"));
                        }
                        out.write(bytes.getInternalBuffer(), 0, bytes.size());
                    }
                });
            } else {
                super.doPut(key, (Object)valueContainer);
            }
        }
    }

    private static final class ValueContainerExternalizer<T>
    implements DataExternalizer<ValueContainer<T>> {
        @NotNull
        private final DataExternalizer<T> myExternalizer;

        private ValueContainerExternalizer(@NotNull DataExternalizer<T> externalizer) {
            if (externalizer == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/ValueContainerMap$ValueContainerExternalizer", "<init>"));
            }
            this.myExternalizer = externalizer;
        }

        public void save(@NotNull DataOutput out, @NotNull ValueContainer<T> container) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/ValueContainerMap$ValueContainerExternalizer", "save"));
            }
            if (container == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/indexing/ValueContainerMap$ValueContainerExternalizer", "save"));
            }
            this.saveImpl(out, container);
        }

        public static void saveInvalidateCommand(DataOutput out, int inputId) throws IOException {
            DataInputOutputUtil.writeSINT((DataOutput)out, (int)(-inputId));
        }

        private void saveImpl(@NotNull DataOutput out, @NotNull ValueContainer<T> container) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/ValueContainerMap$ValueContainerExternalizer", "saveImpl"));
            }
            if (container == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/indexing/ValueContainerMap$ValueContainerExternalizer", "saveImpl"));
            }
            DataInputOutputUtil.writeSINT((DataOutput)out, (int)container.size());
            ValueContainer.ValueIterator<T> valueIterator = container.getValueIterator();
            while (valueIterator.hasNext()) {
                Object value = valueIterator.next();
                this.myExternalizer.save(out, value);
                ValueContainer.IntIterator ids = valueIterator.getInputIdsIterator();
                DataInputOutputUtil.writeSINT((DataOutput)out, (int)ids.size());
                while (ids.hasNext()) {
                    int id = ids.next();
                    DataInputOutputUtil.writeSINT((DataOutput)out, (int)id);
                }
            }
        }

        @NotNull
        public ValueContainerImpl<T> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/ValueContainerMap$ValueContainerExternalizer", "read"));
            }
            DataInputStream stream = (DataInputStream)in;
            ValueContainerImpl<Object> valueContainer = new ValueContainerImpl<Object>();
            while (stream.available() > 0) {
                int valueCount = DataInputOutputUtil.readSINT((DataInput)in);
                if (valueCount < 0) {
                    valueContainer.removeAssociatedValue(-valueCount);
                    valueContainer.setNeedsCompacting(true);
                    continue;
                }
                for (int valueIdx = 0; valueIdx < valueCount; ++valueIdx) {
                    Object value = this.myExternalizer.read(in);
                    int idCount = DataInputOutputUtil.readSINT((DataInput)in);
                    valueContainer.ensureFileSetCapacityForValue(value, idCount);
                    for (int i = 0; i < idCount; ++i) {
                        int id = DataInputOutputUtil.readSINT((DataInput)in);
                        valueContainer.addValue(id, value);
                    }
                }
            }
            ValueContainerImpl<Object> valueContainerImpl = valueContainer;
            if (valueContainerImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/ValueContainerMap$ValueContainerExternalizer", "read"));
            }
            return valueContainerImpl;
        }
    }
}

