/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.SmartList;
import com.intellij.util.containers.EmptyIterator;
import com.intellij.util.indexing.UpdatableValueContainer;
import com.intellij.util.indexing.ValueContainer;
import gnu.trove.THashMap;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIterator;
import gnu.trove.TIntProcedure;
import gnu.trove.TObjectObjectProcedure;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class ValueContainerImpl<Value>
extends UpdatableValueContainer<Value>
implements Cloneable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.indexing.ValueContainerImpl");
    private static final Object myNullValue = new Object();
    private static final int MAX_FILES = 20000;
    private Object myInputIdMapping;
    private Object myInputIdMappingValue;
    private static final EmptyValueIterator emptyIterator = new EmptyValueIterator();
    public static final ValueContainer.IntIterator EMPTY_ITERATOR = new ValueContainer.IntIterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public int next() {
            return 0;
        }

        @Override
        public int size() {
            return 0;
        }
    };
    private static final ValueContainer.IntPredicate EMPTY_PREDICATE = new ValueContainer.IntPredicate(){

        @Override
        public boolean contains(int id) {
            return false;
        }
    };

    ValueContainerImpl() {
    }

    @Override
    public void addValue(int inputId, Value value) {
        Object fileSetObject = this.getFileSetObject(value);
        if (fileSetObject == null) {
            this.attachFileSetForNewValue(value, inputId);
        } else if (fileSetObject instanceof Integer) {
            IdSet idSet = new IdSet(3);
            idSet.add((Integer)fileSetObject);
            idSet.add(inputId);
            this.resetFileSetForValue(value, (Object)idSet);
        } else if (fileSetObject instanceof TIntHashSet) {
            TIntHashSet idSet = (TIntHashSet)fileSetObject;
            idSet.add(inputId);
            if (idSet.size() > 20000) {
                this.resetFileSetForValue(value, new IdBitSet(idSet));
            }
        } else if (fileSetObject instanceof IdBitSet) {
            ((IdBitSet)fileSetObject).set(inputId);
        }
    }

    private void resetFileSetForValue(Value value, Object fileSet) {
        if (!(this.myInputIdMapping instanceof THashMap)) {
            this.myInputIdMappingValue = fileSet;
        } else {
            ((THashMap)this.myInputIdMapping).put(value, fileSet);
        }
    }

    @Override
    public int size() {
        return this.myInputIdMapping != null ? (this.myInputIdMapping instanceof THashMap ? ((THashMap)this.myInputIdMapping).size() : 1) : 0;
    }

    @Override
    public void removeAssociatedValue(int inputId) {
        if (this.myInputIdMapping == null) {
            return;
        }
        SmartList fileSetObjects = null;
        List valueObjects = null;
        ValueContainer.ValueIterator<Value> valueIterator = this.getValueIterator();
        while (valueIterator.hasNext()) {
            Object value = valueIterator.next();
            if (!valueIterator.getValueAssociationPredicate().contains(inputId)) continue;
            if (fileSetObjects == null) {
                fileSetObjects = new SmartList();
                valueObjects = new SmartList();
            } else if (ApplicationManager.getApplication().isEAP()) {
                LOG.error("Expected only one value per-inputId", new String[]{String.valueOf(fileSetObjects.get(0)), String.valueOf(value)});
            }
            fileSetObjects.add(valueIterator.getFileSetObject());
            valueObjects.add(value);
        }
        if (fileSetObjects != null) {
            int len = valueObjects.size();
            for (int i = 0; i < len; ++i) {
                this.removeValue(inputId, fileSetObjects.get(i), valueObjects.get(i));
            }
        }
    }

    private boolean removeValue(int inputId, Object fileSetObject, Value value) {
        if (fileSetObject == null) {
            return false;
        }
        if (fileSetObject instanceof TIntHashSet) {
            TIntHashSet idSet = (TIntHashSet)fileSetObject;
            boolean reallyRemoved = idSet.remove(inputId);
            if (reallyRemoved) {
                idSet.compact();
            }
            if (!idSet.isEmpty()) {
                return reallyRemoved;
            }
        } else if (fileSetObject instanceof Integer) {
            if ((Integer)fileSetObject != inputId) {
                return false;
            }
        } else if (fileSetObject instanceof IdBitSet) {
            IdBitSet bitSet = (IdBitSet)fileSetObject;
            boolean removed = bitSet.remove(inputId);
            if (bitSet.numberOfBitsSet() > 0) {
                return removed;
            }
        }
        if (!(this.myInputIdMapping instanceof THashMap)) {
            this.myInputIdMapping = null;
            this.myInputIdMappingValue = null;
        } else {
            THashMap mapping = (THashMap)this.myInputIdMapping;
            mapping.remove(value);
            if (mapping.size() == 1) {
                this.myInputIdMapping = mapping.keySet().iterator().next();
                this.myInputIdMappingValue = mapping.get(this.myInputIdMapping);
            }
        }
        return true;
    }

    @Override
    @NotNull
    public ValueContainer.ValueIterator<Value> getValueIterator() {
        if (this.myInputIdMapping != null) {
            if (!(this.myInputIdMapping instanceof THashMap)) {
                ValueContainer.ValueIterator valueIterator = new ValueContainer.ValueIterator<Value>(){
                    private Value value;
                    {
                        this.value = ValueContainerImpl.this.myInputIdMapping;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.value != null;
                    }

                    @Override
                    public Value next() {
                        Object next = this.value;
                        if (next == myNullValue) {
                            next = null;
                        }
                        this.value = null;
                        return next;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    @NotNull
                    public ValueContainer.IntIterator getInputIdsIterator() {
                        ValueContainer.IntIterator intIterator = ValueContainerImpl.getInputIdsIteratorOutOfFileSetObject(this.getFileSetObject());
                        if (intIterator == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/ValueContainerImpl$1", "getInputIdsIterator"));
                        }
                        return intIterator;
                    }

                    @Override
                    @NotNull
                    public ValueContainer.IntPredicate getValueAssociationPredicate() {
                        ValueContainer.IntPredicate intPredicate = ValueContainerImpl.getValueAssociationPredicateOutOfFileSetObject(this.getFileSetObject());
                        if (intPredicate == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/ValueContainerImpl$1", "getValueAssociationPredicate"));
                        }
                        return intPredicate;
                    }

                    @Override
                    public Object getFileSetObject() {
                        return ValueContainerImpl.this.myInputIdMappingValue;
                    }
                };
                if (valueIterator == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/ValueContainerImpl", "getValueIterator"));
                }
                return valueIterator;
            }
            ValueContainer.ValueIterator valueIterator = new ValueContainer.ValueIterator<Value>(){
                private Map.Entry<Value, Object> current;
                private final Iterator<Map.Entry<Value, Object>> iterator;
                {
                    this.iterator = ((THashMap)ValueContainerImpl.this.myInputIdMapping).entrySet().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iterator.hasNext();
                }

                @Override
                public Value next() {
                    this.current = this.iterator.next();
                    Object next = this.current.getKey();
                    if (next == myNullValue) {
                        next = null;
                    }
                    return next;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                @NotNull
                public ValueContainer.IntIterator getInputIdsIterator() {
                    ValueContainer.IntIterator intIterator = ValueContainerImpl.getInputIdsIteratorOutOfFileSetObject(this.getFileSetObject());
                    if (intIterator == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/ValueContainerImpl$2", "getInputIdsIterator"));
                    }
                    return intIterator;
                }

                @Override
                @NotNull
                public ValueContainer.IntPredicate getValueAssociationPredicate() {
                    ValueContainer.IntPredicate intPredicate = ValueContainerImpl.getValueAssociationPredicateOutOfFileSetObject(this.getFileSetObject());
                    if (intPredicate == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/ValueContainerImpl$2", "getValueAssociationPredicate"));
                    }
                    return intPredicate;
                }

                @Override
                public Object getFileSetObject() {
                    if (this.current == null) {
                        throw new IllegalStateException();
                    }
                    return this.current.getValue();
                }
            };
            if (valueIterator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/ValueContainerImpl", "getValueIterator"));
            }
            return valueIterator;
        }
        EmptyValueIterator emptyValueIterator = emptyIterator;
        if (emptyValueIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/ValueContainerImpl", "getValueIterator"));
        }
        return emptyValueIterator;
    }

    @Override
    @NotNull
    public List<Value> toValueList() {
        if (this.myInputIdMapping == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/ValueContainerImpl", "toValueList"));
            }
            return list;
        }
        if (this.myInputIdMapping instanceof THashMap) {
            ArrayList arrayList = new ArrayList(((THashMap)this.myInputIdMapping).keySet());
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/ValueContainerImpl", "toValueList"));
            }
            return arrayList;
        }
        SmartList smartList = new SmartList(this.myInputIdMapping);
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/ValueContainerImpl", "toValueList"));
        }
        return smartList;
    }

    @Override
    public boolean isAssociated(Value value, int inputId) {
        Object fileSetObject = this.getFileSetObject(value);
        if (fileSetObject instanceof TIntHashSet) {
            return ((TIntHashSet)fileSetObject).contains(inputId);
        }
        if (fileSetObject instanceof Integer) {
            return inputId == (Integer)fileSetObject;
        }
        if (fileSetObject instanceof IdBitSet) {
            return ((IdBitSet)fileSetObject).get(inputId);
        }
        return false;
    }

    @Override
    @NotNull
    public ValueContainer.IntPredicate getValueAssociationPredicate(Value value) {
        ValueContainer.IntPredicate intPredicate = ValueContainerImpl.getValueAssociationPredicateOutOfFileSetObject(this.getFileSetObject(value));
        if (intPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/ValueContainerImpl", "getValueAssociationPredicate"));
        }
        return intPredicate;
    }

    private static ValueContainer.IntPredicate getValueAssociationPredicateOutOfFileSetObject(final Object fileSetObject) {
        if (fileSetObject == null) {
            return EMPTY_PREDICATE;
        }
        if (fileSetObject instanceof Integer) {
            return new ValueContainer.IntPredicate(){
                final int myId;
                {
                    this.myId = (Integer)fileSetObject;
                }

                @Override
                public boolean contains(int id) {
                    return id == this.myId;
                }
            };
        }
        if (fileSetObject instanceof IdBitSet) {
            return new ValueContainer.IntPredicate(){
                final IdBitSet myIdBitSet;
                {
                    this.myIdBitSet = (IdBitSet)fileSetObject;
                }

                @Override
                boolean contains(int id) {
                    return this.myIdBitSet.get(id);
                }
            };
        }
        return new ValueContainer.IntPredicate(){
            final TIntHashSet mySet;
            {
                this.mySet = (TIntHashSet)fileSetObject;
            }

            @Override
            boolean contains(int id) {
                return this.mySet.contains(id);
            }
        };
    }

    @Override
    @NotNull
    public ValueContainer.IntIterator getInputIdsIterator(Value value) {
        ValueContainer.IntIterator intIterator = ValueContainerImpl.getInputIdsIteratorOutOfFileSetObject(this.getFileSetObject(value));
        if (intIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/ValueContainerImpl", "getInputIdsIterator"));
        }
        return intIterator;
    }

    private static ValueContainer.IntIterator getInputIdsIteratorOutOfFileSetObject(final Object fileSetObject) {
        ValueContainer.IntIterator it = fileSetObject instanceof TIntHashSet ? new IntSetIterator((TIntHashSet)fileSetObject) : (fileSetObject instanceof Integer ? new SingleValueIterator((Integer)fileSetObject) : (fileSetObject instanceof IdBitSet ? new ValueContainer.IntIterator(){
            private final IdBitSet myIdBitSet;
            private int nextSetBit;
            {
                this.myIdBitSet = (IdBitSet)fileSetObject;
                this.nextSetBit = this.myIdBitSet.nextSetBit(0);
            }

            @Override
            public boolean hasNext() {
                return this.nextSetBit != -1;
            }

            @Override
            public int next() {
                int setBit = this.nextSetBit;
                this.nextSetBit = this.myIdBitSet.nextSetBit(setBit + 1);
                return setBit;
            }

            @Override
            public int size() {
                return this.myIdBitSet.numberOfBitsSet();
            }
        } : EMPTY_ITERATOR));
        return it;
    }

    private Object getFileSetObject(Value value) {
        if (this.myInputIdMapping == null) {
            return null;
        }
        Object object = value = value != null ? value : myNullValue;
        if (this.myInputIdMapping == value || this.myInputIdMapping.equals(value)) {
            return this.myInputIdMappingValue;
        }
        if (!(this.myInputIdMapping instanceof THashMap)) {
            return null;
        }
        return ((THashMap)this.myInputIdMapping).get(value);
    }

    public ValueContainerImpl<Value> clone() {
        try {
            ValueContainerImpl clone = (ValueContainerImpl)super.clone();
            if (this.myInputIdMapping instanceof THashMap) {
                clone.myInputIdMapping = this.mapCopy((THashMap)this.myInputIdMapping);
            } else if (this.myInputIdMappingValue instanceof TIntHashSet) {
                clone.myInputIdMappingValue = ((TIntHashSet)this.myInputIdMappingValue).clone();
            } else if (this.myInputIdMappingValue instanceof IdBitSet) {
                clone.myInputIdMappingValue = ((IdBitSet)this.myInputIdMappingValue).clone();
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public ValueContainerImpl<Value> copy() {
        ValueContainerImpl<Value> container = new ValueContainerImpl<Value>();
        if (this.myInputIdMapping instanceof THashMap) {
            THashMap mapping = (THashMap)this.myInputIdMapping;
            final THashMap newMapping = new THashMap(mapping.size());
            container.myInputIdMapping = newMapping;
            mapping.forEachEntry(new TObjectObjectProcedure<Value, Object>(){

                public boolean execute(Value key, Object val) {
                    if (val instanceof TIntHashSet) {
                        newMapping.put(key, ((TIntHashSet)val).clone());
                    } else if (val instanceof IdBitSet) {
                        newMapping.put(key, (Object)((IdBitSet)val).clone());
                    } else {
                        newMapping.put(key, val);
                    }
                    return true;
                }
            });
        } else {
            container.myInputIdMapping = this.myInputIdMapping;
            container.myInputIdMappingValue = this.myInputIdMappingValue instanceof TIntHashSet ? ((TIntHashSet)this.myInputIdMappingValue).clone() : (this.myInputIdMappingValue instanceof IdBitSet ? ((IdBitSet)this.myInputIdMappingValue).clone() : this.myInputIdMappingValue);
        }
        ValueContainerImpl<Value> valueContainerImpl = container;
        if (valueContainerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/ValueContainerImpl", "copy"));
        }
        return valueContainerImpl;
    }

    void ensureFileSetCapacityForValue(Value value, int count) {
        if (count <= 1) {
            return;
        }
        Object input = this.getFileSetObject(value);
        if (input != null) {
            if (input instanceof Integer) {
                IdSet idSet = new IdSet(count + 1);
                idSet.add((Integer)input);
                this.resetFileSetForValue(value, (Object)idSet);
            } else if (input instanceof IdSet) {
                IdSet idSet = (IdSet)((Object)input);
                int nextSize = idSet.size() + count;
                if (nextSize <= 20000) {
                    idSet.ensureCapacity(count);
                } else {
                    this.resetFileSetForValue(value, new IdBitSet(idSet));
                }
            }
            return;
        }
        Object fileSet = count > 20000 ? new IdBitSet(count) : new IdSet(count);
        this.attachFileSetForNewValue(value, fileSet);
    }

    private void attachFileSetForNewValue(Value value, Object fileSet) {
        Object object = value = value != null ? value : myNullValue;
        if (this.myInputIdMapping != null) {
            if (!(this.myInputIdMapping instanceof THashMap)) {
                Object oldMapping = this.myInputIdMapping;
                this.myInputIdMapping = new THashMap(2);
                ((THashMap)this.myInputIdMapping).put(oldMapping, this.myInputIdMappingValue);
                this.myInputIdMappingValue = null;
            }
            ((THashMap)this.myInputIdMapping).put(value, fileSet);
        } else {
            this.myInputIdMapping = value;
            this.myInputIdMappingValue = fileSet;
        }
    }

    private THashMap<Value, Object> mapCopy(THashMap<Value, Object> map) {
        if (map == null) {
            return null;
        }
        final THashMap cloned = map.clone();
        cloned.forEachEntry(new TObjectObjectProcedure<Value, Object>(){

            public boolean execute(Value key, Object val) {
                if (val instanceof TIntHashSet) {
                    cloned.put(key, ((TIntHashSet)val).clone());
                } else if (val instanceof IdBitSet) {
                    cloned.put(key, (Object)((IdBitSet)val).clone());
                }
                return true;
            }
        });
        return cloned;
    }

    private static class IdBitSet
    implements Cloneable {
        private static final int SHIFT = 6;
        private static final int BITS_PER_WORD = 64;
        private static final int MASK = 63;
        private long[] myBitMask;
        private int myBitsSet;
        private int myLastUsedSlot;

        public IdBitSet(TIntHashSet set) {
            this(IdBitSet.calcMax(set));
            set.forEach(new TIntProcedure(){

                public boolean execute(int value) {
                    IdBitSet.this.set(value);
                    return true;
                }
            });
        }

        private static int calcMax(TIntHashSet set) {
            int[] minMax;
            minMax = new int[]{set.iterator().next(), minMax[0]};
            set.forEach(new TIntProcedure(){

                public boolean execute(int value) {
                    minMax[0] = Math.min(minMax[0], value);
                    minMax[1] = Math.max(minMax[1], value);
                    return true;
                }
            });
            return minMax[1];
        }

        public IdBitSet(int max) {
            this.myBitMask = new long[(IdBitSet.calcCapacity(max) >> 6) + 1];
        }

        public void set(int bitIndex) {
            boolean set = this.get(bitIndex);
            if (!set) {
                ++this.myBitsSet;
                int wordIndex = bitIndex >> 6;
                if (wordIndex >= this.myBitMask.length) {
                    long[] n = new long[Math.max(IdBitSet.calcCapacity(this.myBitMask.length), wordIndex + 1)];
                    System.arraycopy(this.myBitMask, 0, n, 0, this.myBitMask.length);
                    this.myBitMask = n;
                }
                int n = wordIndex;
                this.myBitMask[n] = this.myBitMask[n] | 1L << (bitIndex & 0x3F);
                this.myLastUsedSlot = Math.max(this.myLastUsedSlot, wordIndex);
            }
        }

        private static int calcCapacity(int length) {
            return length + 3 * (length / 5);
        }

        int numberOfBitsSet() {
            return this.myBitsSet;
        }

        boolean remove(int bitIndex) {
            int wordIndex;
            if (!this.get(bitIndex)) {
                return false;
            }
            --this.myBitsSet;
            int n = wordIndex = bitIndex >> 6;
            this.myBitMask[n] = this.myBitMask[n] & (1L << (bitIndex & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
            if (wordIndex == this.myLastUsedSlot) {
                while (this.myLastUsedSlot >= 0 && this.myBitMask[this.myLastUsedSlot] == 0L) {
                    --this.myLastUsedSlot;
                }
            }
            return true;
        }

        boolean get(int bitIndex) {
            int wordIndex = bitIndex >> 6;
            boolean result = false;
            if (wordIndex < this.myBitMask.length) {
                result = (this.myBitMask[wordIndex] & 1L << (bitIndex & 0x3F)) != 0L;
            }
            return result;
        }

        public IdBitSet clone() {
            try {
                IdBitSet clone = (IdBitSet)super.clone();
                if (this.myBitMask.length != this.myLastUsedSlot + 1) {
                    long[] longs = new long[this.myLastUsedSlot + 1];
                    System.arraycopy(this.myBitMask, 0, longs, 0, longs.length);
                    this.myBitMask = longs;
                }
                clone.myBitMask = (long[])this.myBitMask.clone();
                return clone;
            }
            catch (CloneNotSupportedException ex) {
                LOG.error((Throwable)ex);
                return null;
            }
        }

        public int nextSetBit(int bitIndex) {
            int wordIndex = bitIndex >> 6;
            if (wordIndex >= this.myBitMask.length) {
                return -1;
            }
            long word = this.myBitMask[wordIndex] & -1L << bitIndex;
            while (word == 0L) {
                if (++wordIndex == this.myBitMask.length) {
                    return -1;
                }
                word = this.myBitMask[wordIndex];
            }
            return wordIndex * 64 + Long.numberOfTrailingZeros(word);
        }
    }

    private static class IdSet
    extends TIntHashSet {
        private IdSet(int initialCapacity) {
            super(initialCapacity, 0.98f);
        }

        public void compact() {
            if ((int)((float)this.capacity() * this._loadFactor) / Math.max(1, this.size()) >= 3) {
                super.compact();
            }
        }
    }

    private static class IntSetIterator
    implements ValueContainer.IntIterator {
        private final TIntIterator mySetIterator;
        private final int mySize;

        public IntSetIterator(TIntHashSet set) {
            this.mySetIterator = set.iterator();
            this.mySize = set.size();
        }

        @Override
        public boolean hasNext() {
            return this.mySetIterator.hasNext();
        }

        @Override
        public int next() {
            return this.mySetIterator.next();
        }

        @Override
        public int size() {
            return this.mySize;
        }
    }

    private static class SingleValueIterator
    implements ValueContainer.IntIterator {
        private final int myValue;
        private boolean myValueRead = false;

        private SingleValueIterator(int value) {
            this.myValue = value;
        }

        @Override
        public boolean hasNext() {
            return !this.myValueRead;
        }

        @Override
        public int next() {
            int next = this.myValue;
            this.myValueRead = true;
            return next;
        }

        @Override
        public int size() {
            return 1;
        }
    }

    static class EmptyValueIterator<Value>
    extends EmptyIterator<Value>
    implements ValueContainer.ValueIterator<Value> {
        EmptyValueIterator() {
        }

        @Override
        @NotNull
        public ValueContainer.IntIterator getInputIdsIterator() {
            throw new IllegalStateException();
        }

        @Override
        @NotNull
        public ValueContainer.IntPredicate getValueAssociationPredicate() {
            throw new IllegalStateException();
        }

        @Override
        public Object getFileSetObject() {
            throw new IllegalStateException();
        }
    }
}

