/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.ide.caches.CacheUpdater;
import com.intellij.ide.caches.FileContent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CollectingContentIterator;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.IndexingStamp;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class UnindexedFilesUpdater
implements CacheUpdater {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.indexing.UnindexedFilesUpdater");
    private final FileBasedIndexImpl myIndex;
    private final Project myProject;
    private final AtomicBoolean myFinishedUpdate = new AtomicBoolean();
    private long myStarted;

    public UnindexedFilesUpdater(Project project, FileBasedIndexImpl index) {
        this.myIndex = index;
        this.myProject = project;
    }

    public int getNumberOfPendingUpdateJobs() {
        return this.myIndex.getNumberOfPendingInvalidations();
    }

    @NotNull
    public VirtualFile[] queryNeededFiles(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/UnindexedFilesUpdater", "queryNeededFiles"));
        }
        this.myIndex.filesUpdateStarted(this.myProject);
        CollectingContentIterator finder = this.myIndex.createContentIterator(indicator);
        long l = System.currentTimeMillis();
        this.myIndex.iterateIndexableFiles((ContentIterator)finder, this.myProject, indicator);
        this.myIndex.filesUpdateEnumerationFinished();
        LOG.info("Indexable files iterated in " + (System.currentTimeMillis() - l) + " ms");
        List files = finder.getFiles();
        LOG.info("Unindexed files update started: " + files.size() + " files to update");
        this.myFinishedUpdate.set(false);
        this.myStarted = System.currentTimeMillis();
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray((Collection)files);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/UnindexedFilesUpdater", "queryNeededFiles"));
        }
        return virtualFileArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processFile(@NotNull FileContent fileContent) {
        if (fileContent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/UnindexedFilesUpdater", "processFile"));
        }
        try {
            this.myIndex.indexFileContent(this.myProject, fileContent);
        }
        finally {
            IndexingStamp.flushCache(fileContent.getVirtualFile());
        }
    }

    public void updatingDone() {
        if (this.myFinishedUpdate.compareAndSet(false, true)) {
            this.myIndex.filesUpdateFinished(this.myProject);
            LOG.info("Unindexed files update done in " + (System.currentTimeMillis() - this.myStarted) + " ms");
        }
    }

    public void canceled() {
        if (this.myFinishedUpdate.compareAndSet(false, true)) {
            this.myIndex.filesUpdateFinished(this.myProject);
            LOG.info("Unindexed files update canceled");
        }
    }
}

