/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.NotNullComputable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.IndexStorage;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.io.PersistentHashMap;
import gnu.trove.THashMap;
import gnu.trove.TObjectObjectProcedure;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MapReduceIndex<Key, Value, Input>
implements UpdatableIndex<Key, Value, Input> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.indexing.MapReduceIndex");
    @Nullable
    private final ID<Key, Value> myIndexId;
    private final DataIndexer<Key, Value, Input> myIndexer;
    @NotNull
    protected final IndexStorage<Key, Value> myStorage;
    @Nullable
    private PersistentHashMap<Integer, Collection<Key>> myInputsIndex;
    private final ReentrantReadWriteLock myLock;
    private Factory<PersistentHashMap<Integer, Collection<Key>>> myInputsIndexFactory;

    public MapReduceIndex(@Nullable ID<Key, Value> indexId, DataIndexer<Key, Value, Input> indexer, @NotNull IndexStorage<Key, Value> storage) {
        if (storage == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/util/indexing/MapReduceIndex", "<init>"));
        }
        this.myLock = new ReentrantReadWriteLock();
        this.myIndexId = indexId;
        this.myIndexer = indexer;
        this.myStorage = storage;
    }

    @NotNull
    public IndexStorage<Key, Value> getStorage() {
        IndexStorage<Key, Value> indexStorage = this.myStorage;
        if (indexStorage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/MapReduceIndex", "getStorage"));
        }
        return indexStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() throws StorageException {
        block9: {
            try {
                this.getWriteLock().lock();
                this.myStorage.clear();
                if (this.myInputsIndex == null) break block9;
                File baseFile = this.myInputsIndex.getBaseFile();
                try {
                    this.myInputsIndex.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                FileUtil.delete((File)baseFile);
                this.myInputsIndex = this.createInputsIndex();
            }
            catch (StorageException e) {
                LOG.error((Throwable)e);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
            finally {
                this.getWriteLock().unlock();
            }
        }
    }

    @Override
    public void flush() throws StorageException {
        try {
            this.getReadLock().lock();
            PersistentHashMap<Integer, Collection<Key>> inputsIndex = this.myInputsIndex;
            if (inputsIndex != null && inputsIndex.isDirty()) {
                inputsIndex.force();
            }
            this.myStorage.flush();
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof StorageException || cause instanceof IOException) {
                throw new StorageException(cause);
            }
            throw e;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Lock lock = this.getWriteLock();
        try {
            lock.lock();
            try {
                this.myStorage.close();
            }
            finally {
                if (this.myInputsIndex != null) {
                    try {
                        this.myInputsIndex.close();
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                    }
                }
            }
        }
        catch (StorageException e) {
            LOG.error((Throwable)e);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    @NotNull
    public final Lock getReadLock() {
        ReentrantReadWriteLock.ReadLock readLock = this.myLock.readLock();
        if (readLock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/MapReduceIndex", "getReadLock"));
        }
        return readLock;
    }

    @Override
    @NotNull
    public final Lock getWriteLock() {
        ReentrantReadWriteLock.WriteLock writeLock = this.myLock.writeLock();
        if (writeLock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/MapReduceIndex", "getWriteLock"));
        }
        return writeLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processAllKeys(@NotNull Processor<Key> processor, @NotNull GlobalSearchScope scope, IdFilter idFilter) throws StorageException {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/MapReduceIndex", "processAllKeys"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/indexing/MapReduceIndex", "processAllKeys"));
        }
        Lock lock = this.getReadLock();
        try {
            lock.lock();
            boolean bl = this.myStorage.processKeys(processor, scope, idFilter);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ValueContainer<Value> getData(@NotNull Key key) throws StorageException {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/MapReduceIndex", "getData"));
        }
        Lock lock = this.getReadLock();
        lock.lock();
        ValueContainer<Value> valueContainer = this.myStorage.read(key);
        ValueContainer<Value> valueContainer2 = valueContainer;
        if (valueContainer2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/MapReduceIndex", "getData"));
        }
        return valueContainer2;
        finally {
            lock.unlock();
        }
    }

    public void setInputIdToDataKeysIndex(Factory<PersistentHashMap<Integer, Collection<Key>>> factory) throws IOException {
        this.myInputsIndexFactory = factory;
        this.myInputsIndex = this.createInputsIndex();
    }

    @Nullable
    private PersistentHashMap<Integer, Collection<Key>> createInputsIndex() throws IOException {
        Factory<PersistentHashMap<Integer, Collection<Key>>> factory = this.myInputsIndexFactory;
        if (factory != null) {
            try {
                return (PersistentHashMap)factory.create();
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }
        return null;
    }

    @Override
    @NotNull
    public final Computable<Boolean> update(final int inputId, @Nullable Input content) {
        final Map data = content != null ? this.myIndexer.map(content) : Collections.emptyMap();
        ProgressManager.checkCanceled();
        Computable<Boolean> computable = new Computable<Boolean>(){

            public Boolean compute() {
                final Ref exRef = new Ref(null);
                ProgressManager.getInstance().executeNonCancelableSection(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            MapReduceIndex.this.updateWithMap(inputId, data, new NotNullComputable<Collection<Key>>(){

                                @NotNull
                                public Collection<Key> compute() {
                                    Collection<Object> collection;
                                    if (MapReduceIndex.this.myInputsIndex == null) {
                                        SmartList smartList = new SmartList((Object)inputId);
                                        if (smartList == null) {
                                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/MapReduceIndex$1$1$1", "compute"));
                                        }
                                        return smartList;
                                    }
                                    try {
                                        Collection oldKeys = (Collection)MapReduceIndex.this.myInputsIndex.get((Object)inputId);
                                        collection = oldKeys == null ? Collections.emptyList() : oldKeys;
                                    }
                                    catch (IOException e) {
                                        throw new RuntimeException(e);
                                    }
                                    if (collection == null) {
                                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/MapReduceIndex$1$1$1", "compute"));
                                    }
                                    return collection;
                                }
                            });
                        }
                        catch (StorageException ex) {
                            exRef.set((Object)ex);
                        }
                    }
                });
                if (exRef.get() != null) {
                    LOG.info((Throwable)exRef.get());
                    FileBasedIndex.getInstance().requestRebuild(MapReduceIndex.this.myIndexId);
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        };
        if (computable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/MapReduceIndex", "update"));
        }
        return computable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateWithMap(final int inputId, @NotNull Map<Key, Value> newData, @NotNull NotNullComputable<Collection<Key>> oldKeysGetter) throws StorageException {
        block16: {
            if (newData == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/indexing/MapReduceIndex", "updateWithMap"));
            }
            if (oldKeysGetter == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/util/indexing/MapReduceIndex", "updateWithMap"));
            }
            this.getWriteLock().lock();
            try {
                try {
                    for (Object e : (Collection)oldKeysGetter.compute()) {
                        this.myStorage.removeAllValues(e, inputId);
                    }
                }
                catch (Exception e) {
                    throw new StorageException(e);
                }
                if (newData instanceof THashMap) {
                    final Ref exceptionRef = new Ref();
                    boolean bl = ((THashMap)newData).forEachEntry(new TObjectObjectProcedure<Key, Value>(){

                        public boolean execute(Key key, Value value) {
                            try {
                                MapReduceIndex.this.myStorage.addValue(key, inputId, value);
                            }
                            catch (StorageException ex) {
                                exceptionRef.set((Object)ex);
                                return false;
                            }
                            return true;
                        }
                    });
                    if (!bl) {
                        throw (StorageException)exceptionRef.get();
                    }
                } else {
                    for (Map.Entry entry : newData.entrySet()) {
                        this.myStorage.addValue(entry.getKey(), inputId, entry.getValue());
                    }
                }
                if (this.myInputsIndex == null) break block16;
                try {
                    Set<Key> newKeys = newData.keySet();
                    if (newKeys.size() > 0) {
                        this.myInputsIndex.put((Object)inputId, newKeys);
                    } else {
                        this.myInputsIndex.remove((Object)inputId);
                    }
                }
                catch (IOException e) {
                    throw new StorageException(e);
                }
            }
            finally {
                this.getWriteLock().unlock();
            }
        }
    }
}

