/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentHashMap;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.io.DataInputOutputUtil;
import gnu.trove.TObjectLongHashMap;
import gnu.trove.TObjectLongProcedure;
import gnu.trove.TObjectProcedure;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndexingStamp {
    private static final ConcurrentMap<VirtualFile, Timestamps> myTimestampsCache = new ConcurrentHashMap();
    private static final BlockingQueue<VirtualFile> ourFinishedFiles = new ArrayBlockingQueue<VirtualFile>(100);
    private static final Object[] ourLocks = new Object[16];

    private IndexingStamp() {
    }

    public static boolean isFileIndexed(VirtualFile file, ID<?, ?> indexName, long indexCreationStamp) {
        try {
            return IndexingStamp.getIndexStamp(file, indexName) == indexCreationStamp;
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (!(cause instanceof IOException)) {
                throw e;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getIndexStamp(@NotNull VirtualFile file, ID<?, ?> indexName) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/IndexingStamp", "getIndexStamp"));
        }
        Object object = IndexingStamp.getStripedLock(file);
        synchronized (object) {
            Timestamps stamp = IndexingStamp.createOrGetTimeStamp(file);
            if (stamp != null) {
                return stamp.get(indexName);
            }
            return 0L;
        }
    }

    private static Timestamps createOrGetTimeStamp(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/IndexingStamp", "createOrGetTimeStamp"));
        }
        if (file instanceof NewVirtualFile && file.isValid()) {
            Timestamps timestamps = (Timestamps)myTimestampsCache.get(file);
            if (timestamps == null) {
                DataInputStream stream = Timestamps.PERSISTENCE.readAttribute(file);
                try {
                    timestamps = new Timestamps(stream);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                myTimestampsCache.put(file, timestamps);
            }
            return timestamps;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(@NotNull VirtualFile file, @NotNull ID<?, ?> indexName, long indexCreationStamp) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/IndexingStamp", "update"));
        }
        if (indexName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/indexing/IndexingStamp", "update"));
        }
        Object object = IndexingStamp.getStripedLock(file);
        synchronized (object) {
            try {
                Timestamps stamp = IndexingStamp.createOrGetTimeStamp(file);
                if (stamp != null) {
                    stamp.set(indexName, indexCreationStamp);
                }
            }
            catch (InvalidVirtualFileAccessException ignored) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAllIndexedState(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/IndexingStamp", "removeAllIndexedState"));
        }
        Object object = IndexingStamp.getStripedLock(file);
        synchronized (object) {
            if (file instanceof NewVirtualFile && file.isValid()) {
                myTimestampsCache.put(file, new Timestamps());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static Collection<ID<?, ?>> getIndexedIds(@NotNull VirtualFile file) {
        block7: {
            SmartList smartList;
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/IndexingStamp", "getIndexedIds"));
            }
            Object object = IndexingStamp.getStripedLock(file);
            synchronized (object) {
                try {
                    Timestamps stamp = IndexingStamp.createOrGetTimeStamp(file);
                    if (stamp == null || stamp.myIndexStamps == null || stamp.myIndexStamps.isEmpty()) break block7;
                    final SmartList retained = new SmartList();
                    stamp.myIndexStamps.forEach(new TObjectProcedure<ID<?, ?>>(){

                        public boolean execute(ID<?, ?> object) {
                            retained.add(object);
                            return true;
                        }
                    });
                    smartList = retained;
                }
                catch (InvalidVirtualFileAccessException invalidVirtualFileAccessException) {
                    // empty catch block
                    break block7;
                }
            }
            if (smartList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/IndexingStamp", "getIndexedIds"));
            }
            return smartList;
        }
        List<ID<?, ?>> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/IndexingStamp", "getIndexedIds"));
        }
        return list;
    }

    public static void flushCaches() {
        IndexingStamp.flushCache(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushCache(@Nullable VirtualFile finishedFile) {
        while (finishedFile == null || !ourFinishedFiles.offer(finishedFile)) {
            ArrayList files = new ArrayList(ourFinishedFiles.size());
            ourFinishedFiles.drainTo(files);
            if (!files.isEmpty()) {
                for (VirtualFile file : files) {
                    Object object = IndexingStamp.getStripedLock(file);
                    synchronized (object) {
                        Timestamps timestamp = (Timestamps)myTimestampsCache.remove(file);
                        if (timestamp == null) {
                            continue;
                        }
                        try {
                            if (timestamp.isDirty() && file.isValid()) {
                                DataOutputStream sink = Timestamps.PERSISTENCE.writeAttribute(file);
                                timestamp.writeToStream(sink);
                                sink.close();
                            }
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
            if (finishedFile != null) continue;
            break;
        }
    }

    private static Object getStripedLock(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/IndexingStamp", "getStripedLock"));
        }
        if (!(file instanceof NewVirtualFile)) {
            return 0;
        }
        int id = ((NewVirtualFile)file).getId();
        return ourLocks[(id & 0xFF) % ourLocks.length];
    }

    static {
        for (int i = 0; i < ourLocks.length; ++i) {
            IndexingStamp.ourLocks[i] = new Object();
        }
    }

    private static class Timestamps {
        private static final FileAttribute PERSISTENCE = new FileAttribute("__index_stamps__", 1, false);
        private TObjectLongHashMap<ID<?, ?>> myIndexStamps;
        private boolean myIsDirty = false;

        private Timestamps() {
            this.myIsDirty = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Timestamps(@Nullable DataInputStream stream) throws IOException {
            if (stream != null) {
                try {
                    long dominatingIndexStamp = DataInputOutputUtil.readTIME((DataInput)stream);
                    while (stream.available() > 0) {
                        ID id = ID.findById((int)DataInputOutputUtil.readINT((DataInput)stream));
                        if (id == null) continue;
                        long stamp = IndexInfrastructure.getIndexCreationStamp(id);
                        if (this.myIndexStamps == null) {
                            this.myIndexStamps = new TObjectLongHashMap(5, 0.98f);
                        }
                        if (stamp > dominatingIndexStamp) continue;
                        this.myIndexStamps.put((Object)id, stamp);
                    }
                }
                finally {
                    stream.close();
                }
            }
        }

        private void writeToStream(final DataOutputStream stream) throws IOException {
            if (this.myIndexStamps != null && !this.myIndexStamps.isEmpty()) {
                final long[] dominatingIndexStamp = new long[1];
                this.myIndexStamps.forEachEntry(new TObjectLongProcedure<ID<?, ?>>(){

                    public boolean execute(ID<?, ?> a, long b) {
                        dominatingIndexStamp[0] = Math.max(dominatingIndexStamp[0], b);
                        return true;
                    }
                });
                DataInputOutputUtil.writeTIME((DataOutput)stream, (long)dominatingIndexStamp[0]);
                this.myIndexStamps.forEachEntry(new TObjectLongProcedure<ID<?, ?>>(){

                    public boolean execute(ID<?, ?> id, long timestamp) {
                        try {
                            DataInputOutputUtil.writeINT((DataOutput)stream, (int)id.getUniqueId());
                            return true;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            } else {
                DataInputOutputUtil.writeTIME((DataOutput)stream, (long)1040688000000L);
            }
        }

        private long get(ID<?, ?> id) {
            return this.myIndexStamps != null ? this.myIndexStamps.get(id) : 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void set(ID<?, ?> id, long tmst) {
            try {
                if (tmst < 0L) {
                    if (this.myIndexStamps == null) {
                        return;
                    }
                    this.myIndexStamps.remove(id);
                    return;
                }
                if (this.myIndexStamps == null) {
                    this.myIndexStamps = new TObjectLongHashMap(5, 0.98f);
                }
                this.myIndexStamps.put(id, tmst);
            }
            finally {
                this.myIsDirty = true;
            }
        }

        public boolean isDirty() {
            return this.myIsDirty;
        }
    }
}

