/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.project.Project;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.indexing.IdFilter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindSymbolParameters {
    private final String myCompletePattern;
    private final String myLocalPatternName;
    private final GlobalSearchScope mySearchScope;
    private final IdFilter myIdFilter;

    public FindSymbolParameters(@NotNull String pattern, @NotNull String name, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FindSymbolParameters", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/indexing/FindSymbolParameters", "<init>"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/util/indexing/FindSymbolParameters", "<init>"));
        }
        this.myCompletePattern = pattern;
        this.myLocalPatternName = name;
        this.mySearchScope = scope;
        this.myIdFilter = idFilter;
    }

    public String getCompletePattern() {
        return this.myCompletePattern;
    }

    public String getLocalPatternName() {
        return this.myLocalPatternName;
    }

    @NotNull
    public GlobalSearchScope getSearchScope() {
        GlobalSearchScope globalSearchScope = this.mySearchScope;
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FindSymbolParameters", "getSearchScope"));
        }
        return globalSearchScope;
    }

    @Nullable
    public IdFilter getIdFilter() {
        return this.myIdFilter;
    }

    public static FindSymbolParameters wrap(@NotNull String pattern, @NotNull Project project, boolean searchInLibraries) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FindSymbolParameters", "wrap"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/indexing/FindSymbolParameters", "wrap"));
        }
        return new FindSymbolParameters(pattern, pattern, FindSymbolParameters.searchScopeFor(project, searchInLibraries), null);
    }

    public static GlobalSearchScope searchScopeFor(Project project, boolean searchInLibraries) {
        if (project == null) {
            return new EverythingGlobalScope();
        }
        return searchInLibraries ? ProjectScope.getAllScope((Project)project) : ProjectScope.getProjectScope((Project)project);
    }

    public Project getProject() {
        return this.mySearchScope.getProject();
    }

    public boolean isSearchInLibraries() {
        return this.mySearchScope.isSearchInLibraries();
    }
}

