/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.lang.Language;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.DefaultProjectFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.IndexingDataKeys;
import com.intellij.util.indexing.SubstitutedFileType;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;

public final class FileContentImpl
extends UserDataHolderBase
implements FileContent {
    private final VirtualFile myFile;
    private final String myFileName;
    private final FileType myFileType;
    private final Charset myCharset;
    private byte[] myContent;
    private CharSequence myContentAsText;
    private final long myStamp;
    private static final Key<PsiFile> CACHED_PSI = Key.create((String)"cached psi from content");

    public Project getProject() {
        return (Project)this.getUserData(IndexingDataKeys.PROJECT);
    }

    @NotNull
    public PsiFile getPsiFile() {
        PsiFile psi = (PsiFile)this.getUserData(IndexingDataKeys.PSI_FILE);
        if (psi == null) {
            psi = (PsiFile)this.getUserData(CACHED_PSI);
        }
        if (psi == null) {
            psi = this.createFileFromText(this.getContentAsText());
            psi.putUserData(IndexingDataKeys.VIRTUAL_FILE, (Object)this.getFile());
            this.putUserData(CACHED_PSI, psi);
        }
        PsiFile psiFile = psi;
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileContentImpl", "getPsiFile"));
        }
        return psiFile;
    }

    public PsiFile createFileFromText(CharSequence text) {
        Project project = this.getProject();
        if (project == null) {
            project = DefaultProjectFactory.getInstance().getDefaultProject();
        }
        Language language = ((LanguageFileType)this.getFileTypeWithoutSubstitution()).getLanguage();
        Language substitutedLanguage = LanguageSubstitutors.INSTANCE.substituteLanguage(language, this.getFile(), project);
        return PsiFileFactory.getInstance((Project)project).createFileFromText(this.getFileName(), substitutedLanguage, text, false, false, true);
    }

    public FileContentImpl(@NotNull VirtualFile file, @NotNull CharSequence contentAsText, Charset charset) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileContentImpl", "<init>"));
        }
        if (contentAsText == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/indexing/FileContentImpl", "<init>"));
        }
        this(file, contentAsText, null, charset, -1L);
    }

    public FileContentImpl(@NotNull VirtualFile file, @NotNull CharSequence contentAsText, Charset charset, long documentStamp) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileContentImpl", "<init>"));
        }
        if (contentAsText == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/indexing/FileContentImpl", "<init>"));
        }
        this(file, contentAsText, null, charset, documentStamp);
    }

    public FileContentImpl(@NotNull VirtualFile file, @NotNull byte[] content) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileContentImpl", "<init>"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/indexing/FileContentImpl", "<init>"));
        }
        this(file, null, content, LoadTextUtil.detectCharsetAndSetBOM(file, content), -1L);
    }

    public FileContentImpl(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileContentImpl", "<init>"));
        }
        this(file, null, null, null, -1L);
    }

    private FileContentImpl(@NotNull VirtualFile file, CharSequence contentAsText, byte[] content, Charset charset, long stamp) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileContentImpl", "<init>"));
        }
        this.myFile = file;
        this.myContentAsText = contentAsText;
        this.myContent = content;
        this.myCharset = charset;
        this.myFileType = file.getFileType();
        this.myFileName = file.getName();
        this.myStamp = stamp;
    }

    @NotNull
    private FileType substituteFileType(VirtualFile file, FileType fileType) {
        Project project = this.getProject();
        FileType fileType2 = SubstitutedFileType.substituteFileType(file, fileType, project);
        if (fileType2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileContentImpl", "substituteFileType"));
        }
        return fileType2;
    }

    @NotNull
    public FileType getSubstitutedFileType() {
        FileType fileType = this.substituteFileType(this.myFile, this.myFileType);
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileContentImpl", "getSubstitutedFileType"));
        }
        return fileType;
    }

    public static FileContent createByFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileContentImpl", "createByFile"));
        }
        try {
            return new FileContentImpl(file, file.contentsToByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public FileType getFileTypeWithoutSubstitution() {
        return this.myFileType;
    }

    @NotNull
    public FileType getFileType() {
        FileType fileType = this.getSubstitutedFileType();
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileContentImpl", "getFileType"));
        }
        return fileType;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileContentImpl", "getFile"));
        }
        return virtualFile;
    }

    @NotNull
    public String getFileName() {
        String string = this.myFileName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileContentImpl", "getFileName"));
        }
        return string;
    }

    public Charset getCharset() {
        return this.myCharset;
    }

    public long getStamp() {
        return this.myStamp;
    }

    public byte[] getContent() {
        if (this.myContent == null && this.myContentAsText != null) {
            try {
                this.myContent = this.myCharset != null ? ((Object)this.myContentAsText).toString().getBytes(this.myCharset.name()) : ((Object)this.myContentAsText).toString().getBytes();
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return this.myContent;
    }

    @NotNull
    public CharSequence getContentAsText() {
        if (this.myFileType.isBinary()) {
            throw new IllegalDataException("Cannot obtain text for binary file type : " + this.myFileType.getDescription());
        }
        CharSequence content = (CharSequence)this.getUserData(IndexingDataKeys.FILE_TEXT_CONTENT_KEY);
        if (content != null) {
            CharSequence charSequence = content;
            if (charSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileContentImpl", "getContentAsText"));
            }
            return charSequence;
        }
        if (this.myContentAsText == null && this.myContent != null) {
            this.myContentAsText = LoadTextUtil.getTextByBinaryPresentation(this.myContent, this.myCharset);
            this.myContent = null;
        }
        CharSequence charSequence = this.myContentAsText;
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileContentImpl", "getContentAsText"));
        }
        return charSequence;
    }

    public String toString() {
        return this.myFileName;
    }

    public static class IllegalDataException
    extends RuntimeException {
        public IllegalDataException(String message) {
            super(message);
        }
    }
}

