/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.util.Computable;
import com.intellij.util.indexing.UpdatableValueContainer;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.ValueContainerImpl;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntProcedure;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ChangeTrackingValueContainer<Value>
extends UpdatableValueContainer<Value> {
    private ValueContainerImpl<Value> myAdded;
    private TIntHashSet myInvalidated;
    private volatile ValueContainerImpl<Value> myMerged;
    private final Initializer<Value> myInitializer;

    public ChangeTrackingValueContainer(Initializer<Value> initializer) {
        this.myInitializer = initializer;
    }

    @Override
    public void addValue(int inputId, Value value) {
        ValueContainerImpl<Value> merged = this.myMerged;
        if (merged != null) {
            merged.addValue(inputId, value);
        }
        if (this.myAdded == null) {
            this.myAdded = new ValueContainerImpl();
        }
        this.myAdded.addValue(inputId, value);
    }

    @Override
    public void removeAssociatedValue(int inputId) {
        ValueContainerImpl<Value> merged = this.myMerged;
        if (merged != null) {
            merged.removeAssociatedValue(inputId);
        }
        if (this.myAdded != null) {
            this.myAdded.removeAssociatedValue(inputId);
        }
        if (this.myInvalidated == null) {
            this.myInvalidated = new TIntHashSet(1);
        }
        this.myInvalidated.add(inputId);
    }

    @Override
    public int size() {
        return this.getMergedData().size();
    }

    @Override
    @NotNull
    public ValueContainer.ValueIterator<Value> getValueIterator() {
        ValueContainer.ValueIterator<Value> valueIterator = this.getMergedData().getValueIterator();
        if (valueIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/ChangeTrackingValueContainer", "getValueIterator"));
        }
        return valueIterator;
    }

    @Override
    @NotNull
    public List<Value> toValueList() {
        List<Value> list = this.getMergedData().toValueList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/ChangeTrackingValueContainer", "toValueList"));
        }
        return list;
    }

    @Override
    public boolean isAssociated(Value value, int inputId) {
        return this.getMergedData().isAssociated(value, inputId);
    }

    @Override
    @NotNull
    public ValueContainer.IntPredicate getValueAssociationPredicate(Value value) {
        ValueContainer.IntPredicate intPredicate = this.getMergedData().getValueAssociationPredicate(value);
        if (intPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/ChangeTrackingValueContainer", "getValueAssociationPredicate"));
        }
        return intPredicate;
    }

    @Override
    @NotNull
    public ValueContainer.IntIterator getInputIdsIterator(Value value) {
        ValueContainer.IntIterator intIterator = this.getMergedData().getInputIdsIterator(value);
        if (intIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/ChangeTrackingValueContainer", "getInputIdsIterator"));
        }
        return intIterator;
    }

    public void dropMergedData() {
        this.myMerged = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValueContainerImpl<Value> getMergedData() {
        ValueContainerImpl<Value> merged = this.myMerged;
        if (merged != null) {
            return merged;
        }
        Object object = this.myInitializer.getLock();
        synchronized (object) {
            merged = this.myMerged;
            if (merged != null) {
                return merged;
            }
            ValueContainer fromDisk = (ValueContainer)this.myInitializer.compute();
            final ValueContainerImpl newMerged = fromDisk instanceof ValueContainerImpl ? ((ValueContainerImpl)fromDisk).copy() : ((ChangeTrackingValueContainer)fromDisk).getMergedData().copy();
            if (this.myInvalidated != null) {
                this.myInvalidated.forEach(new TIntProcedure(){

                    public boolean execute(int inputId) {
                        newMerged.removeAssociatedValue(inputId);
                        return true;
                    }
                });
            }
            if (this.myAdded != null) {
                this.myAdded.forEach(new ValueContainer.ContainerAction<Value>(){

                    @Override
                    public boolean perform(int id, Value value) {
                        newMerged.removeAssociatedValue(id);
                        newMerged.addValue(id, value);
                        return true;
                    }
                });
            }
            this.setNeedsCompacting(fromDisk.needsCompacting());
            this.myMerged = newMerged;
            return newMerged;
        }
    }

    public boolean isDirty() {
        return this.myAdded != null && this.myAdded.size() > 0 || this.myInvalidated != null && !this.myInvalidated.isEmpty() || this.needsCompacting();
    }

    @Nullable
    public ValueContainer<Value> getAddedDelta() {
        return this.myAdded;
    }

    @Nullable
    public TIntHashSet getInvalidated() {
        return this.myInvalidated;
    }

    public static interface Initializer<T>
    extends Computable<ValueContainer<T>> {
        public Object getLock();
    }
}

