/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.URLUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UrlImpl
implements Url {
    private final String scheme;
    private final String authority;
    private final String path;
    private String decodedPath;
    private final String parameters;
    private String externalForm;
    private UrlImpl withoutParameters;

    public UrlImpl(@Nullable String path) {
        this(null, null, path, null);
    }

    UrlImpl(@NotNull String scheme, @Nullable String authority, @Nullable String path) {
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/UrlImpl", "<init>"));
        }
        this(scheme, authority, path, null);
    }

    public UrlImpl(@Nullable String scheme, @Nullable String authority, @Nullable String path, @Nullable String parameters) {
        this.scheme = scheme;
        this.authority = StringUtil.nullize((String)authority);
        this.path = StringUtil.isEmpty((String)path) ? "/" : path;
        this.parameters = StringUtil.nullize((String)parameters);
    }

    @NotNull
    public String getPath() {
        if (this.decodedPath == null) {
            this.decodedPath = URLUtil.unescapePercentSequences((String)this.path);
        }
        String string = this.decodedPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/UrlImpl", "getPath"));
        }
        return string;
    }

    @Nullable
    public String getScheme() {
        return this.scheme;
    }

    @Nullable
    public String getAuthority() {
        return this.authority;
    }

    public boolean isInLocalFileSystem() {
        return "file".equals(this.scheme);
    }

    @Nullable
    public String getParameters() {
        return this.parameters;
    }

    public String toDecodedForm() {
        StringBuilder builder = new StringBuilder();
        if (this.scheme != null) {
            builder.append(this.scheme);
            if (this.authority != null || this.isInLocalFileSystem()) {
                builder.append("://");
            } else {
                builder.append(':');
            }
            if (this.authority != null) {
                builder.append(this.authority);
            }
        }
        builder.append(this.getPath());
        if (this.parameters != null) {
            builder.append(this.parameters);
        }
        return builder.toString();
    }

    @NotNull
    public String toExternalForm() {
        if (this.externalForm != null) {
            String string = this.externalForm;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/UrlImpl", "toExternalForm"));
            }
            return string;
        }
        if (!(this.path.charAt(0) == '/' && this.authority != null || this.isInLocalFileSystem())) {
            String string = this.toDecodedForm();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/UrlImpl", "toExternalForm"));
            }
            return string;
        }
        String result = Urls.toUriWithoutParameters(this).toASCIIString();
        if (this.parameters != null) {
            result = result + this.parameters;
        }
        this.externalForm = result;
        String string = result;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/UrlImpl", "toExternalForm"));
        }
        return string;
    }

    @NotNull
    public Url trimParameters() {
        if (this.parameters == null) {
            UrlImpl urlImpl = this;
            if (urlImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/UrlImpl", "trimParameters"));
            }
            return urlImpl;
        }
        if (this.withoutParameters == null) {
            this.withoutParameters = new UrlImpl(this.scheme, this.authority, this.path, null);
        }
        UrlImpl urlImpl = this.withoutParameters;
        if (urlImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/UrlImpl", "trimParameters"));
        }
        return urlImpl;
    }

    public String toString() {
        return this.toExternalForm();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UrlImpl)) {
            return false;
        }
        UrlImpl url = (UrlImpl)o;
        return StringUtil.equals((CharSequence)this.scheme, (CharSequence)url.scheme) && StringUtil.equals((CharSequence)this.authority, (CharSequence)url.authority) && this.getPath().equals(url.getPath()) && StringUtil.equals((CharSequence)this.parameters, (CharSequence)url.parameters);
    }

    public boolean equalsIgnoreCase(@Nullable Url o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UrlImpl)) {
            return false;
        }
        UrlImpl url = (UrlImpl)o;
        return StringUtil.equalsIgnoreCase((CharSequence)this.scheme, (CharSequence)url.scheme) && StringUtil.equalsIgnoreCase((CharSequence)this.authority, (CharSequence)url.authority) && this.getPath().equalsIgnoreCase(url.getPath()) && StringUtil.equalsIgnoreCase((CharSequence)this.parameters, (CharSequence)url.parameters);
    }

    public boolean equalsIgnoreParameters(@Nullable Url url) {
        return url != null && this.equals(url.trimParameters());
    }

    private int computeHashCode(boolean caseSensitive) {
        int result = UrlImpl.stringHashCode(this.scheme, caseSensitive);
        result = 31 * result + UrlImpl.stringHashCode(this.authority, caseSensitive);
        result = 31 * result + UrlImpl.stringHashCode(this.getPath(), caseSensitive);
        result = 31 * result + UrlImpl.stringHashCode(this.parameters, caseSensitive);
        return result;
    }

    private static int stringHashCode(@Nullable CharSequence string, boolean caseSensitive) {
        return string == null ? 0 : (caseSensitive ? string.hashCode() : StringUtil.stringHashCodeInsensitive((CharSequence)string));
    }

    public int hashCode() {
        return this.computeHashCode(true);
    }

    public int hashCodeCaseInsensitive() {
        return this.computeHashCode(false);
    }
}

