/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.containers.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public class SingletonInstancesCache {
    private static final ConcurrentHashMap<String, Object> CACHE = new ConcurrentHashMap();

    private SingletonInstancesCache() {
    }

    public static <T> T getInstance(@NotNull String className, ClassLoader classLoader) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/SingletonInstancesCache", "getInstance"));
        }
        Object res = CACHE.get((Object)className);
        if (res == null) {
            try {
                res = classLoader.loadClass(className).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Object oldValue = CACHE.putIfAbsent((Object)className, res);
            if (oldValue != null) {
                res = oldValue;
            }
        }
        return (T)res;
    }
}

