/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentEx;
import org.jetbrains.annotations.NotNull;

public final class DocumentUtil {
    private DocumentUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeInBulk(@NotNull Document document, boolean executeInBulk, @NotNull Runnable task) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/DocumentUtil", "executeInBulk"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/util/DocumentUtil", "executeInBulk"));
        }
        if (!(document instanceof DocumentEx)) {
            task.run();
            return;
        }
        DocumentEx documentEx = (DocumentEx)document;
        if (executeInBulk == documentEx.isInBulkUpdate()) {
            task.run();
            return;
        }
        documentEx.setInBulkUpdate(executeInBulk);
        try {
            task.run();
            documentEx.setInBulkUpdate(!executeInBulk);
        }
        catch (Throwable throwable) {
            documentEx.setInBulkUpdate(!executeInBulk);
            throw throwable;
        }
    }

    public static void writeInRunUndoTransparentAction(final @NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/DocumentUtil", "writeInRunUndoTransparentAction"));
        }
        CommandProcessor.getInstance().runUndoTransparentAction(new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(runnable);
            }
        });
    }

    public static int getFirstNonSpaceCharOffset(@NotNull Document document, int line) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/DocumentUtil", "getFirstNonSpaceCharOffset"));
        }
        int startOffset = document.getLineStartOffset(line);
        int endOffset = document.getLineEndOffset(line);
        return DocumentUtil.getFirstNonSpaceCharOffset(document, startOffset, endOffset);
    }

    public static int getFirstNonSpaceCharOffset(@NotNull Document document, int startOffset, int endOffset) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/DocumentUtil", "getFirstNonSpaceCharOffset"));
        }
        CharSequence text = document.getImmutableCharSequence();
        for (int i = startOffset; i < endOffset; ++i) {
            char c = text.charAt(i);
            if (c == ' ' || c == '\t') continue;
            return i;
        }
        return startOffset;
    }
}

