/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.reference.SoftReference;
import com.intellij.util.SnappyInitializer;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import org.xerial.snappy.Snappy;

public class CompressionUtil {
    private static final boolean ourCanUseSnappy;
    private static final int COMPRESSION_THRESHOLD = 64;
    private static final ThreadLocal<java.lang.ref.SoftReference<byte[]>> spareBufferLocal;
    private static final int STRING_COMPRESSION_THRESHOLD = 1024;

    public static int writeCompressed(DataOutput out, byte[] bytes, int length) throws IOException {
        if (length > 64 && ourCanUseSnappy) {
            java.lang.ref.SoftReference<byte[]> reference = spareBufferLocal.get();
            byte[] compressedOutputBuffer = (byte[])SoftReference.dereference(reference);
            int maxCompressedSize = 32 + length + length / 6;
            if (compressedOutputBuffer == null || compressedOutputBuffer.length < maxCompressedSize) {
                compressedOutputBuffer = new byte[maxCompressedSize];
                spareBufferLocal.set(new java.lang.ref.SoftReference<byte[]>(compressedOutputBuffer));
            }
            int compressedSize = Snappy.rawCompress((Object)bytes, (int)0, (int)length, (byte[])compressedOutputBuffer, (int)0);
            DataInputOutputUtil.writeINT((DataOutput)out, (int)(-compressedSize));
            out.write(compressedOutputBuffer, 0, compressedSize);
            return compressedSize;
        }
        DataInputOutputUtil.writeINT((DataOutput)out, (int)length);
        out.write(bytes, 0, length);
        return length;
    }

    public static byte[] readCompressed(DataInput in) throws IOException {
        int size = DataInputOutputUtil.readINT((DataInput)in);
        byte[] bytes = new byte[Math.abs(size)];
        in.readFully(bytes);
        if (size >= 0) {
            return bytes;
        }
        if (!ourCanUseSnappy) {
            throw new IOException("Can not read compressed data");
        }
        return Snappy.uncompress((byte[])bytes);
    }

    public static CharSequence uncompressCharSequence(Object string, Charset charset) {
        if (string instanceof CharSequence) {
            return (CharSequence)string;
        }
        byte[] b = (byte[])string;
        try {
            return Snappy.uncompressString((byte[])b, (Charset)charset);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Object compressCharSequence(CharSequence string, Charset charset) {
        if (!ourCanUseSnappy || string.length() < 1024) {
            if (string instanceof CharBuffer && ((CharBuffer)string).capacity() > 1024) {
                string = ((Object)string).toString();
            }
            return string;
        }
        try {
            return Snappy.compress((String)((Object)string).toString(), (Charset)charset);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return string;
        }
    }

    static {
        boolean canUseSnappy = false;
        try {
            if (!SnappyInitializer.NO_SNAPPY) {
                Field impl = Snappy.class.getDeclaredField("impl");
                impl.setAccessible(true);
                canUseSnappy = impl.get(null) != null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ourCanUseSnappy = canUseSnappy;
        spareBufferLocal = new ThreadLocal();
    }
}

