/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs;

import com.intellij.ui.FileColorManager;
import com.intellij.ui.table.JBTable;
import com.intellij.ui.tabs.FileColorConfiguration;
import com.intellij.ui.tabs.FileColorConfigurationEditDialog;
import com.intellij.ui.tabs.FileColorManagerImpl;
import com.intellij.util.ui.EditableModel;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public abstract class FileColorSettingsTable
extends JBTable {
    private static final int NAME_COLUMN = 0;
    private static final int COLOR_COLUMN = 1;
    private final List<FileColorConfiguration> myOriginal;
    @NotNull
    private final FileColorManager myManager;

    public FileColorSettingsTable(@NotNull FileColorManager manager, @NotNull List<FileColorConfiguration> configurations) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/tabs/FileColorSettingsTable", "<init>"));
        }
        if (configurations == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ui/tabs/FileColorSettingsTable", "<init>"));
        }
        super((TableModel)new ModelAdapter(manager, FileColorSettingsTable.copy(configurations)));
        this.myManager = manager;
        this.setStriped(true);
        this.myOriginal = configurations;
        this.setAutoResizeMode(3);
        TableColumnModel columnModel = this.getColumnModel();
        TableColumn nameColumn = columnModel.getColumn(0);
        nameColumn.setCellRenderer(new ScopeNameRenderer());
        TableColumn colorColumn = columnModel.getColumn(1);
        colorColumn.setCellRenderer(new ColorCellRenderer(manager));
    }

    private static List<FileColorConfiguration> copy(@NotNull List<FileColorConfiguration> configurations) {
        if (configurations == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/tabs/FileColorSettingsTable", "copy"));
        }
        ArrayList<FileColorConfiguration> result = new ArrayList<FileColorConfiguration>();
        for (FileColorConfiguration c : configurations) {
            try {
                result.add(c.clone());
            }
            catch (CloneNotSupportedException e) {
                assert (false) : "Should not happen!";
            }
        }
        return result;
    }

    protected abstract void apply(@NotNull List<FileColorConfiguration> var1);

    public ModelAdapter getModel() {
        return (ModelAdapter)super.getModel();
    }

    public boolean editCellAt(int row, int column, EventObject e) {
        if (e == null || e instanceof MouseEvent && ((MouseEvent)e).getClickCount() == 1) {
            return false;
        }
        Object at = this.getModel().getValueAt(row, column);
        FileColorConfigurationEditDialog dialog = new FileColorConfigurationEditDialog(this.myManager, (FileColorConfiguration)at);
        dialog.getScopeComboBox().setEnabled(false);
        dialog.show();
        return false;
    }

    public boolean isModified() {
        List<FileColorConfiguration> current = this.getModel().getConfigurations();
        if (this.myOriginal.size() != current.size()) {
            return true;
        }
        for (int i = 0; i < current.size(); ++i) {
            if (this.myOriginal.get(i).equals(current.get(i))) continue;
            return true;
        }
        return false;
    }

    public void reset() {
        this.getModel().setConfigurations(this.myOriginal);
    }

    public void performRemove() {
        int rowCount = this.getSelectedRowCount();
        if (rowCount > 0) {
            int[] rows = this.getSelectedRows();
            for (int i = rows.length - 1; i >= 0; --i) {
                this.removeConfiguration(rows[i]);
            }
        }
    }

    public void moveUp() {
        int index;
        int rowCount = this.getSelectedRowCount();
        if (rowCount == 1 && (index = this.getModel().moveUp(this.getSelectedRows()[0])) > -1) {
            this.getSelectionModel().setSelectionInterval(index, index);
        }
    }

    public void moveDown() {
        int index;
        int rowCount = this.getSelectedRowCount();
        if (rowCount == 1 && (index = this.getModel().moveDown(this.getSelectedRows()[0])) > -1) {
            this.getSelectionModel().setSelectionInterval(index, index);
        }
    }

    public void apply() {
        if (this.isModified()) {
            this.apply(this.getModel().getConfigurations());
        }
    }

    public FileColorConfiguration removeConfiguration(int index) {
        FileColorConfiguration removed = this.getModel().remove(index);
        int rowCount = this.getRowCount();
        if (rowCount > 0) {
            if (index > rowCount - 1) {
                this.getSelectionModel().setSelectionInterval(rowCount - 1, rowCount - 1);
            } else {
                this.getSelectionModel().setSelectionInterval(index, index);
            }
        }
        return removed;
    }

    public void addConfiguration(@NotNull FileColorConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/tabs/FileColorSettingsTable", "addConfiguration"));
        }
        this.getModel().add(configuration);
    }

    private static class ColorCellRenderer
    extends ScopeNameRenderer {
        private Color myColor;
        private final FileColorManager myManager;

        private ColorCellRenderer(FileColorManager manager) {
            this.setOpaque(true);
            this.myManager = manager;
            this.setIcon(EmptyIcon.ICON_16);
        }

        private void setIconColor(Color color) {
            this.myColor = color;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (!(value instanceof FileColorConfiguration)) {
                return this;
            }
            this.preinit(table, isSelected, hasFocus);
            FileColorConfiguration configuration = (FileColorConfiguration)value;
            this.setIconColor(this.myManager.getColor(configuration.getColorName()));
            this.setText(FileColorManagerImpl.getAlias(configuration.getColorPresentableName()));
            return this;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.myColor != null) {
                Icon icon = this.getIcon();
                int width = icon.getIconWidth();
                int height = icon.getIconHeight();
                Color old = g.getColor();
                g.setColor(this.myColor);
                g.fillRect(0, 0, width, height);
                g.setColor(old);
            }
        }
    }

    private static class ScopeNameRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final Border NO_FOCUS_BORDER = BorderFactory.createEmptyBorder(1, 1, 1, 1);

        private ScopeNameRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (!(value instanceof FileColorConfiguration)) {
                return this;
            }
            this.preinit(table, isSelected, hasFocus);
            FileColorConfiguration configuration = (FileColorConfiguration)value;
            this.setText(FileColorManagerImpl.getAlias(configuration.getScopeName()));
            return this;
        }

        protected void preinit(JTable table, boolean isSelected, boolean hasFocus) {
            this.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
            this.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
            this.setBorder(hasFocus ? UIUtil.getTableFocusCellHighlightBorder() : NO_FOCUS_BORDER);
        }
    }

    private static class ModelAdapter
    extends AbstractTableModel
    implements EditableModel {
        private final FileColorManager myManager;
        private List<FileColorConfiguration> myConfigurations;

        private ModelAdapter(FileColorManager manager, List<FileColorConfiguration> configurations) {
            this.myManager = manager;
            this.myConfigurations = configurations;
        }

        @Override
        public String getColumnName(int column) {
            return column == 0 ? "Scope" : "Color";
        }

        @Override
        public int getRowCount() {
            return this.myConfigurations.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.myConfigurations.get(rowIndex);
        }

        @NotNull
        public List<FileColorConfiguration> getConfigurations() {
            List<FileColorConfiguration> list = this.myConfigurations;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/tabs/FileColorSettingsTable$ModelAdapter", "getConfigurations"));
            }
            return list;
        }

        public FileColorConfiguration remove(int index) {
            FileColorConfiguration removed = this.myConfigurations.remove(index);
            this.fireTableRowsDeleted(index, index);
            return removed;
        }

        public void add(@NotNull FileColorConfiguration configuration) {
            if (configuration == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/tabs/FileColorSettingsTable$ModelAdapter", "add"));
            }
            this.myConfigurations.add(configuration);
            this.fireTableRowsInserted(this.myConfigurations.size() - 1, this.myConfigurations.size() - 1);
        }

        public void setConfigurations(List<FileColorConfiguration> original) {
            this.myConfigurations = FileColorSettingsTable.copy(original);
            this.fireTableDataChanged();
        }

        public int moveUp(int index) {
            if (index > 0) {
                FileColorConfiguration configuration = this.myConfigurations.get(index);
                this.myConfigurations.remove(index);
                this.myConfigurations.add(index - 1, configuration);
                this.fireTableRowsUpdated(index - 1, index);
                return index - 1;
            }
            return -1;
        }

        public int moveDown(int index) {
            if (index < this.getRowCount() - 1) {
                FileColorConfiguration configuration = this.myConfigurations.get(index);
                this.myConfigurations.remove(index);
                this.myConfigurations.add(index + 1, configuration);
                this.fireTableRowsUpdated(index, index + 1);
                return index + 1;
            }
            return -1;
        }

        public void addRow() {
            FileColorConfigurationEditDialog dialog = new FileColorConfigurationEditDialog((FileColorManagerImpl)this.myManager, null);
            dialog.show();
            if (dialog.getExitCode() == 0) {
                this.myConfigurations.add(dialog.getConfiguration());
            }
        }

        public void removeRow(int index) {
            this.myConfigurations.remove(index);
        }

        public void exchangeRows(int oldIndex, int newIndex) {
            this.myConfigurations.add(newIndex, this.myConfigurations.remove(oldIndex));
            this.fireTableRowsUpdated(Math.min(oldIndex, newIndex), Math.max(oldIndex, newIndex));
        }

        public boolean canExchangeRows(int oldIndex, int newIndex) {
            return true;
        }
    }
}

