/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ui.UIUtil;
import com.sun.awt.AWTUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import javax.swing.JDialog;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;

public interface PopupComponent {
    public static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.popup.PopupComponent");

    public void hide(boolean var1);

    public void show();

    public Window getWindow();

    public void setRequestFocus(boolean var1);

    public boolean isPopupWindow(Window var1);

    public static class AwtPopupWrapper
    implements PopupComponent {
        private final Popup myPopup;
        private JBPopup myJBPopup;

        public AwtPopupWrapper(Popup popup, JBPopup jbPopup) {
            this.myPopup = popup;
            this.myJBPopup = jbPopup;
            if (SystemInfo.isMac && UIUtil.isUnderAquaLookAndFeel()) {
                Component c = (Component)ReflectionUtil.getField(Popup.class, (Object)this.myPopup, Component.class, (String)"component");
                c.setBackground(UIUtil.getPanelBackground());
            }
        }

        @Override
        public boolean isPopupWindow(Window window) {
            Window wnd = this.getWindow();
            return wnd != null && wnd == window;
        }

        @Override
        public void hide(boolean dispose) {
            JRootPane rootPane;
            this.myPopup.hide();
            Window wnd = this.getWindow();
            if (wnd instanceof JWindow && (rootPane = ((JWindow)wnd).getRootPane()) != null) {
                ReflectionUtil.resetField((Object)rootPane, (String)"clientProperties");
                Container cp = rootPane.getContentPane();
                if (cp != null) {
                    cp.removeAll();
                }
            }
        }

        @Override
        public void show() {
            Window wnd = this.getWindow();
            AwtPopupWrapper.fixFlickering(wnd, false);
            this.myPopup.show();
            AwtPopupWrapper.fixFlickering(wnd, true);
            if (wnd instanceof JWindow) {
                ((JWindow)wnd).getRootPane().putClientProperty("JBPopup", this.myJBPopup);
            }
        }

        private static void fixFlickering(Window wnd, boolean opaque) {
            try {
                if (UIUtil.isUnderDarcula() && !SystemInfo.isLinux && wnd != null) {
                    AWTUtilities.setWindowOpaque((Window)wnd, (boolean)opaque);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public Window getWindow() {
            Component c = (Component)ReflectionUtil.getField(Popup.class, (Object)this.myPopup, Component.class, (String)"component");
            return c instanceof JWindow ? (JWindow)c : null;
        }

        @Override
        public void setRequestFocus(boolean requestFocus) {
        }
    }

    public static class DialogPopupWrapper
    implements PopupComponent {
        private final JDialog myDialog;
        private boolean myRequestFocus = true;

        @Override
        public void setRequestFocus(boolean requestFocus) {
            this.myRequestFocus = requestFocus;
        }

        @Override
        public boolean isPopupWindow(Window window) {
            return this.myDialog != null && this.myDialog == window;
        }

        public DialogPopupWrapper(Component owner, Component content, int x, int y, JBPopup jbPopup) {
            Window wnd;
            if (!owner.isShowing()) {
                throw new IllegalArgumentException("Popup owner must be showing");
            }
            Window window = wnd = owner instanceof Window ? (Window)owner : SwingUtilities.getWindowAncestor(owner);
            this.myDialog = wnd instanceof Frame ? new JDialog((Frame)wnd) : (wnd instanceof Dialog ? new JDialog((Dialog)wnd) : new JDialog());
            this.myDialog.getContentPane().setLayout(new BorderLayout());
            this.myDialog.getContentPane().add(content, "Center");
            this.myDialog.getRootPane().putClientProperty("JBPopup", jbPopup);
            this.myDialog.setUndecorated(true);
            this.myDialog.setBackground(UIUtil.getPanelBackground());
            this.myDialog.pack();
            this.myDialog.setLocation(x, y);
        }

        @Override
        public Window getWindow() {
            return this.myDialog;
        }

        @Override
        public void hide(boolean dispose) {
            this.myDialog.setVisible(false);
            if (dispose) {
                this.myDialog.dispose();
                this.myDialog.getRootPane().putClientProperty("JBPopup", null);
            }
        }

        @Override
        public void show() {
            if (!this.myRequestFocus) {
                this.myDialog.setFocusableWindowState(false);
            }
            try {
                if (UIUtil.isUnderDarcula()) {
                    AWTUtilities.setWindowOpaque((Window)this.myDialog, (boolean)false);
                }
            }
            catch (Exception ignore) {
                // empty catch block
            }
            this.myDialog.setVisible(true);
            try {
                if (UIUtil.isUnderDarcula()) {
                    AWTUtilities.setWindowOpaque((Window)this.myDialog, (boolean)true);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DialogPopupWrapper.this.myDialog.setFocusableWindowState(true);
                }
            });
        }
    }

    public static interface Factory {
        public PopupComponent getPopup(Component var1, Component var2, int var3, int var4, JBPopup var5);

        public boolean isNativePopup();

        public static class Dialog
        implements Factory {
            @Override
            public PopupComponent getPopup(Component owner, Component content, int x, int y, JBPopup jbPopup) {
                return new DialogPopupWrapper(owner, content, x, y, jbPopup);
            }

            @Override
            public boolean isNativePopup() {
                return false;
            }
        }

        public static class AwtHeavyweight
        implements Factory {
            @Override
            public PopupComponent getPopup(Component owner, Component content, int x, int y, JBPopup jbPopup) {
                PopupFactory factory = PopupFactory.getSharedInstance();
                int oldType = PopupUtil.getPopupType((PopupFactory)factory);
                PopupUtil.setPopupType((PopupFactory)factory, (int)2);
                Popup popup = factory.getPopup(owner, content, x, y);
                if (oldType >= 0) {
                    PopupUtil.setPopupType((PopupFactory)factory, (int)oldType);
                }
                return new AwtPopupWrapper(popup, jbPopup);
            }

            @Override
            public boolean isNativePopup() {
                return true;
            }
        }

        public static class AwtDefault
        implements Factory {
            @Override
            public PopupComponent getPopup(Component owner, Component content, int x, int y, JBPopup jbPopup) {
                PopupFactory factory = PopupFactory.getSharedInstance();
                Popup popup = factory.getPopup(owner, content, x, y);
                return new AwtPopupWrapper(popup, jbPopup);
            }

            @Override
            public boolean isNativePopup() {
                return true;
            }
        }
    }
}

