/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.BalloonImpl;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BalloonPopupBuilderImpl
implements BalloonBuilder {
    @Nullable
    private final Map<Disposable, List<Balloon>> myStorage;
    @Nullable
    private Disposable myAnchor;
    private final JComponent myContent;
    private Color myBorder;
    @Nullable
    private Insets myBorderInsets;
    private Color myFill;
    private boolean myHideOnMouseOutside;
    private boolean myHideOnKeyOutside;
    private long myFadeoutTime;
    private boolean myShowCallout;
    private boolean myCloseButtonEnabled;
    private boolean myHideOnFrameResize;
    private boolean myHideOnLinkClick;
    private ActionListener myClickHandler;
    private boolean myCloseOnClick;
    private int myAnimationCycle;
    private int myCalloutShift;
    private int myPositionChangeXShift;
    private int myPositionChangeYShift;
    private boolean myHideOnAction;
    private boolean myDialogMode;
    private String myTitle;
    private Insets myContentInsets;
    private boolean myShadow;
    private boolean mySmallVariant;
    private Balloon.Layer myLayer;
    private boolean myBlockClicks;

    public BalloonPopupBuilderImpl(@Nullable Map<Disposable, List<Balloon>> storage, @NotNull JComponent content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ui/popup/BalloonPopupBuilderImpl", "<init>"));
        }
        this.myBorder = new JBColor((Color)JBColor.GRAY, (Color)Gray._200);
        this.myBorderInsets = null;
        this.myFill = MessageType.INFO.getPopupBackground();
        this.myHideOnMouseOutside = true;
        this.myHideOnKeyOutside = true;
        this.myFadeoutTime = -1L;
        this.myShowCallout = true;
        this.myCloseButtonEnabled = false;
        this.myHideOnFrameResize = true;
        this.myHideOnLinkClick = false;
        this.myAnimationCycle = 500;
        this.myHideOnAction = true;
        this.myContentInsets = new Insets(2, 2, 2, 2);
        this.myShadow = false;
        this.mySmallVariant = false;
        this.myBlockClicks = false;
        this.myStorage = storage;
        this.myContent = content;
    }

    public boolean isHideOnAction() {
        return this.myHideOnAction;
    }

    @NotNull
    public BalloonBuilder setHideOnAction(boolean hideOnAction) {
        this.myHideOnAction = hideOnAction;
        BalloonPopupBuilderImpl balloonPopupBuilderImpl = this;
        if (balloonPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/BalloonPopupBuilderImpl", "setHideOnAction"));
        }
        return balloonPopupBuilderImpl;
    }

    @NotNull
    public BalloonBuilder setDialogMode(boolean dialogMode) {
        this.myDialogMode = dialogMode;
        BalloonPopupBuilderImpl balloonPopupBuilderImpl = this;
        if (balloonPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/BalloonPopupBuilderImpl", "setDialogMode"));
        }
        return balloonPopupBuilderImpl;
    }

    @NotNull
    public BalloonBuilder setPreferredPosition(Balloon.Position position) {
        BalloonPopupBuilderImpl balloonPopupBuilderImpl = this;
        if (balloonPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/BalloonPopupBuilderImpl", "setPreferredPosition"));
        }
        return balloonPopupBuilderImpl;
    }

    @NotNull
    public BalloonBuilder setBorderColor(@NotNull Color color) {
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/popup/BalloonPopupBuilderImpl", "setBorderColor"));
        }
        this.myBorder = color;
        BalloonPopupBuilderImpl balloonPopupBuilderImpl = this;
        if (balloonPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/BalloonPopupBuilderImpl", "setBorderColor"));
        }
        return balloonPopupBuilderImpl;
    }

    public BalloonBuilder setBorderInsets(@Nullable Insets insets) {
        this.myBorderInsets = insets;
        return this;
    }

    @NotNull
    public BalloonBuilder setFillColor(@NotNull Color color) {
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/popup/BalloonPopupBuilderImpl", "setFillColor"));
        }
        this.myFill = color;
        BalloonPopupBuilderImpl balloonPopupBuilderImpl = this;
        if (balloonPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/BalloonPopupBuilderImpl", "setFillColor"));
        }
        return balloonPopupBuilderImpl;
    }

    @NotNull
    public BalloonBuilder setHideOnClickOutside(boolean hide) {
        this.myHideOnMouseOutside = hide;
        BalloonPopupBuilderImpl balloonPopupBuilderImpl = this;
        if (balloonPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/BalloonPopupBuilderImpl", "setHideOnClickOutside"));
        }
        return balloonPopupBuilderImpl;
    }

    @NotNull
    public BalloonBuilder setHideOnKeyOutside(boolean hide) {
        this.myHideOnKeyOutside = hide;
        BalloonPopupBuilderImpl balloonPopupBuilderImpl = this;
        if (balloonPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/BalloonPopupBuilderImpl", "setHideOnKeyOutside"));
        }
        return balloonPopupBuilderImpl;
    }

    @NotNull
    public BalloonBuilder setShowCallout(boolean show) {
        this.myShowCallout = show;
        BalloonPopupBuilderImpl balloonPopupBuilderImpl = this;
        if (balloonPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/BalloonPopupBuilderImpl", "setShowCallout"));
        }
        return balloonPopupBuilderImpl;
    }

    @NotNull
    public BalloonBuilder setFadeoutTime(long fadeoutTime) {
        this.myFadeoutTime = fadeoutTime;
        BalloonPopupBuilderImpl balloonPopupBuilderImpl = this;
        if (balloonPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/BalloonPopupBuilderImpl", "setFadeoutTime"));
        }
        return balloonPopupBuilderImpl;
    }

    @NotNull
    public BalloonBuilder setBlockClicksThroughBalloon(boolean block) {
        this.myBlockClicks = block;
        BalloonPopupBuilderImpl balloonPopupBuilderImpl = this;
        if (balloonPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/BalloonPopupBuilderImpl", "setBlockClicksThroughBalloon"));
        }
        return balloonPopupBuilderImpl;
    }

    @NotNull
    public BalloonBuilder setAnimationCycle(int time) {
        this.myAnimationCycle = time;
        BalloonPopupBuilderImpl balloonPopupBuilderImpl = this;
        if (balloonPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/BalloonPopupBuilderImpl", "setAnimationCycle"));
        }
        return balloonPopupBuilderImpl;
    }

    @NotNull
    public BalloonBuilder setHideOnFrameResize(boolean hide) {
        this.myHideOnFrameResize = hide;
        BalloonPopupBuilderImpl balloonPopupBuilderImpl = this;
        if (balloonPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/BalloonPopupBuilderImpl", "setHideOnFrameResize"));
        }
        return balloonPopupBuilderImpl;
    }

    @NotNull
    public BalloonBuilder setHideOnLinkClick(boolean hide) {
        this.myHideOnLinkClick = hide;
        BalloonPopupBuilderImpl balloonPopupBuilderImpl = this;
        if (balloonPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/BalloonPopupBuilderImpl", "setHideOnLinkClick"));
        }
        return balloonPopupBuilderImpl;
    }

    @NotNull
    public BalloonBuilder setPositionChangeXShift(int positionChangeXShift) {
        this.myPositionChangeXShift = positionChangeXShift;
        BalloonPopupBuilderImpl balloonPopupBuilderImpl = this;
        if (balloonPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/BalloonPopupBuilderImpl", "setPositionChangeXShift"));
        }
        return balloonPopupBuilderImpl;
    }

    @NotNull
    public BalloonBuilder setPositionChangeYShift(int positionChangeYShift) {
        this.myPositionChangeYShift = positionChangeYShift;
        BalloonPopupBuilderImpl balloonPopupBuilderImpl = this;
        if (balloonPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/BalloonPopupBuilderImpl", "setPositionChangeYShift"));
        }
        return balloonPopupBuilderImpl;
    }

    @NotNull
    public BalloonBuilder setCloseButtonEnabled(boolean enabled) {
        this.myCloseButtonEnabled = enabled;
        BalloonPopupBuilderImpl balloonPopupBuilderImpl = this;
        if (balloonPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/BalloonPopupBuilderImpl", "setCloseButtonEnabled"));
        }
        return balloonPopupBuilderImpl;
    }

    @NotNull
    public BalloonBuilder setClickHandler(ActionListener listener, boolean closeOnClick) {
        this.myClickHandler = listener;
        this.myCloseOnClick = closeOnClick;
        BalloonPopupBuilderImpl balloonPopupBuilderImpl = this;
        if (balloonPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/BalloonPopupBuilderImpl", "setClickHandler"));
        }
        return balloonPopupBuilderImpl;
    }

    @NotNull
    public BalloonBuilder setCalloutShift(int length) {
        this.myCalloutShift = length;
        BalloonPopupBuilderImpl balloonPopupBuilderImpl = this;
        if (balloonPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/BalloonPopupBuilderImpl", "setCalloutShift"));
        }
        return balloonPopupBuilderImpl;
    }

    @NotNull
    public BalloonBuilder setTitle(@Nullable String title) {
        this.myTitle = title;
        BalloonPopupBuilderImpl balloonPopupBuilderImpl = this;
        if (balloonPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/BalloonPopupBuilderImpl", "setTitle"));
        }
        return balloonPopupBuilderImpl;
    }

    @NotNull
    public BalloonBuilder setContentInsets(Insets insets) {
        this.myContentInsets = insets;
        BalloonPopupBuilderImpl balloonPopupBuilderImpl = this;
        if (balloonPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/BalloonPopupBuilderImpl", "setContentInsets"));
        }
        return balloonPopupBuilderImpl;
    }

    @NotNull
    public BalloonBuilder setShadow(boolean shadow) {
        this.myShadow = shadow;
        BalloonPopupBuilderImpl balloonPopupBuilderImpl = this;
        if (balloonPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/BalloonPopupBuilderImpl", "setShadow"));
        }
        return balloonPopupBuilderImpl;
    }

    @NotNull
    public BalloonBuilder setSmallVariant(boolean smallVariant) {
        this.mySmallVariant = smallVariant;
        BalloonPopupBuilderImpl balloonPopupBuilderImpl = this;
        if (balloonPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/BalloonPopupBuilderImpl", "setSmallVariant"));
        }
        return balloonPopupBuilderImpl;
    }

    @NotNull
    public BalloonBuilder setLayer(Balloon.Layer layer) {
        this.myLayer = layer;
        BalloonPopupBuilderImpl balloonPopupBuilderImpl = this;
        if (balloonPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/BalloonPopupBuilderImpl", "setLayer"));
        }
        return balloonPopupBuilderImpl;
    }

    @NotNull
    public BalloonBuilder setDisposable(@NotNull Disposable anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/popup/BalloonPopupBuilderImpl", "setDisposable"));
        }
        this.myAnchor = anchor;
        BalloonPopupBuilderImpl balloonPopupBuilderImpl = this;
        if (balloonPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/BalloonPopupBuilderImpl", "setDisposable"));
        }
        return balloonPopupBuilderImpl;
    }

    @NotNull
    public Balloon createBalloon() {
        final BalloonImpl result = new BalloonImpl(this.myContent, this.myBorder, this.myBorderInsets, this.myFill, this.myHideOnMouseOutside, this.myHideOnKeyOutside, this.myHideOnAction, this.myShowCallout, this.myCloseButtonEnabled, this.myFadeoutTime, this.myHideOnFrameResize, this.myHideOnLinkClick, this.myClickHandler, this.myCloseOnClick, this.myAnimationCycle, this.myCalloutShift, this.myPositionChangeXShift, this.myPositionChangeYShift, this.myDialogMode, this.myTitle, this.myContentInsets, this.myShadow, this.mySmallVariant, this.myBlockClicks, this.myLayer);
        if (this.myStorage != null && this.myAnchor != null) {
            List<Balloon> balloons = this.myStorage.get(this.myAnchor);
            if (balloons == null) {
                balloons = new ArrayList<Balloon>();
                this.myStorage.put(this.myAnchor, balloons);
                Disposer.register((Disposable)this.myAnchor, (Disposable)new Disposable(){

                    public void dispose() {
                        List toDispose = (List)BalloonPopupBuilderImpl.this.myStorage.remove(BalloonPopupBuilderImpl.this.myAnchor);
                        if (toDispose != null) {
                            for (Balloon balloon : toDispose) {
                                if (balloon.isDisposed()) continue;
                                Disposer.dispose((Disposable)balloon);
                            }
                        }
                    }
                });
            }
            balloons.add(result);
            result.addListener((JBPopupListener)new JBPopupAdapter(){

                public void onClosed(LightweightWindowEvent event) {
                    if (!result.isDisposed()) {
                        Disposer.dispose((Disposable)result);
                    }
                }
            });
        }
        BalloonImpl balloonImpl = result;
        if (balloonImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/BalloonPopupBuilderImpl", "createBalloon"));
        }
        return balloonImpl;
    }
}

