/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.sun.jna.Callback;
import com.sun.jna.Pointer;
import java.util.concurrent.atomic.AtomicBoolean;

public class MacNativeMethodInterceptor {
    public static AtomicBoolean FIX_ENABLED = new AtomicBoolean(false);
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.mac.FindHeavyweightUnderCursorFix");
    private static final Callback CB = new Callback(){

        public void callback(ID self, Pointer originalSelector, Pointer selToPerform, ID anObject, ID withObject, boolean waitUntilDone, ID awtMode) {
            String selectorName = Foundation.stringFromSelector((Pointer)selToPerform);
            if (FIX_ENABLED.get() && "findHeavyweightUnderCursor:".equals(selectorName)) {
                return;
            }
            Foundation.invoke((ID)self, (String)"oldPerformOnMainThread:onObject:withObject:waitUntilDone:awtMode:", (Object[])new Object[]{selToPerform, anObject, withObject, waitUntilDone, awtMode});
        }
    };

    private MacNativeMethodInterceptor() {
    }

    static {
        if (SystemInfo.isMac) {
            ID threadUtilities = Foundation.getMetaClass((String)"ThreadUtilities");
            ID originalMethod = Foundation.class_replaceMethod((ID)threadUtilities, (Pointer)Foundation.createSelector((String)"performOnMainThread:onObject:withObject:waitUntilDone:awtMode:"), (Callback)CB, (String)"v@::@@B*");
            if (!Foundation.addMethodByID((ID)threadUtilities, (Pointer)Foundation.createSelector((String)"oldPerformOnMainThread:onObject:withObject:waitUntilDone:awtMode:"), (ID)originalMethod, (String)"v@::@@B*")) {
                LOG.error("Unable to restore original behavior :(");
            }
        }
    }
}

