/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac;

import java.util.LinkedList;

class MacMessagesQueue<T extends Runnable> {
    private boolean waitingForAppKit = false;
    private LinkedList<Runnable> queueModel = new LinkedList();

    MacMessagesQueue() {
    }

    synchronized void runOrEnqueue(T runnable) {
        if (this.waitingForAppKit) {
            this.enqueue(runnable);
        } else {
            runnable.run();
            this.waitingForAppKit = true;
        }
    }

    private void enqueue(T runnable) {
        this.queueModel.add((Runnable)runnable);
    }

    synchronized void runFromQueue() {
        if (!this.queueModel.isEmpty()) {
            this.queueModel.remove().run();
            this.waitingForAppKit = true;
        } else {
            this.waitingForAppKit = false;
        }
    }
}

