/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.ModalityHelper;
import com.intellij.ui.mac.JDK7WindowReorderingWorkaround;
import com.intellij.ui.mac.MacMessageException;
import com.intellij.ui.mac.MacMessages;
import com.intellij.ui.mac.MacMessagesQueue;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.ui.mac.foundation.MacUtil;
import com.intellij.util.ui.UIUtil;
import com.sun.jna.Callback;
import com.sun.jna.Pointer;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.InputEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MacMessagesImpl
extends MacMessages {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.mac.MacMessages");
    private static final Map<Window, MessageResult> resultsFromDocumentRoot = new HashMap<Window, MessageResult>();
    private static final Map<Window, MacMessagesQueue<Runnable>> queuesFromDocumentRoot = new HashMap<Window, MacMessagesQueue<Runnable>>();
    private static final Callback SHEET_DID_END = new Callback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void callback(ID self, String selector, ID alert, ID returnCode, ID contextInfo) {
            Object object = lock;
            synchronized (object) {
                Window documentRoot = (Window)windowFromId.get(contextInfo.longValue());
                MacMessagesImpl.processResult(documentRoot);
                ID suppressState = Foundation.invoke((ID)Foundation.invoke((ID)alert, (String)"suppressionButton", (Object[])new Object[0]), (String)"state", (Object[])new Object[0]);
                resultsFromDocumentRoot.put(documentRoot, new MessageResult(returnCode.intValue(), suppressState.intValue() == 1));
                ((MacMessagesQueue)queuesFromDocumentRoot.get(windowFromId.get(contextInfo.longValue()))).runFromQueue();
            }
            JDK7WindowReorderingWorkaround.enableReordering();
            Foundation.cfRelease((ID[])new ID[]{self});
        }
    };
    private static final Callback VARIABLE_BUTTONS_SHEET_PANEL = new Callback(){

        public void callback(ID self, String selector, ID params) {
            ID button;
            ID title = Foundation.invoke((ID)params, (String)"objectAtIndex:", (Object[])new Object[]{0});
            ID message = Foundation.invoke((ID)params, (String)"objectAtIndex:", (Object[])new Object[]{1});
            ID focusedWindow = Foundation.invoke((ID)params, (String)"objectAtIndex:", (Object[])new Object[]{2});
            ID alertStyle = Foundation.invoke((ID)params, (String)"objectAtIndex:", (Object[])new Object[]{4});
            ID doNotAskText = Foundation.invoke((ID)params, (String)"objectAtIndex:", (Object[])new Object[]{5});
            int defaultOptionIndex = Integer.parseInt(Foundation.toStringViaUTF8((ID)Foundation.invoke((ID)params, (String)"objectAtIndex:", (Object[])new Object[]{6})));
            int focusedOptionIndex = Integer.parseInt(Foundation.toStringViaUTF8((ID)Foundation.invoke((ID)params, (String)"objectAtIndex:", (Object[])new Object[]{7})));
            ID buttons = Foundation.invoke((ID)params, (String)"objectAtIndex:", (Object[])new Object[]{8});
            ID doNotAskChecked = Foundation.invoke((ID)params, (String)"objectAtIndex:", (Object[])new Object[]{9});
            ID alert = Foundation.invoke((ID)Foundation.invoke((String)"NSAlert", (String)"alloc", (Object[])new Object[0]), (String)"init", (Object[])new Object[0]);
            Foundation.invoke((ID)alert, (String)"setMessageText:", (Object[])new Object[]{title});
            Foundation.invoke((ID)alert, (String)"setInformativeText:", (Object[])new Object[]{message});
            if ("error".equals(Foundation.toStringViaUTF8((ID)alertStyle))) {
                Foundation.invoke((ID)alert, (String)"setAlertStyle:", (Object[])new Object[]{2});
            }
            ID buttonEnumerator = Foundation.invoke((ID)buttons, (String)"objectEnumerator", (Object[])new Object[0]);
            while (0 != (button = Foundation.invoke((ID)buttonEnumerator, (String)"nextObject", (Object[])new Object[0])).intValue()) {
                Foundation.invoke((ID)alert, (String)"addButtonWithTitle:", (Object[])new Object[]{button});
            }
            if (defaultOptionIndex != -1) {
                Foundation.invoke((ID)Foundation.invoke((ID)alert, (String)"window", (Object[])new Object[0]), (String)"setDefaultButtonCell:", (Object[])new Object[]{Foundation.invoke((ID)Foundation.invoke((ID)Foundation.invoke((ID)alert, (String)"buttons", (Object[])new Object[0]), (String)"objectAtIndex:", (Object[])new Object[]{defaultOptionIndex}), (String)"cell", (Object[])new Object[0])});
            }
            MacMessagesImpl.enableEscapeToCloseTheMessage(alert);
            String doNotAsk = Foundation.toStringViaUTF8((ID)doNotAskText);
            if (!"-1".equals(doNotAsk)) {
                Foundation.invoke((ID)alert, (String)"setShowsSuppressionButton:", (Object[])new Object[]{1});
                Foundation.invoke((ID)Foundation.invoke((ID)alert, (String)"suppressionButton", (Object[])new Object[0]), (String)"setTitle:", (Object[])new Object[]{doNotAskText});
                Foundation.invoke((ID)Foundation.invoke((ID)alert, (String)"suppressionButton", (Object[])new Object[0]), (String)"setState:", (Object[])new Object[]{"checked".equals(Foundation.toStringViaUTF8((ID)doNotAskChecked))});
            }
            Foundation.invoke((ID)alert, (String)"beginSheetModalForWindow:modalDelegate:didEndSelector:contextInfo:", (Object[])new Object[]{focusedWindow, self, Foundation.createSelector((String)"alertDidEnd:returnCode:contextInfo:"), focusedWindow});
            Foundation.cfRelease((ID[])new ID[]{alert});
        }
    };
    private static final Callback SIMPLE_SHEET_PANEL = new Callback(){

        public void callback(ID self, String selector, ID params) {
            String doNotAsk;
            ID title = Foundation.invoke((ID)params, (String)"objectAtIndex:", (Object[])new Object[]{0});
            ID defaultText = Foundation.invoke((ID)params, (String)"objectAtIndex:", (Object[])new Object[]{1});
            ID otherText = Foundation.invoke((ID)params, (String)"objectAtIndex:", (Object[])new Object[]{2});
            ID alternateText = Foundation.invoke((ID)params, (String)"objectAtIndex:", (Object[])new Object[]{3});
            ID message = Foundation.invoke((ID)params, (String)"objectAtIndex:", (Object[])new Object[]{4});
            ID focusedWindow = Foundation.invoke((ID)params, (String)"objectAtIndex:", (Object[])new Object[]{5});
            ID alertStyle = Foundation.invoke((ID)params, (String)"objectAtIndex:", (Object[])new Object[]{7});
            ID doNotAskText = Foundation.invoke((ID)params, (String)"objectAtIndex:", (Object[])new Object[]{8});
            ID doNotAskChecked = Foundation.invoke((ID)params, (String)"objectAtIndex:", (Object[])new Object[]{9});
            boolean alternateExist = !"-1".equals(Foundation.toStringViaUTF8((ID)alternateText));
            boolean otherExist = !"-1".equals(Foundation.toStringViaUTF8((ID)otherText));
            ID alert = Foundation.invoke((String)"NSAlert", (String)"alertWithMessageText:defaultButton:alternateButton:otherButton:informativeTextWithFormat:", (Object[])new Object[]{title, defaultText, alternateExist ? alternateText : null, otherExist ? otherText : null, message});
            if ("error".equals(Foundation.toStringViaUTF8((ID)alertStyle))) {
                Foundation.invoke((ID)alert, (String)"setAlertStyle:", (Object[])new Object[]{2});
            }
            if (!alternateExist) {
                MacMessagesImpl.enableEscapeToCloseTheMessage(alert);
            }
            if (!"-1".equals(doNotAsk = Foundation.toStringViaUTF8((ID)doNotAskText))) {
                Foundation.invoke((ID)alert, (String)"setShowsSuppressionButton:", (Object[])new Object[]{1});
                Foundation.invoke((ID)Foundation.invoke((ID)alert, (String)"suppressionButton", (Object[])new Object[0]), (String)"setTitle:", (Object[])new Object[]{doNotAskText});
                Foundation.invoke((ID)Foundation.invoke((ID)alert, (String)"suppressionButton", (Object[])new Object[0]), (String)"setState:", (Object[])new Object[]{"checked".equals(Foundation.toStringViaUTF8((ID)doNotAskChecked))});
            }
            Foundation.invoke((ID)alert, (String)"beginSheetModalForWindow:modalDelegate:didEndSelector:contextInfo:", (Object[])new Object[]{focusedWindow, self, Foundation.createSelector((String)"alertDidEnd:returnCode:contextInfo:"), focusedWindow});
        }
    };
    private static final Callback windowDidBecomeMainCallback = new Callback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void callback(ID self, ID nsNotification) {
            Object object = lock;
            synchronized (object) {
                if (!windowFromId.keySet().contains(self.longValue())) {
                    return;
                }
            }
            Foundation.invoke((ID)self, (String)"oldWindowDidBecomeMain:", (Object[])new Object[]{nsNotification});
        }
    };
    private static final Object lock;
    private static final HashMap<Window, Integer> blockedDocumentRoots;
    private static final HashMap<Long, Window> windowFromId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processResult(Window w) {
        Object object = lock;
        synchronized (object) {
            if (!blockedDocumentRoots.keySet().contains(w)) {
                throw new RuntimeException("Window should be in th list.");
            }
            int openedSheetsForWindow = blockedDocumentRoots.get(w);
            if (openedSheetsForWindow < 1) {
                throw new RuntimeException("We should have at least one window in the list");
            }
            if (openedSheetsForWindow == 1) {
                blockedDocumentRoots.remove(w);
            } else {
                blockedDocumentRoots.put(w, openedSheetsForWindow - 1);
            }
        }
    }

    private static void enableEscapeToCloseTheMessage(ID alert) {
        int buttonsNumber = Foundation.invoke((ID)Foundation.invoke((ID)alert, (String)"buttons", (Object[])new Object[0]), (String)"count", (Object[])new Object[0]).intValue();
        if (buttonsNumber < 2) {
            return;
        }
        Foundation.invoke((ID)Foundation.invoke((ID)Foundation.invoke((ID)alert, (String)"buttons", (Object[])new Object[0]), (String)"objectAtIndex:", (Object[])new Object[]{buttonsNumber - 1}), (String)"setKeyEquivalent:", (Object[])new Object[]{Foundation.nsString((String)"\u001b")});
    }

    private MacMessagesImpl() {
    }

    public void showOkMessageDialog(@NotNull String title, String message, @NotNull String okText, @Nullable Window window) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/mac/MacMessagesImpl", "showOkMessageDialog"));
        }
        if (okText == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/ui/mac/MacMessagesImpl", "showOkMessageDialog"));
        }
        MacMessagesImpl.showAlertDialog(title, okText, null, null, message, window);
    }

    public void showOkMessageDialog(@NotNull String title, String message, @NotNull String okText) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/mac/MacMessagesImpl", "showOkMessageDialog"));
        }
        if (okText == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/ui/mac/MacMessagesImpl", "showOkMessageDialog"));
        }
        MacMessagesImpl.showAlertDialog(title, okText, null, null, message, null);
    }

    @Messages.YesNoResult
    public int showYesNoDialog(@NotNull String title, String message, @NotNull String yesButton, @NotNull String noButton, @Nullable Window window) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/mac/MacMessagesImpl", "showYesNoDialog"));
        }
        if (yesButton == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/ui/mac/MacMessagesImpl", "showYesNoDialog"));
        }
        if (noButton == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/ui/mac/MacMessagesImpl", "showYesNoDialog"));
        }
        return MacMessagesImpl.showAlertDialog(title, yesButton, null, noButton, message, window) == 0 ? 0 : 1;
    }

    @Messages.YesNoResult
    public int showYesNoDialog(@NotNull String title, String message, @NotNull String yesButton, @NotNull String noButton, @Nullable Window window, @Nullable DialogWrapper.DoNotAskOption doNotAskDialogOption) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/mac/MacMessagesImpl", "showYesNoDialog"));
        }
        if (yesButton == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/ui/mac/MacMessagesImpl", "showYesNoDialog"));
        }
        if (noButton == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/ui/mac/MacMessagesImpl", "showYesNoDialog"));
        }
        return MacMessagesImpl.showAlertDialog(title, yesButton, null, noButton, message, window, false, doNotAskDialogOption) == 0 ? 0 : 1;
    }

    public void showErrorDialog(@NotNull String title, String message, @NotNull String okButton, @Nullable Window window) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/mac/MacMessagesImpl", "showErrorDialog"));
        }
        if (okButton == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/ui/mac/MacMessagesImpl", "showErrorDialog"));
        }
        MacMessagesImpl.showAlertDialog(title, okButton, null, null, message, window, true, null);
    }

    @Messages.YesNoCancelResult
    public int showYesNoCancelDialog(@NotNull String title, String message, @NotNull String defaultButton, String alternateButton, String otherButton, Window window, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/mac/MacMessagesImpl", "showYesNoCancelDialog"));
        }
        if (defaultButton == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/ui/mac/MacMessagesImpl", "showYesNoCancelDialog"));
        }
        return MacMessagesImpl.showAlertDialog(title, defaultButton, alternateButton, otherButton, message, window, false, doNotAskOption);
    }

    public static void pumpEventsDocumentExclusively(Window documentRoot) {
        Integer messageNumber = blockedDocumentRoots.get(documentRoot);
        EventQueue theQueue = documentRoot.getToolkit().getSystemEventQueue();
        do {
            try {
                Component c;
                Window w;
                Object s;
                AWTEvent event = theQueue.getNextEvent();
                boolean eventOk = true;
                if (event instanceof InputEvent && (s = event.getSource()) instanceof Component && (w = MacMessagesImpl.findDocumentRoot(c = (Component)s)) == documentRoot) {
                    eventOk = false;
                    ((InputEvent)event).consume();
                }
                if (!eventOk) continue;
                Class[] paramString = new Class[]{AWTEvent.class};
                Method method = theQueue.getClass().getDeclaredMethod("dispatchEvent", paramString);
                method.setAccessible(true);
                method.invoke((Object)theQueue, event);
            }
            catch (MacMessageException mme) {
                throw mme;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        } while (MacMessagesImpl.isBlockedDocumentRoot(documentRoot, messageNumber));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isBlockedDocumentRoot(Window documentRoot, Integer messageNumber) {
        Object object = lock;
        synchronized (object) {
            return messageNumber.equals(blockedDocumentRoots.get(documentRoot));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Window findDocumentRoot(Component c) {
        if (c == null) {
            return null;
        }
        Window w = c instanceof Window ? (Window)c : MacMessagesImpl.getContainingWindow(c);
        Object object = c.getTreeLock();
        synchronized (object) {
            while (w.getOwner() != null) {
                w = w.getOwner();
            }
        }
        return w;
    }

    private static Window getContainingWindow(Component comp) {
        while (comp != null && !(comp instanceof Window)) {
            comp = comp.getParent();
        }
        return (Window)comp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startModal(Window w, ID windowId) {
        long windowPtr = windowId.longValue();
        Object object = lock;
        synchronized (object) {
            JDK7WindowReorderingWorkaround.disableReordering();
            windowFromId.put(windowPtr, w);
            if (blockedDocumentRoots.keySet().contains(w)) {
                blockedDocumentRoots.put(w, blockedDocumentRoots.get(w) + 1);
            } else {
                blockedDocumentRoots.put(w, 1);
            }
        }
        MacMessagesImpl.pumpEventsDocumentExclusively(w);
        object = lock;
        synchronized (object) {
            windowFromId.remove(windowPtr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Messages.YesNoCancelResult
    public static int showAlertDialog(@NotNull String title, @NotNull String defaultText, @Nullable String alternateText, @Nullable String otherText, String message, @Nullable Window window, boolean errorStyle, @Nullable DialogWrapper.DoNotAskOption doNotAskDialogOption) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/mac/MacMessagesImpl", "showAlertDialog"));
        }
        if (defaultText == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ui/mac/MacMessagesImpl", "showAlertDialog"));
        }
        HashMap<Enum, ID> params = new HashMap<Enum, ID>();
        ID pool = Foundation.invoke((ID)Foundation.invoke((String)"NSAutoreleasePool", (String)"alloc", (Object[])new Object[0]), (String)"init", (Object[])new Object[0]);
        try {
            params.put(COMMON_DIALOG_PARAM_TYPE.title, Foundation.nsString((String)title));
            params.put(ALERT_DIALOG_PARAM_TYPE.defaultText, Foundation.nsString((String)UIUtil.removeMnemonic((String)defaultText)));
            params.put(ALERT_DIALOG_PARAM_TYPE.alternateText, Foundation.nsString((String)(otherText == null ? "-1" : UIUtil.removeMnemonic((String)otherText))));
            params.put(ALERT_DIALOG_PARAM_TYPE.otherText, Foundation.nsString((String)(alternateText == null ? "-1" : UIUtil.removeMnemonic((String)alternateText))));
            params.put(COMMON_DIALOG_PARAM_TYPE.message, Foundation.nsString((String)StringUtil.stripHtml((String)(message == null ? "" : message), (boolean)true).replace("%", "%%")));
            params.put(COMMON_DIALOG_PARAM_TYPE.errorStyle, Foundation.nsString((String)(errorStyle ? "error" : "-1")));
            params.put(COMMON_DIALOG_PARAM_TYPE.doNotAskDialogOption1, Foundation.nsString((String)(doNotAskDialogOption == null || !doNotAskDialogOption.canBeHidden() ? "-1" : doNotAskDialogOption.getDoNotShowMessage())));
            params.put(COMMON_DIALOG_PARAM_TYPE.doNotAskDialogOption2, Foundation.nsString((String)(doNotAskDialogOption != null && !doNotAskDialogOption.isToBeShown() ? "checked" : "-1")));
            MessageResult result = resultsFromDocumentRoot.remove(MacMessagesImpl.showDialog(window, "showSheet:", new DialogParamsWrapper(DialogParamsWrapper.DialogType.alert, params)));
            int convertedResult = MacMessagesImpl.convertReturnCodeFromNativeAlertDialog(result.myReturnCode, alternateText);
            if (doNotAskDialogOption != null && doNotAskDialogOption.canBeHidden()) {
                boolean operationCanceled;
                boolean bl = operationCanceled = convertedResult == 2;
                if (!operationCanceled || doNotAskDialogOption.shouldSaveOptionsOnCancel()) {
                    doNotAskDialogOption.setToBeShown(!result.mySuppress, convertedResult);
                }
            }
            int n = convertedResult;
            return n;
        }
        finally {
            Foundation.invoke((ID)pool, (String)"release", (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int showMessageDialog(@NotNull String title, String message, @NotNull String[] buttons, boolean errorStyle, @Nullable Window window, int defaultOptionIndex, int focusedOptionIndex, @Nullable DialogWrapper.DoNotAskOption doNotAskDialogOption) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/mac/MacMessagesImpl", "showMessageDialog"));
        }
        if (buttons == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/ui/mac/MacMessagesImpl", "showMessageDialog"));
        }
        ID pool = Foundation.invoke((ID)Foundation.invoke((String)"NSAutoreleasePool", (String)"alloc", (Object[])new Object[0]), (String)"init", (Object[])new Object[0]);
        try {
            ID buttonsArray = Foundation.invoke((String)"NSMutableArray", (String)"array", (Object[])new Object[0]);
            for (String s : buttons) {
                ID s1 = Foundation.nsString((String)UIUtil.removeMnemonic((String)s));
                Foundation.invoke((ID)buttonsArray, (String)"addObject:", (Object[])new Object[]{s1});
            }
            HashMap<Enum, ID> params = new HashMap<Enum, ID>();
            params.put(COMMON_DIALOG_PARAM_TYPE.title, Foundation.nsString((String)title));
            params.put(COMMON_DIALOG_PARAM_TYPE.message, Foundation.nsString((String)StringUtil.stripHtml((String)(message == null ? "" : message), (boolean)true).replace("%", "%%")));
            params.put(COMMON_DIALOG_PARAM_TYPE.errorStyle, Foundation.nsString((String)(errorStyle ? "error" : "-1")));
            params.put(COMMON_DIALOG_PARAM_TYPE.doNotAskDialogOption1, Foundation.nsString((String)(doNotAskDialogOption == null || !doNotAskDialogOption.canBeHidden() ? "-1" : doNotAskDialogOption.getDoNotShowMessage())));
            params.put(COMMON_DIALOG_PARAM_TYPE.doNotAskDialogOption2, Foundation.nsString((String)(doNotAskDialogOption != null && !doNotAskDialogOption.isToBeShown() ? "checked" : "-1")));
            params.put(MESSAGE_DIALOG_PARAM_TYPE.defaultOptionIndex, Foundation.nsString((String)Integer.toString(defaultOptionIndex)));
            params.put(MESSAGE_DIALOG_PARAM_TYPE.focusedOptionIndex, Foundation.nsString((String)Integer.toString(focusedOptionIndex)));
            params.put(MESSAGE_DIALOG_PARAM_TYPE.buttonsArray, buttonsArray);
            MessageResult result = resultsFromDocumentRoot.remove(MacMessagesImpl.showDialog(window, "showVariableButtonsSheet:", new DialogParamsWrapper(DialogParamsWrapper.DialogType.message, params)));
            int code = MacMessagesImpl.convertReturnCodeFromNativeMessageDialog(result.myReturnCode);
            int cancelCode = buttons.length - 1;
            if (doNotAskDialogOption != null && doNotAskDialogOption.canBeHidden() && (cancelCode != code || doNotAskDialogOption.shouldSaveOptionsOnCancel())) {
                doNotAskDialogOption.setToBeShown(!result.mySuppress, code);
            }
            int n = code;
            return n;
        }
        finally {
            Foundation.invoke((ID)pool, (String)"release", (Object[])new Object[0]);
        }
    }

    private static Window showDialog(@Nullable Window window, final String methodName, DialogParamsWrapper paramsWrapper) {
        Window foremostWindow = MacMessagesImpl.getForemostWindow(window);
        final Window documentRoot = MacMessagesImpl.getDocumentRootFromWindow(foremostWindow);
        ID nativeFocusedWindow = MacUtil.findWindowFromJavaWindow((Window)foremostWindow);
        paramsWrapper.setNativeWindow(nativeFocusedWindow);
        final ID paramsArray = paramsWrapper.getParamsAsID();
        foremostWindow.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                super.windowClosed(e);
                queuesFromDocumentRoot.remove(documentRoot);
                if (blockedDocumentRoots.remove(documentRoot) != null) {
                    throw new MacMessageException("Owner window has been removed");
                }
            }
        });
        final ID delegate = Foundation.invoke((ID)Foundation.invoke((ID)Foundation.getObjcClass((String)"NSAlertDelegate_"), (String)"alloc", (Object[])new Object[0]), (String)"init", (Object[])new Object[0]);
        IdeFocusManager.getGlobalInstance().setTypeaheadEnabled(false);
        MacMessagesImpl.runOrPostponeForWindow(documentRoot, new Runnable(){

            @Override
            public void run() {
                Foundation.invoke((ID)delegate, (String)"performSelectorOnMainThread:withObject:waitUntilDone:", (Object[])new Object[]{Foundation.createSelector((String)methodName), paramsArray, false});
            }
        });
        MacMessagesImpl.startModal(documentRoot, nativeFocusedWindow);
        IdeFocusManager.getGlobalInstance().setTypeaheadEnabled(true);
        return documentRoot;
    }

    private static int convertReturnCodeFromNativeMessageDialog(int result) {
        return result - 1000;
    }

    @Messages.YesNoCancelResult
    private static int convertReturnCodeFromNativeAlertDialog(int returnCode, String alternateText) {
        int code;
        int cancelCode;
        if (alternateText != null) {
            cancelCode = 2;
            switch (returnCode) {
                case 1: {
                    code = 0;
                    break;
                }
                case 0: {
                    code = 1;
                    break;
                }
                default: {
                    code = 2;
                    break;
                }
            }
        } else {
            cancelCode = 1;
            switch (returnCode) {
                case 1: {
                    code = 0;
                    break;
                }
                default: {
                    code = 1;
                }
            }
        }
        if (cancelCode == code) {
            code = 2;
        }
        LOG.assertTrue(code == 0 || code == 1 || code == 2, (Object)code);
        return code;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runOrPostponeForWindow(Window documentRoot, Runnable task) {
        Object object = lock;
        synchronized (object) {
            MacMessagesQueue<Runnable> queue = queuesFromDocumentRoot.get(documentRoot);
            if (queue == null) {
                queue = new MacMessagesQueue();
                queuesFromDocumentRoot.put(documentRoot, queue);
            }
            queue.runOrEnqueue(task);
        }
    }

    private static Window getForemostWindow(Window window) {
        Window _window = null;
        IdeFocusManager ideFocusManager = IdeFocusManager.getGlobalInstance();
        Component focusOwner = IdeFocusManager.findInstance().getFocusOwner();
        if (focusOwner != null) {
            _window = SwingUtilities.getWindowAncestor(focusOwner);
        }
        if (_window == null && (focusOwner = ideFocusManager.getLastFocusedFor(ideFocusManager.getLastFocusedFrame())) != null) {
            _window = SwingUtilities.getWindowAncestor(focusOwner);
        }
        if (_window == null) {
            _window = WindowManager.getInstance().findVisibleFrame();
        }
        if (_window == null && window != null && (focusOwner = window.getMostRecentFocusOwner()) != null) {
            _window = SwingUtilities.getWindowAncestor(focusOwner);
        }
        if (_window != null && ModalityHelper.isModalBlocked(_window)) {
            _window = ModalityHelper.getModalBlockerFor(_window);
        }
        if (SystemInfo.isAppleJvm && MacUtil.getWindowTitle((Window)_window) == null) {
            throw new MacMessageException("MacMessage parent does not have a title.");
        }
        while (_window != null && MacUtil.getWindowTitle((Window)_window) == null) {
            _window = _window.getOwner();
        }
        while (Registry.is((String)"skip.untitled.windows.for.mac.messages") && _window != null && _window instanceof JDialog && !((JDialog)_window).isModal()) {
            _window = _window.getOwner();
        }
        return _window;
    }

    private static Window getDocumentRootFromWindow(Window window) {
        return MacMessagesImpl.findDocumentRoot(window);
    }

    @Messages.YesNoCancelResult
    private static int showAlertDialog(@NotNull String title, @NotNull String okText, @Nullable String alternateText, @Nullable String cancelText, String message, @Nullable Window window) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/mac/MacMessagesImpl", "showAlertDialog"));
        }
        if (okText == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ui/mac/MacMessagesImpl", "showAlertDialog"));
        }
        return MacMessagesImpl.showAlertDialog(title, okText, alternateText, cancelText, message, window, false, null);
    }

    static {
        if (SystemInfo.isMac) {
            ID delegateClass = Foundation.allocateObjcClassPair((ID)Foundation.getObjcClass((String)"NSObject"), (String)"NSAlertDelegate_");
            if (!Foundation.addMethod((ID)delegateClass, (Pointer)Foundation.createSelector((String)"alertDidEnd:returnCode:contextInfo:"), (Callback)SHEET_DID_END, (String)"v*")) {
                throw new RuntimeException("Unable to add method to objective-c delegate class!");
            }
            if (!Foundation.addMethod((ID)delegateClass, (Pointer)Foundation.createSelector((String)"showSheet:"), (Callback)SIMPLE_SHEET_PANEL, (String)"v*")) {
                throw new RuntimeException("Unable to add method to objective-c delegate class!");
            }
            if (!Foundation.addMethod((ID)delegateClass, (Pointer)Foundation.createSelector((String)"showVariableButtonsSheet:"), (Callback)VARIABLE_BUTTONS_SHEET_PANEL, (String)"v*")) {
                throw new RuntimeException("Unable to add method to objective-c delegate class!");
            }
            Foundation.registerObjcClassPair((ID)delegateClass);
            if (SystemInfo.isJavaVersionAtLeast((String)"1.7")) {
                ID awtWindow = Foundation.getObjcClass((String)"AWTWindow");
                Pointer windowWillEnterFullScreenMethod = Foundation.createSelector((String)"windowDidBecomeMain:");
                ID originalWindowWillEnterFullScreen = Foundation.class_replaceMethod((ID)awtWindow, (Pointer)windowWillEnterFullScreenMethod, (Callback)windowDidBecomeMainCallback, (String)"v@::@");
                Foundation.addMethodByID((ID)awtWindow, (Pointer)Foundation.createSelector((String)"oldWindowDidBecomeMain:"), (ID)originalWindowWillEnterFullScreen, (String)"v@::@");
            }
        }
        lock = new Object();
        blockedDocumentRoots = new HashMap();
        windowFromId = new HashMap();
    }

    private static class DialogParamsWrapper {
        private ID window;
        private final Map<Enum, Object> params;
        private final DialogType dialogType;

        private DialogParamsWrapper(@NotNull DialogType t, @NotNull Map<Enum, Object> p) {
            if (t == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/mac/MacMessagesImpl$DialogParamsWrapper", "<init>"));
            }
            if (p == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ui/mac/MacMessagesImpl$DialogParamsWrapper", "<init>"));
            }
            this.window = null;
            this.dialogType = t;
            this.params = p;
        }

        private void setNativeWindow(ID w) {
            this.window = w;
        }

        private ID getParamsAsID() {
            if (this.window == null) {
                throw new MacMessageException("Window should be in the list.");
            }
            this.params.put(COMMON_DIALOG_PARAM_TYPE.nativeFocusedWindow, this.window);
            ID paramsAsID = null;
            switch (this.dialogType) {
                case alert: {
                    paramsAsID = DialogParamsWrapper.getParamsForAlertDialog(this.params);
                    break;
                }
                case message: {
                    paramsAsID = DialogParamsWrapper.getParamsForMessageDialog(this.params);
                }
            }
            return paramsAsID;
        }

        private static ID getParamsForAlertDialog(@NotNull Map<Enum, Object> params) {
            if (params == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/mac/MacMessagesImpl$DialogParamsWrapper", "getParamsForAlertDialog"));
            }
            return Foundation.invoke((String)"NSArray", (String)"arrayWithObjects:", (Object[])new Object[]{params.get((Object)COMMON_DIALOG_PARAM_TYPE.title), params.get((Object)ALERT_DIALOG_PARAM_TYPE.defaultText), params.get((Object)ALERT_DIALOG_PARAM_TYPE.alternateText), params.get((Object)ALERT_DIALOG_PARAM_TYPE.otherText), params.get((Object)COMMON_DIALOG_PARAM_TYPE.message), params.get((Object)COMMON_DIALOG_PARAM_TYPE.nativeFocusedWindow), Foundation.nsString((String)""), params.get((Object)COMMON_DIALOG_PARAM_TYPE.errorStyle), params.get((Object)COMMON_DIALOG_PARAM_TYPE.doNotAskDialogOption1), params.get((Object)COMMON_DIALOG_PARAM_TYPE.doNotAskDialogOption2), null});
        }

        private static ID getParamsForMessageDialog(@NotNull Map<Enum, Object> params) {
            if (params == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/mac/MacMessagesImpl$DialogParamsWrapper", "getParamsForMessageDialog"));
            }
            return Foundation.invoke((String)"NSArray", (String)"arrayWithObjects:", (Object[])new Object[]{params.get((Object)COMMON_DIALOG_PARAM_TYPE.title), params.get((Object)COMMON_DIALOG_PARAM_TYPE.message), params.get((Object)COMMON_DIALOG_PARAM_TYPE.nativeFocusedWindow), Foundation.nsString((String)""), params.get((Object)COMMON_DIALOG_PARAM_TYPE.errorStyle), params.get((Object)COMMON_DIALOG_PARAM_TYPE.doNotAskDialogOption1), params.get((Object)MESSAGE_DIALOG_PARAM_TYPE.defaultOptionIndex), params.get((Object)MESSAGE_DIALOG_PARAM_TYPE.focusedOptionIndex), params.get((Object)MESSAGE_DIALOG_PARAM_TYPE.buttonsArray), params.get((Object)COMMON_DIALOG_PARAM_TYPE.doNotAskDialogOption2), null});
        }

        private static enum DialogType {
            alert,
            message;

        }
    }

    private static enum ALERT_DIALOG_PARAM_TYPE {
        defaultText,
        alternateText,
        otherText;

    }

    private static enum MESSAGE_DIALOG_PARAM_TYPE {
        buttonsArray,
        defaultOptionIndex,
        focusedOptionIndex;

    }

    private static enum COMMON_DIALOG_PARAM_TYPE {
        title,
        message,
        errorStyle,
        doNotAskDialogOption1,
        doNotAskDialogOption2,
        nativeFocusedWindow;

    }

    private static class MessageResult {
        private final int myReturnCode;
        private final boolean mySuppress;

        MessageResult(int returnCode, boolean suppress) {
            this.myReturnCode = returnCode;
            this.mySuppress = suppress;
        }
    }
}

