/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.content.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.ActiveRunnable;
import com.intellij.openapi.util.BusyObject;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.FocusCommand;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.ContentUI;
import com.intellij.ui.content.impl.ContentImpl;
import com.intellij.ui.switcher.SwitchProvider;
import com.intellij.ui.switcher.SwitchTarget;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContentManagerImpl
implements ContentManager,
PropertyChangeListener,
Disposable.Parent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.content.impl.ContentManagerImpl");
    private ContentUI myUI;
    private final ArrayList<Content> myContents;
    private EventListenerList myListeners;
    private List<Content> mySelection;
    private final boolean myCanCloseContents;
    private MyContentComponent myContentComponent;
    private MyFocusProxy myFocusProxy;
    private JPanel myComponent;
    private final Set<Content> myContentWithChangedComponent;
    private boolean myDisposed;
    private final Project myProject;

    public ContentManagerImpl(@NotNull ContentUI contentUI, boolean canCloseContents, @NotNull Project project) {
        if (contentUI == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/content/impl/ContentManagerImpl", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/ui/content/impl/ContentManagerImpl", "<init>"));
        }
        this.mySelection = new ArrayList<Content>();
        this.myContentWithChangedComponent = new HashSet<Content>();
        this.myProject = project;
        this.myCanCloseContents = canCloseContents;
        this.myContents = new ArrayList();
        this.myListeners = new EventListenerList();
        this.myUI = contentUI;
        this.myUI.setManager((ContentManager)this);
        Disposer.register((Disposable)project, (Disposable)this);
        Disposer.register((Disposable)this, (Disposable)contentUI);
    }

    public boolean canCloseContents() {
        return this.myCanCloseContents;
    }

    @NotNull
    public JComponent getComponent() {
        if (this.myComponent == null) {
            this.myComponent = new NonOpaquePanel((LayoutManager)new BorderLayout());
            this.myFocusProxy = new MyFocusProxy();
            this.myContentComponent = new MyContentComponent();
            this.myContentComponent.setContent(this.myUI.getComponent());
            this.myContentComponent.setFocusCycleRoot(true);
            this.myComponent.add((Component)((Object)this.myFocusProxy), "North");
            this.myComponent.add((Component)((Object)this.myContentComponent), "Center");
        }
        JPanel jPanel = this.myComponent;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "getComponent"));
        }
        return jPanel;
    }

    @NotNull
    public ActionCallback getReady(@NotNull Object requestor) {
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/content/impl/ContentManagerImpl", "getReady"));
        }
        Content selected = this.getSelectedContent();
        if (selected == null) {
            ActionCallback.Done done = new ActionCallback.Done();
            if (done == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "getReady"));
            }
            return done;
        }
        BusyObject busyObject = selected.getBusyObject();
        Object object = busyObject != null ? busyObject.getReady(requestor) : new ActionCallback.Done();
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "getReady"));
        }
        return object;
    }

    public void addContent(@NotNull Content content, int order) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/content/impl/ContentManagerImpl", "addContent"));
        }
        this.addContent(content, null, order);
    }

    public void addContent(@NotNull Content content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/content/impl/ContentManagerImpl", "addContent"));
        }
        this.addContent(content, null, -1);
    }

    public void addContent(@NotNull Content content, Object constraints) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/content/impl/ContentManagerImpl", "addContent"));
        }
        this.addContent(content, constraints, -1);
    }

    private void addContent(@NotNull Content content, Object constraints, int index) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/content/impl/ContentManagerImpl", "addContent"));
        }
        if (this.myContents.contains(content)) {
            return;
        }
        ((ContentImpl)content).setManager(this);
        int insertIndex = index == -1 ? this.myContents.size() : index;
        this.myContents.add(insertIndex, content);
        content.addPropertyChangeListener((PropertyChangeListener)this);
        this.fireContentAdded(content, insertIndex, ContentManagerEvent.ContentOperation.add);
        if (this.myUI.isToSelectAddedContent() || this.mySelection.isEmpty() && !this.myUI.canBeEmptySelection()) {
            if (this.myUI.isSingleSelection()) {
                this.setSelectedContent(content);
            } else {
                this.addSelectedContent(content);
            }
        }
        Disposer.register((Disposable)this, (Disposable)content);
    }

    public boolean removeContent(@NotNull Content content, boolean dispose) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/content/impl/ContentManagerImpl", "removeContent"));
        }
        return this.removeContent(content, true, dispose);
    }

    @NotNull
    public ActionCallback removeContent(@NotNull Content content, boolean dispose, final boolean trackFocus, final boolean forcedFocus) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/content/impl/ContentManagerImpl", "removeContent"));
        }
        final ActionCallback result = new ActionCallback();
        this._removeContent(content, true, dispose).doWhenDone(new Runnable(){

            @Override
            public void run() {
                if (trackFocus) {
                    Content current = ContentManagerImpl.this.getSelectedContent();
                    if (current != null) {
                        ContentManagerImpl.this.setSelectedContent(current, true, true, !forcedFocus);
                    } else {
                        result.setDone();
                    }
                } else {
                    result.setDone();
                }
            }
        });
        ActionCallback actionCallback = result;
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "removeContent"));
        }
        return actionCallback;
    }

    private boolean removeContent(Content content, boolean trackSelection, boolean dispose) {
        return this._removeContent(content, trackSelection, dispose).isDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActionCallback _removeContent(Content content, boolean trackSelection, boolean dispose) {
        int indexToBeRemoved = this.getIndexOfContent(content);
        if (indexToBeRemoved == -1) {
            return new ActionCallback.Rejected();
        }
        try {
            int selectedIndex;
            Content selection = this.mySelection.isEmpty() ? null : this.mySelection.get(this.mySelection.size() - 1);
            int n = selectedIndex = selection != null ? this.myContents.indexOf(selection) : -1;
            if (!this.fireContentRemoveQuery(content, indexToBeRemoved, ContentManagerEvent.ContentOperation.undefined)) {
                ActionCallback.Rejected rejected = new ActionCallback.Rejected();
                return rejected;
            }
            if (!content.isValid()) {
                ActionCallback.Rejected rejected = new ActionCallback.Rejected();
                return rejected;
            }
            boolean wasSelected = this.isSelected(content);
            if (wasSelected) {
                this.removeFromSelection(content);
            }
            int indexToSelect = -1;
            if (wasSelected) {
                int i = indexToBeRemoved - 1;
                if (i >= 0) {
                    indexToSelect = i;
                } else if (this.getContentCount() > 1) {
                    indexToSelect = 0;
                }
            } else if (selectedIndex > indexToBeRemoved) {
                indexToSelect = selectedIndex - 1;
            }
            this.myContents.remove(content);
            content.removePropertyChangeListener((PropertyChangeListener)this);
            this.fireContentRemoved(content, indexToBeRemoved, ContentManagerEvent.ContentOperation.remove);
            ((ContentImpl)content).setManager(null);
            if (dispose) {
                Disposer.dispose((Disposable)content);
            }
            int newSize = this.myContents.size();
            ActionCallback result = new ActionCallback();
            if (newSize > 0 && trackSelection) {
                Content toSelect;
                if (indexToSelect > -1 && !this.isSelected(toSelect = this.myContents.get(indexToSelect))) {
                    if (this.myUI.isSingleSelection()) {
                        this.setSelectedContentCB(toSelect).notify(result);
                    } else {
                        this.addSelectedContent(toSelect);
                        result.setDone();
                    }
                }
            } else {
                this.mySelection.clear();
            }
            ActionCallback actionCallback = result;
            return actionCallback;
        }
        finally {
            if (ApplicationManager.getApplication().isDispatchThread()) {
                this.myUI.getComponent().updateUI();
            }
        }
    }

    public void removeAllContents(boolean dispose) {
        Content[] contents;
        for (Content content : contents = this.getContents()) {
            this.removeContent(content, dispose);
        }
    }

    public int getContentCount() {
        return this.myContents.size();
    }

    @NotNull
    public Content[] getContents() {
        Content[] contentArray = this.myContents.toArray(new Content[this.myContents.size()]);
        if (contentArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "getContents"));
        }
        return contentArray;
    }

    public Content findContent(String displayName) {
        for (Content content : this.myContents) {
            if (!content.getDisplayName().equals(displayName)) continue;
            return content;
        }
        return null;
    }

    public Content getContent(int index) {
        return index >= 0 && index < this.myContents.size() ? this.myContents.get(index) : null;
    }

    public Content getContent(JComponent component) {
        Content[] contents;
        for (Content content : contents = this.getContents()) {
            if (!Comparing.equal((Object)component, (Object)content.getComponent())) continue;
            return content;
        }
        return null;
    }

    public int getIndexOfContent(Content content) {
        return this.myContents.indexOf(content);
    }

    @NotNull
    public String getCloseActionName() {
        String string = this.myUI.getCloseActionName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "getCloseActionName"));
        }
        return string;
    }

    @NotNull
    public String getCloseAllButThisActionName() {
        String string = this.myUI.getCloseAllButThisActionName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "getCloseAllButThisActionName"));
        }
        return string;
    }

    @NotNull
    public String getPreviousContentActionName() {
        String string = this.myUI.getPreviousContentActionName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "getPreviousContentActionName"));
        }
        return string;
    }

    @NotNull
    public String getNextContentActionName() {
        String string = this.myUI.getNextContentActionName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "getNextContentActionName"));
        }
        return string;
    }

    public List<AnAction> getAdditionalPopupActions(@NotNull Content content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/content/impl/ContentManagerImpl", "getAdditionalPopupActions"));
        }
        return null;
    }

    public boolean canCloseAllContents() {
        if (!this.canCloseContents()) {
            return false;
        }
        for (Content content : this.myContents) {
            if (!content.isCloseable()) continue;
            return true;
        }
        return false;
    }

    public void addSelectedContent(@NotNull Content content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/content/impl/ContentManagerImpl", "addSelectedContent"));
        }
        if (!this.checkSelectionChangeShouldBeProcessed(content, false)) {
            return;
        }
        if (this.getIndexOfContent(content) == -1) {
            throw new IllegalArgumentException("content not found: " + content);
        }
        if (!this.isSelected(content)) {
            this.mySelection.add(content);
            this.fireSelectionChanged(content, ContentManagerEvent.ContentOperation.add);
        }
    }

    private boolean checkSelectionChangeShouldBeProcessed(Content content, boolean implicit) {
        if (!this.myUI.canChangeSelectionTo(content, implicit)) {
            return false;
        }
        boolean result = !this.isSelected(content) || this.myContentWithChangedComponent.contains(content);
        this.myContentWithChangedComponent.remove(content);
        return result;
    }

    public void removeFromSelection(@NotNull Content content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/content/impl/ContentManagerImpl", "removeFromSelection"));
        }
        if (!this.isSelected(content)) {
            return;
        }
        this.mySelection.remove(content);
        this.fireSelectionChanged(content, ContentManagerEvent.ContentOperation.remove);
    }

    public boolean isSelected(@NotNull Content content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/content/impl/ContentManagerImpl", "isSelected"));
        }
        return this.mySelection.contains(content);
    }

    @NotNull
    public Content[] getSelectedContents() {
        Content[] contentArray = this.mySelection.toArray(new Content[this.mySelection.size()]);
        if (contentArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "getSelectedContents"));
        }
        return contentArray;
    }

    @Nullable
    public Content getSelectedContent() {
        return this.mySelection.isEmpty() ? null : this.mySelection.get(0);
    }

    public void setSelectedContent(@NotNull Content content, boolean requestFocus) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/content/impl/ContentManagerImpl", "setSelectedContent"));
        }
        this.setSelectedContentCB(content, requestFocus);
    }

    @NotNull
    public ActionCallback setSelectedContentCB(@NotNull Content content, boolean requestFocus) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/content/impl/ContentManagerImpl", "setSelectedContentCB"));
        }
        ActionCallback actionCallback = this.setSelectedContentCB(content, requestFocus, true);
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "setSelectedContentCB"));
        }
        return actionCallback;
    }

    public void setSelectedContent(@NotNull Content content, boolean requestFocus, boolean forcedFocus) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/content/impl/ContentManagerImpl", "setSelectedContent"));
        }
        this.setSelectedContentCB(content, requestFocus, forcedFocus);
    }

    @NotNull
    public ActionCallback setSelectedContentCB(@NotNull Content content, boolean requestFocus, boolean forcedFocus) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/content/impl/ContentManagerImpl", "setSelectedContentCB"));
        }
        ActionCallback actionCallback = this.setSelectedContent(content, requestFocus, forcedFocus, false);
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "setSelectedContentCB"));
        }
        return actionCallback;
    }

    @NotNull
    public ActionCallback setSelectedContent(final @NotNull Content content, final boolean requestFocus, final boolean forcedFocus, boolean implicit) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/content/impl/ContentManagerImpl", "setSelectedContent"));
        }
        if (this.isSelected(content) && requestFocus) {
            ActionCallback actionCallback = this.requestFocus(content, forcedFocus);
            if (actionCallback == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "setSelectedContent"));
            }
            return actionCallback;
        }
        if (!this.checkSelectionChangeShouldBeProcessed(content, implicit)) {
            ActionCallback.Rejected rejected = new ActionCallback.Rejected();
            if (rejected == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "setSelectedContent"));
            }
            return rejected;
        }
        if (!this.myContents.contains(content)) {
            throw new IllegalArgumentException("Cannot find content:" + content.getDisplayName());
        }
        boolean focused = this.isSelectionHoldsFocus();
        final Content[] old = this.getSelectedContents();
        final ActiveRunnable selection = new ActiveRunnable(){

            @NotNull
            public ActionCallback run() {
                if (ContentManagerImpl.this.myDisposed || ContentManagerImpl.this.getIndexOfContent(content) == -1) {
                    ActionCallback.Rejected rejected = new ActionCallback.Rejected();
                    if (rejected == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl$2", "run"));
                    }
                    return rejected;
                }
                for (Content each : old) {
                    ContentManagerImpl.this.removeFromSelection(each);
                }
                ContentManagerImpl.this.addSelectedContent(content);
                if (requestFocus) {
                    ActionCallback actionCallback = ContentManagerImpl.this.requestFocus(content, forcedFocus);
                    if (actionCallback == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl$2", "run"));
                    }
                    return actionCallback;
                }
                ActionCallback.Done done = new ActionCallback.Done();
                if (done == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl$2", "run"));
                }
                return done;
            }
        };
        final ActionCallback result = new ActionCallback();
        boolean enabledFocus = this.getFocusManager().isFocusTransferEnabled();
        if (focused || requestFocus) {
            if (enabledFocus) {
                ActionCallback actionCallback = this.getFocusManager().requestFocus((Component)((Object)this.myFocusProxy), true).doWhenProcessed(new Runnable(){

                    @Override
                    public void run() {
                        selection.run().notify(result);
                    }
                });
                if (actionCallback == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "setSelectedContent"));
                }
                return actionCallback;
            }
            ActionCallback actionCallback = selection.run().notify(result);
            if (actionCallback == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "setSelectedContent"));
            }
            return actionCallback;
        }
        ActionCallback actionCallback = selection.run().notify(result);
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "setSelectedContent"));
        }
        return actionCallback;
    }

    private boolean isSelectionHoldsFocus() {
        Content[] selection;
        boolean focused = false;
        for (Content each : selection = this.getSelectedContents()) {
            if (!UIUtil.isFocusAncestor((JComponent)each.getComponent())) continue;
            focused = true;
            break;
        }
        return focused;
    }

    @NotNull
    public ActionCallback setSelectedContentCB(@NotNull Content content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/content/impl/ContentManagerImpl", "setSelectedContentCB"));
        }
        ActionCallback actionCallback = this.setSelectedContentCB(content, false);
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "setSelectedContentCB"));
        }
        return actionCallback;
    }

    public void setSelectedContent(@NotNull Content content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/content/impl/ContentManagerImpl", "setSelectedContent"));
        }
        this.setSelectedContentCB(content);
    }

    public ActionCallback selectPreviousContent() {
        int contentCount = this.getContentCount();
        LOG.assertTrue(contentCount > 1);
        Content selectedContent = this.getSelectedContent();
        int index = this.getIndexOfContent(selectedContent);
        index = (index - 1 + contentCount) % contentCount;
        Content content = this.getContent(index);
        if (content == null) {
            return null;
        }
        return this.setSelectedContentCB(content, true);
    }

    public ActionCallback selectNextContent() {
        int contentCount = this.getContentCount();
        LOG.assertTrue(contentCount > 1);
        Content selectedContent = this.getSelectedContent();
        int index = this.getIndexOfContent(selectedContent);
        index = (index + 1) % contentCount;
        Content content = this.getContent(index);
        if (content == null) {
            return null;
        }
        return this.setSelectedContentCB(content, true);
    }

    public void addContentManagerListener(@NotNull ContentManagerListener l) {
        if (l == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/content/impl/ContentManagerImpl", "addContentManagerListener"));
        }
        this.myListeners.add(ContentManagerListener.class, l);
    }

    public void removeContentManagerListener(@NotNull ContentManagerListener l) {
        if (l == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/content/impl/ContentManagerImpl", "removeContentManagerListener"));
        }
        this.myListeners.remove(ContentManagerListener.class, l);
    }

    private void fireContentAdded(Content content, int newIndex, ContentManagerEvent.ContentOperation operation) {
        ContentManagerListener[] listeners;
        ContentManagerEvent event = new ContentManagerEvent((Object)this, content, newIndex, operation);
        for (ContentManagerListener listener : listeners = (ContentManagerListener[])this.myListeners.getListeners(ContentManagerListener.class)) {
            listener.contentAdded(event);
        }
    }

    private void fireContentRemoved(Content content, int oldIndex, ContentManagerEvent.ContentOperation operation) {
        ContentManagerListener[] listeners;
        ContentManagerEvent event = new ContentManagerEvent((Object)this, content, oldIndex, operation);
        for (ContentManagerListener listener : listeners = (ContentManagerListener[])this.myListeners.getListeners(ContentManagerListener.class)) {
            listener.contentRemoved(event);
        }
    }

    private void fireSelectionChanged(Content content, ContentManagerEvent.ContentOperation operation) {
        ContentManagerListener[] listeners;
        ContentManagerEvent event = new ContentManagerEvent((Object)this, content, this.myContents.indexOf(content), operation);
        for (ContentManagerListener listener : listeners = (ContentManagerListener[])this.myListeners.getListeners(ContentManagerListener.class)) {
            listener.selectionChanged(event);
        }
    }

    private boolean fireContentRemoveQuery(Content content, int oldIndex, ContentManagerEvent.ContentOperation operation) {
        ContentManagerListener[] listeners;
        ContentManagerEvent event = new ContentManagerEvent((Object)this, content, oldIndex, operation);
        for (ContentManagerListener listener : listeners = (ContentManagerListener[])this.myListeners.getListeners(ContentManagerListener.class)) {
            listener.contentRemoveQuery(event);
            if (!event.isConsumed()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ActionCallback requestFocus(Content content, boolean forced) {
        Content toSelect;
        Content content2 = toSelect = content == null ? this.getSelectedContent() : content;
        if (toSelect == null) {
            ActionCallback.Rejected rejected = new ActionCallback.Rejected();
            if (rejected == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "requestFocus"));
            }
            return rejected;
        }
        assert (this.myContents.contains(toSelect));
        ActionCallback actionCallback = this.getFocusManager().requestFocus(new FocusCommand(content, toSelect.getPreferredFocusableComponent()){

            @NotNull
            public ActionCallback run() {
                ActionCallback actionCallback = ContentManagerImpl.doRequestFocus(toSelect);
                if (actionCallback == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl$4", "run"));
                }
                return actionCallback;
            }
        }, forced);
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "requestFocus"));
        }
        return actionCallback;
    }

    private IdeFocusManager getFocusManager() {
        return IdeFocusManager.getInstance((Project)this.myProject);
    }

    private static ActionCallback doRequestFocus(Content toSelect) {
        JComponent toFocus = ContentManagerImpl.computeWillFocusComponent(toSelect);
        if (toFocus != null) {
            toFocus.requestFocus();
        }
        return new ActionCallback.Done();
    }

    private static JComponent computeWillFocusComponent(Content toSelect) {
        JComponent toFocus = toSelect.getPreferredFocusableComponent();
        if (toFocus != null) {
            toFocus = IdeFocusTraversalPolicy.getPreferredFocusedComponent(toFocus);
        }
        if (toFocus == null) {
            toFocus = toSelect.getPreferredFocusableComponent();
        }
        return toFocus;
    }

    public void addDataProvider(@NotNull DataProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/content/impl/ContentManagerImpl", "addDataProvider"));
        }
        this.myContentComponent.addProvider(provider);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("component".equals(evt.getPropertyName())) {
            this.myContentWithChangedComponent.add((Content)evt.getSource());
        }
    }

    @NotNull
    public ContentFactory getFactory() {
        ContentFactory contentFactory = (ContentFactory)ServiceManager.getService(ContentFactory.class);
        if (contentFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "getFactory"));
        }
        return contentFactory;
    }

    public void beforeTreeDispose() {
        this.myUI.beforeDispose();
    }

    public void dispose() {
        this.myDisposed = true;
        this.myContents.clear();
        this.mySelection = null;
        this.myContentWithChangedComponent.clear();
        this.myUI = null;
        this.myListeners = null;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    public boolean isSingleSelection() {
        return this.myUI.isSingleSelection();
    }

    private class MyFocusProxy
    extends Wrapper.FocusHolder
    implements DataProvider {
        private MyFocusProxy() {
            this.setOpaque(false);
            this.setPreferredSize(new Dimension(0, 0));
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            return ContentManagerImpl.this.myContentComponent.getData(dataId);
        }
    }

    private class MyContentComponent
    extends NonOpaquePanel
    implements DataProvider,
    SwitchProvider {
        private final List<DataProvider> myProviders = new ArrayList<DataProvider>();

        private MyContentComponent() {
        }

        public void addProvider(DataProvider provider) {
            this.myProviders.add(provider);
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            if (PlatformDataKeys.CONTENT_MANAGER.is(dataId)) {
                return ContentManagerImpl.this;
            }
            if (PlatformDataKeys.NONEMPTY_CONTENT_MANAGER.is(dataId) && ContentManagerImpl.this.getContentCount() > 1) {
                return ContentManagerImpl.this;
            }
            for (DataProvider each : this.myProviders) {
                Object data = each.getData(dataId);
                if (data == null) continue;
                return data;
            }
            if (ContentManagerImpl.this.myUI instanceof DataProvider) {
                return ((DataProvider)ContentManagerImpl.this.myUI).getData(dataId);
            }
            return null;
        }

        public List<SwitchTarget> getTargets(boolean onlyVisible, boolean originalProvider) {
            if (ContentManagerImpl.this.myUI instanceof SwitchProvider) {
                return ((SwitchProvider)ContentManagerImpl.this.myUI).getTargets(onlyVisible, false);
            }
            return new ArrayList<SwitchTarget>();
        }

        public SwitchTarget getCurrentTarget() {
            if (ContentManagerImpl.this.myUI instanceof SwitchProvider) {
                return ((SwitchProvider)ContentManagerImpl.this.myUI).getCurrentTarget();
            }
            return null;
        }

        public JComponent getComponent() {
            if (ContentManagerImpl.this.myUI instanceof SwitchProvider) {
                return ContentManagerImpl.this.myUI.getComponent();
            }
            return this;
        }

        public boolean isCycleRoot() {
            return ContentManagerImpl.this.myUI instanceof SwitchProvider && ((SwitchProvider)ContentManagerImpl.this.myUI).isCycleRoot();
        }
    }
}

