/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.content;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.TabbedPane;
import com.intellij.ui.TabbedPaneImpl;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.UIBundle;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.ContentUI;
import com.intellij.ui.content.tabs.PinToolwindowTabAction;
import com.intellij.ui.content.tabs.TabbedContentAction;
import com.intellij.util.IJSwingUtilities;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.MenuSelectionManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.TabbedPaneUI;
import org.jetbrains.annotations.NotNull;

public class TabbedPaneContentUI
implements ContentUI,
PropertyChangeListener {
    public static final String POPUP_PLACE = "TabbedPanePopup";
    private ContentManager myManager;
    private TabbedPaneWrapper myTabbedPaneWrapper;

    public TabbedPaneContentUI() {
        this(3);
    }

    public TabbedPaneContentUI(int tabPlacement) {
        this.myTabbedPaneWrapper = new MyTabbedPaneWrapper(tabPlacement);
    }

    public JComponent getComponent() {
        return this.myTabbedPaneWrapper.getComponent();
    }

    public void setManager(@NotNull ContentManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/content/TabbedPaneContentUI", "setManager"));
        }
        if (this.myManager != null) {
            throw new IllegalStateException();
        }
        this.myManager = manager;
        this.myManager.addContentManagerListener((ContentManagerListener)new MyContentManagerListener());
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        Content content;
        int index;
        if ("displayName".equals(e.getPropertyName())) {
            Content content2 = (Content)e.getSource();
            int index2 = this.myTabbedPaneWrapper.indexOfComponent(content2.getComponent());
            if (index2 != -1) {
                this.myTabbedPaneWrapper.setTitleAt(index2, content2.getTabName());
            }
        } else if ("description".equals(e.getPropertyName())) {
            Content content3 = (Content)e.getSource();
            int index3 = this.myTabbedPaneWrapper.indexOfComponent(content3.getComponent());
            if (index3 != -1) {
                this.myTabbedPaneWrapper.setToolTipTextAt(index3, content3.getDescription());
            }
        } else if ("component".equals(e.getPropertyName())) {
            Content content4 = (Content)e.getSource();
            JComponent oldComponent = (JComponent)e.getOldValue();
            int index4 = this.myTabbedPaneWrapper.indexOfComponent(oldComponent);
            if (index4 != -1) {
                boolean hasFocus = IJSwingUtilities.hasFocus2(oldComponent);
                this.myTabbedPaneWrapper.setComponentAt(index4, content4.getComponent());
                if (hasFocus) {
                    content4.getComponent().requestDefaultFocus();
                }
            }
        } else if ("icon".equals(e.getPropertyName()) && (index = this.myTabbedPaneWrapper.indexOfComponent((content = (Content)e.getSource()).getComponent())) != -1) {
            this.myTabbedPaneWrapper.setIconAt(index, (Icon)e.getNewValue());
        }
    }

    private Content getSelectedContent() {
        JComponent selectedComponent = this.myTabbedPaneWrapper.getSelectedComponent();
        return this.myManager.getContent(selectedComponent);
    }

    public boolean isSingleSelection() {
        return true;
    }

    public boolean isToSelectAddedContent() {
        return false;
    }

    public boolean canBeEmptySelection() {
        return false;
    }

    public void beforeDispose() {
    }

    public boolean canChangeSelectionTo(@NotNull Content content, boolean implicit) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/content/TabbedPaneContentUI", "canChangeSelectionTo"));
        }
        return true;
    }

    @NotNull
    public String getCloseActionName() {
        String string = UIBundle.message((String)"tabbed.pane.close.tab.action.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/TabbedPaneContentUI", "getCloseActionName"));
        }
        return string;
    }

    @NotNull
    public String getCloseAllButThisActionName() {
        String string = UIBundle.message((String)"tabbed.pane.close.all.tabs.but.this.action.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/TabbedPaneContentUI", "getCloseAllButThisActionName"));
        }
        return string;
    }

    @NotNull
    public String getPreviousContentActionName() {
        if ("Select Previous Tab" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/TabbedPaneContentUI", "getPreviousContentActionName"));
        }
        return "Select Previous Tab";
    }

    @NotNull
    public String getNextContentActionName() {
        if ("Select Next Tab" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/TabbedPaneContentUI", "getNextContentActionName"));
        }
        return "Select Next Tab";
    }

    public void dispose() {
    }

    private class MyContentManagerListener
    extends ContentManagerAdapter {
        private MyContentManagerListener() {
        }

        public void contentAdded(ContentManagerEvent event) {
            Content content = event.getContent();
            TabbedPaneContentUI.this.myTabbedPaneWrapper.insertTab(content.getTabName(), content.getIcon(), content.getComponent(), content.getDescription(), event.getIndex());
            content.addPropertyChangeListener((PropertyChangeListener)TabbedPaneContentUI.this);
        }

        public void contentRemoved(ContentManagerEvent event) {
            event.getContent().removePropertyChangeListener((PropertyChangeListener)TabbedPaneContentUI.this);
            TabbedPaneContentUI.this.myTabbedPaneWrapper.removeTabAt(event.getIndex());
        }

        public void selectionChanged(ContentManagerEvent event) {
            int index = event.getIndex();
            if (index != -1) {
                TabbedPaneContentUI.this.myTabbedPaneWrapper.setSelectedIndex(index);
            }
        }
    }

    private class MyTabbedPaneWrapper
    extends TabbedPaneWrapper.AsJTabbedPane {
        public MyTabbedPaneWrapper(int tabPlacement) {
            super(tabPlacement);
        }

        @Override
        protected TabbedPane createTabbedPane(int tabPlacement) {
            return new MyTabbedPane(tabPlacement);
        }

        @Override
        protected TabbedPaneWrapper.TabbedPaneHolder createTabbedPaneHolder() {
            return new MyTabbedPaneHolder(this);
        }

        private class MyTabbedPaneHolder
        extends TabbedPaneWrapper.TabbedPaneHolder
        implements DataProvider {
            private MyTabbedPaneHolder(TabbedPaneWrapper wrapper) {
                super(wrapper);
            }

            public Object getData(String dataId) {
                if (PlatformDataKeys.CONTENT_MANAGER.is(dataId)) {
                    return TabbedPaneContentUI.this.myManager;
                }
                if (PlatformDataKeys.NONEMPTY_CONTENT_MANAGER.is(dataId) && TabbedPaneContentUI.this.myManager.getContentCount() > 1) {
                    return TabbedPaneContentUI.this.myManager;
                }
                return null;
            }
        }

        private class MyTabbedPane
        extends TabbedPaneImpl {
            public MyTabbedPane(int tabPlacement) {
                super(tabPlacement);
                this.addMouseListener((MouseListener)((Object)new MyPopupHandler()));
                this.enableEvents(16L);
            }

            private void closeTabAt(int x, int y) {
                TabbedPaneUI ui = this.getUI();
                int index = ui.tabForCoordinate((JTabbedPane)((Object)this), x, y);
                if (index < 0 || !TabbedPaneContentUI.this.myManager.canCloseContents()) {
                    return;
                }
                Content content = TabbedPaneContentUI.this.myManager.getContent(index);
                if (content != null && content.isCloseable()) {
                    TabbedPaneContentUI.this.myManager.removeContent(content, true);
                }
            }

            private void hideMenu() {
                MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
                menuSelectionManager.clearSelectedPath();
            }

            protected void processMouseEvent(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showPopup(e.getX(), e.getY());
                    return;
                }
                if (!e.isShiftDown() && (0x10 & e.getModifiers()) > 0) {
                    if (502 == e.getID()) {
                        TabbedPaneUI ui = this.getUI();
                        int index = ui.tabForCoordinate((JTabbedPane)((Object)this), e.getX(), e.getY());
                        if (index != -1) {
                            this.setSelectedIndex(index);
                        }
                        this.hideMenu();
                    }
                } else if (e.isShiftDown() && (0x10 & e.getModifiers()) > 0) {
                    if (502 == e.getID()) {
                        this.closeTabAt(e.getX(), e.getY());
                        this.hideMenu();
                    }
                } else if ((8 & e.getModifiers()) > 0) {
                    if (502 == e.getID()) {
                        this.closeTabAt(e.getX(), e.getY());
                        this.hideMenu();
                    }
                } else if ((4 & e.getModifiers()) <= 0 || !SystemInfo.isWindows) {
                    super.processMouseEvent(e);
                }
            }

            protected ChangeListener createChangeListener() {
                return new MyModelListener();
            }

            private Content getContentAt(int x, int y) {
                TabbedPaneUI ui = this.getUI();
                int index = ui.tabForCoordinate((JTabbedPane)((Object)this), x, y);
                if (index < 0) {
                    return null;
                }
                return TabbedPaneContentUI.this.myManager.getContent(index);
            }

            private void showPopup(int x, int y) {
                Content content = this.getContentAt(x, y);
                if (content == null) {
                    return;
                }
                DefaultActionGroup group = new DefaultActionGroup();
                group.add((AnAction)new TabbedContentAction.CloseAction(content));
                if (TabbedPaneContentUI.this.myTabbedPaneWrapper.getTabCount() > 1) {
                    group.add((AnAction)new TabbedContentAction.CloseAllAction(TabbedPaneContentUI.this.myManager));
                    group.add((AnAction)new TabbedContentAction.CloseAllButThisAction(content));
                }
                group.addSeparator();
                group.add(PinToolwindowTabAction.getPinAction());
                group.addSeparator();
                group.add((AnAction)new TabbedContentAction.MyNextTabAction(TabbedPaneContentUI.this.myManager));
                group.add((AnAction)new TabbedContentAction.MyPreviousTabAction(TabbedPaneContentUI.this.myManager));
                List additionalActions = TabbedPaneContentUI.this.myManager.getAdditionalPopupActions(content);
                if (additionalActions != null) {
                    group.addSeparator();
                    for (AnAction anAction : additionalActions) {
                        group.add(anAction);
                    }
                }
                ActionPopupMenu menu = ActionManager.getInstance().createActionPopupMenu(TabbedPaneContentUI.POPUP_PLACE, (ActionGroup)group);
                menu.getComponent().show(TabbedPaneContentUI.this.myTabbedPaneWrapper.getComponent(), x, y);
            }

            protected class MyPopupHandler
            extends PopupHandler {
                protected MyPopupHandler() {
                }

                public void invokePopup(Component comp, int x, int y) {
                    if (TabbedPaneContentUI.this.myManager.getContentCount() == 0) {
                        return;
                    }
                    MyTabbedPane.this.showPopup(x, y);
                }
            }

            private class MyModelListener
            extends JTabbedPane.ModelListener {
                private MyModelListener() {
                    super((JTabbedPane)((Object)MyTabbedPane.this));
                }

                @Override
                public void stateChanged(ChangeEvent e) {
                    Content content = TabbedPaneContentUI.this.getSelectedContent();
                    if (content != null) {
                        TabbedPaneContentUI.this.myManager.setSelectedContent(content);
                    }
                    super.stateChanged(e);
                }
            }
        }
    }
}

