/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.SpeedSearchBase;
import com.intellij.util.PairConvertor;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MultipleTraitsSpeedSearch<Comp extends JComponent>
extends SpeedSearchBase<Comp> {
    protected final List<PairConvertor<Object, String, Boolean>> myOrderedConvertors;

    public MultipleTraitsSpeedSearch(Comp component, @NotNull List<PairConvertor<Object, String, Boolean>> convertors) {
        if (convertors == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ui/MultipleTraitsSpeedSearch", "<init>"));
        }
        super(component);
        this.myOrderedConvertors = convertors;
    }

    @Override
    protected boolean isMatchingElement(Object element, String pattern) {
        for (PairConvertor<Object, String, Boolean> convertor : this.myOrderedConvertors) {
            Boolean matched = (Boolean)convertor.convert(element, (Object)pattern);
            if (!Boolean.TRUE.equals(matched)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    protected final String getElementText(Object element) {
        throw new IllegalStateException();
    }
}

