/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.ui.EditorTextField;
import com.intellij.util.LocalTimeCounter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LanguageTextField
extends EditorTextField {
    private final Language myLanguage;
    private final Project myProject;

    public LanguageTextField() {
        this(null, null, "");
    }

    public LanguageTextField(Language language, @Nullable Project project, @NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/ui/LanguageTextField", "<init>"));
        }
        this(language, project, value, true);
    }

    public LanguageTextField(Language language, @Nullable Project project, @NotNull String value, boolean oneLineMode) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/ui/LanguageTextField", "<init>"));
        }
        this(language, project, value, new SimpleDocumentCreator(), oneLineMode);
    }

    public LanguageTextField(@Nullable Language language, @Nullable Project project, @NotNull String value, @NotNull DocumentCreator documentCreator) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/ui/LanguageTextField", "<init>"));
        }
        if (documentCreator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/ui/LanguageTextField", "<init>"));
        }
        this(language, project, value, documentCreator, true);
    }

    public LanguageTextField(@Nullable Language language, @Nullable Project project, @NotNull String value, @NotNull DocumentCreator documentCreator, boolean oneLineMode) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/ui/LanguageTextField", "<init>"));
        }
        if (documentCreator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/ui/LanguageTextField", "<init>"));
        }
        super(documentCreator.createDocument(value, language, project), project, (FileType)(language != null ? language.getAssociatedFileType() : StdFileTypes.PLAIN_TEXT), language == null, oneLineMode);
        this.myLanguage = language;
        this.myProject = project;
        this.setEnabled(language != null);
    }

    private static Document createDocument(String value, @Nullable Language language, Project project, @NotNull SimpleDocumentCreator documentCreator) {
        if (documentCreator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/ui/LanguageTextField", "createDocument"));
        }
        if (language != null) {
            PsiFileFactory factory = PsiFileFactory.getInstance((Project)project);
            LanguageFileType fileType = language.getAssociatedFileType();
            assert (fileType != null);
            long stamp = LocalTimeCounter.currentTime();
            PsiFile psiFile = factory.createFileFromText("Dummy." + fileType.getDefaultExtension(), (FileType)fileType, (CharSequence)value, stamp, true, false);
            documentCreator.customizePsiFile(psiFile);
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
            assert (document != null);
            return document;
        }
        return EditorFactory.getInstance().createDocument((CharSequence)value);
    }

    @Override
    protected EditorEx createEditor() {
        EditorEx ex = super.createEditor();
        if (this.myLanguage != null) {
            LanguageFileType fileType = this.myLanguage.getAssociatedFileType();
            ex.setHighlighter(HighlighterFactory.createHighlighter((Project)this.myProject, (FileType)fileType));
        }
        ex.setEmbeddedIntoDialogWrapper(true);
        return ex;
    }

    public static class SimpleDocumentCreator
    implements DocumentCreator {
        @Override
        public Document createDocument(String value, @Nullable Language language, Project project) {
            return LanguageTextField.createDocument(value, language, project, this);
        }

        public void customizePsiFile(PsiFile file) {
        }
    }

    public static interface DocumentCreator {
        public Document createDocument(String var1, @Nullable Language var2, Project var3);
    }
}

