/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.psi.PsiElement;
import com.intellij.ui.popup.PopupUpdateProcessor;
import com.intellij.ui.table.JBTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public abstract class JBTableWithHintProvider
extends JBTable {
    private JBPopup myHint;

    public JBTableWithHintProvider() {
        this.addSelectionListener();
    }

    protected JBTableWithHintProvider(TableModel model) {
        super(model);
    }

    private void addSelectionListener() {
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (JBTableWithHintProvider.this.getClientProperty("byMouseEvent") != Boolean.TRUE) {
                    int selected = ((ListSelectionModel)e.getSource()).getLeadSelectionIndex();
                    int rowCount = JBTableWithHintProvider.this.getRowCount();
                    if (selected == -1 || rowCount == 0) {
                        return;
                    }
                    PsiElement element = JBTableWithHintProvider.this.getPsiElementForHint(JBTableWithHintProvider.this.getValueAt(Math.min(selected, rowCount - 1), 0));
                    if (element != null && element.isValid()) {
                        JBTableWithHintProvider.this.updateHint(element);
                    }
                }
            }
        });
    }

    protected abstract PsiElement getPsiElementForHint(Object var1);

    public void registerHint(JBPopup hint) {
        this.hideHint();
        this.myHint = hint;
    }

    public void hideHint() {
        if (this.myHint != null && this.myHint.isVisible()) {
            this.myHint.cancel();
        }
        this.myHint = null;
    }

    public void updateHint(PsiElement element) {
        if (this.myHint == null || !this.myHint.isVisible()) {
            return;
        }
        PopupUpdateProcessor updateProcessor = (PopupUpdateProcessor)((Object)this.myHint.getUserData(PopupUpdateProcessor.class));
        if (updateProcessor != null) {
            updateProcessor.updatePopup(element);
        }
    }
}

