/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.GotItPanel;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.UIUtil;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class GotItMessage {
    @NotNull
    private final String myTitle;
    @NotNull
    private final String myMessage;
    private Runnable myCallback;
    private Disposable myDisposable;
    private boolean myShowCallout;

    private GotItMessage(@NotNull String title, @NotNull String message) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/GotItMessage", "<init>"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ui/GotItMessage", "<init>"));
        }
        this.myShowCallout = true;
        this.myTitle = title;
        String[] lines = message.split("\n");
        StringBuffer buf = new StringBuffer("<html><body><div align='center' style=\"font-family: ").append(UIUtil.getLabelFont().getFontName()).append("; ").append("font-size: 12pt;\">").append(lines.length > 1 ? message.replace("\n", "<br>") : message).append("</div></body></html>");
        this.myMessage = buf.toString();
    }

    public static GotItMessage createMessage(@NotNull String title, @NotNull String message) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/GotItMessage", "createMessage"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ui/GotItMessage", "createMessage"));
        }
        return new GotItMessage(title, message);
    }

    public GotItMessage setDisposable(Disposable disposable) {
        this.myDisposable = disposable;
        return this;
    }

    public GotItMessage setCallback(Runnable callback) {
        this.myCallback = callback;
        return this;
    }

    public GotItMessage setShowCallout(boolean showCallout) {
        this.myShowCallout = showCallout;
        return this;
    }

    public void show(RelativePoint point, Balloon.Position position) {
        GotItPanel panel = new GotItPanel();
        panel.myTitle.setText(this.myTitle);
        panel.myMessage.setText(this.myMessage);
        panel.myButton.setCursor(Cursor.getPredefinedCursor(12));
        BalloonBuilder builder = JBPopupFactory.getInstance().createBalloonBuilder((JComponent)panel.myRoot);
        if (this.myDisposable != null) {
            builder.setDisposable(this.myDisposable);
        }
        final Balloon balloon = builder.setFillColor(UIUtil.getListBackground()).setHideOnClickOutside(false).setHideOnAction(false).setHideOnFrameResize(false).setHideOnKeyOutside(false).setShowCallout(this.myShowCallout).setBlockClicksThroughBalloon(true).createBalloon();
        panel.myButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                balloon.hide();
                if (GotItMessage.this.myCallback != null) {
                    GotItMessage.this.myCallback.run();
                }
            }
        });
        balloon.show(point, position);
    }
}

