/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.codeInsight.daemon.MergeableLineMarkerInfo;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ElementColorProvider;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.ui.ColorChooser;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.TwoColorsIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public final class ColorLineMarkerProvider
implements LineMarkerProvider {
    private final ElementColorProvider[] myExtensions = (ElementColorProvider[])ElementColorProvider.EP_NAME.getExtensions();

    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/ColorLineMarkerProvider", "getLineMarkerInfo"));
        }
        for (ElementColorProvider colorProvider : this.myExtensions) {
            Color color = colorProvider.getColorFrom(element);
            if (color == null) continue;
            return new MyInfo(element, color, colorProvider);
        }
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/ColorLineMarkerProvider", "collectSlowLineMarkers"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ui/ColorLineMarkerProvider", "collectSlowLineMarkers"));
        }
    }

    private static class MyInfo
    extends MergeableLineMarkerInfo<PsiElement> {
        private final Color myColor;

        public MyInfo(final @NotNull PsiElement element, final Color color, final ElementColorProvider colorProvider) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/ColorLineMarkerProvider$MyInfo", "<init>"));
            }
            super(element, element.getTextRange(), (Icon)new ColorIcon(12, color), 4, (Function)FunctionUtil.nullConstant(), (GutterIconNavigationHandler)new GutterIconNavigationHandler<PsiElement>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void navigate(MouseEvent e, PsiElement elt) {
                    if (!elt.isWritable()) {
                        return;
                    }
                    Editor editor = PsiUtilBase.findEditor((PsiElement)element);
                    assert (editor != null);
                    Color c = ColorChooser.chooseColor((Component)editor.getComponent(), (String)"Choose color", (Color)color, (boolean)true);
                    if (c != null) {
                        AccessToken token = ApplicationManager.getApplication().acquireWriteActionLock(ColorLineMarkerProvider.class);
                        try {
                            colorProvider.setColorTo(element, c);
                        }
                        finally {
                            token.finish();
                        }
                    }
                }
            }, GutterIconRenderer.Alignment.LEFT);
            this.myColor = color;
        }

        public boolean canMergeWith(@NotNull MergeableLineMarkerInfo<?> info) {
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/ColorLineMarkerProvider$MyInfo", "canMergeWith"));
            }
            return info instanceof MyInfo;
        }

        public Icon getCommonIcon(@NotNull List<MergeableLineMarkerInfo> infos) {
            if (infos == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/ColorLineMarkerProvider$MyInfo", "getCommonIcon"));
            }
            if (infos.size() == 2 && infos.get(0) instanceof MyInfo && infos.get(1) instanceof MyInfo) {
                return new TwoColorsIcon(12, ((MyInfo)infos.get((int)1)).myColor, ((MyInfo)infos.get((int)0)).myColor);
            }
            return AllIcons.Gutter.Colors;
        }

        public Function<? super PsiElement, String> getCommonTooltip(@NotNull List<MergeableLineMarkerInfo> infos) {
            if (infos == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/ColorLineMarkerProvider$MyInfo", "getCommonTooltip"));
            }
            return FunctionUtil.nullConstant();
        }
    }
}

