/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.BalloonLayout;
import com.intellij.util.Alarm;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLayeredPane;
import org.jetbrains.annotations.NotNull;

public class BalloonLayoutImpl
implements BalloonLayout {
    private final JLayeredPane myParent;
    private final Insets myInsets;
    private final List<Balloon> myBalloons;
    private final Alarm myRelayoutAlarm;
    private final Runnable myRelayoutRunnable;

    public BalloonLayoutImpl(@NotNull JLayeredPane parent, @NotNull Insets insets) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/BalloonLayoutImpl", "<init>"));
        }
        if (insets == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ui/BalloonLayoutImpl", "<init>"));
        }
        this.myBalloons = new ArrayList<Balloon>();
        this.myRelayoutAlarm = new Alarm();
        this.myRelayoutRunnable = new Runnable(){

            @Override
            public void run() {
                BalloonLayoutImpl.this.relayout();
            }
        };
        this.myParent = parent;
        this.myInsets = insets;
        this.myParent.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                BalloonLayoutImpl.this.queueRelayout();
            }
        });
    }

    public void add(final Balloon balloon) {
        this.myBalloons.add(balloon);
        Disposer.register((Disposable)balloon, (Disposable)new Disposable(){

            public void dispose() {
                BalloonLayoutImpl.this.myBalloons.remove(balloon);
                BalloonLayoutImpl.this.queueRelayout();
            }
        });
        this.relayout();
        balloon.show(this.myParent);
    }

    private void queueRelayout() {
        this.myRelayoutAlarm.cancelAllRequests();
        this.myRelayoutAlarm.addRequest(this.myRelayoutRunnable, 200);
    }

    private void relayout() {
        Dimension size = this.myParent.getSize();
        size.width -= this.myInsets.left + this.myInsets.right;
        size.height -= this.myInsets.top + this.myInsets.bottom;
        Rectangle layoutRec = new Rectangle(new Point(this.myInsets.left, this.myInsets.top), size);
        List<ArrayList<Balloon>> columns = this.createColumns(layoutRec);
        while (columns.size() > 1) {
            this.myBalloons.remove(0);
            columns = this.createColumns(layoutRec);
        }
        List<Integer> columnWidths = BalloonLayoutImpl.computeWidths(columns);
        int eachCoumnX = (int)layoutRec.getMaxX();
        for (int i = 0; i < columns.size(); ++i) {
            ArrayList<Balloon> eachColumn = columns.get(i);
            Integer eachWidth = columnWidths.get(i);
            eachCoumnX -= eachWidth.intValue();
            int eachY = layoutRec.y;
            for (Balloon eachBalloon : eachColumn) {
                Rectangle eachRec = new Rectangle();
                Dimension eachPrefSize = eachBalloon.getPreferredSize();
                eachRec.setSize(eachPrefSize);
                eachRec.setLocation(eachCoumnX + eachWidth - eachRec.width, eachY);
                eachBalloon.setBounds(eachRec);
                eachY += eachRec.height;
            }
        }
    }

    private static List<Integer> computeWidths(List<ArrayList<Balloon>> columns) {
        ArrayList<Integer> columnWidths = new ArrayList<Integer>();
        for (ArrayList<Balloon> eachColumn : columns) {
            int maxWidth = 0;
            for (Balloon each : eachColumn) {
                maxWidth = Math.max(each.getPreferredSize().width, maxWidth);
            }
            columnWidths.add(maxWidth);
        }
        return columnWidths;
    }

    private List<ArrayList<Balloon>> createColumns(Rectangle layoutRec) {
        ArrayList<ArrayList<Balloon>> columns = new ArrayList<ArrayList<Balloon>>();
        ArrayList<Balloon> eachColumn = new ArrayList<Balloon>();
        columns.add(eachColumn);
        int eachColumnHeight = 0;
        for (Balloon each : this.myBalloons) {
            Dimension eachSize = each.getPreferredSize();
            if ((double)(eachColumnHeight + eachSize.height) > layoutRec.getHeight()) {
                eachColumn = new ArrayList();
                columns.add(eachColumn);
                eachColumnHeight = 0;
            }
            eachColumn.add(each);
            eachColumnHeight += eachSize.height;
        }
        return columns;
    }
}

