/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration.intention;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.TestFrameworks;
import com.intellij.codeInsight.intention.impl.BaseMoveInitializerToMethodAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testIntegration.JavaTestFramework;
import com.intellij.testIntegration.TestFramework;
import com.intellij.testIntegration.TestIntegrationUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MoveInitializerToSetUpMethodAction
extends BaseMoveInitializerToMethodAction {
    private static final Logger LOG = Logger.getInstance((String)("#" + MoveInitializerToSetUpMethodAction.class.getName()));

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testIntegration/intention/MoveInitializerToSetUpMethodAction", "getFamilyName"));
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = CodeInsightBundle.message((String)"intention.move.initializer.to.set.up", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testIntegration/intention/MoveInitializerToSetUpMethodAction", "getText"));
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        boolean isAvailable;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/testIntegration/intention/MoveInitializerToSetUpMethodAction", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/testIntegration/intention/MoveInitializerToSetUpMethodAction", "isAvailable"));
        }
        boolean bl = isAvailable = super.isAvailable(project, editor, element) && TestIntegrationUtils.isTest(element);
        if (isAvailable) {
            PsiField field = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)element, PsiField.class);
            LOG.assertTrue(field != null);
            PsiClass aClass = field.getContainingClass();
            LOG.assertTrue(aClass != null);
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
            for (TestFramework framework : (TestFramework[])Extensions.getExtensions((ExtensionPointName)TestFramework.EXTENSION_NAME)) {
                if (!(framework instanceof JavaTestFramework) || !framework.isTestClass((PsiElement)aClass)) continue;
                try {
                    ((JavaTestFramework)framework).createSetUpPatternMethod((JVMElementFactory)elementFactory);
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    protected Collection<String> getUnsuitableModifiers() {
        List<String> list = Arrays.asList("static", "final");
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testIntegration/intention/MoveInitializerToSetUpMethodAction", "getUnsuitableModifiers"));
        }
        return list;
    }

    @Override
    @NotNull
    protected Collection<PsiMethod> getOrCreateMethods(@NotNull Project project, @NotNull Editor editor, PsiFile file, @NotNull PsiClass aClass) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/testIntegration/intention/MoveInitializerToSetUpMethodAction", "getOrCreateMethods"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/testIntegration/intention/MoveInitializerToSetUpMethodAction", "getOrCreateMethods"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/testIntegration/intention/MoveInitializerToSetUpMethodAction", "getOrCreateMethods"));
        }
        PsiMethod setUpMethod = TestFrameworks.getInstance().findOrCreateSetUpMethod(aClass);
        List<PsiMethod> list = setUpMethod == null ? Collections.emptyList() : Arrays.asList(setUpMethod);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testIntegration/intention/MoveInitializerToSetUpMethodAction", "getOrCreateMethods"));
        }
        return list;
    }
}

