/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.testIntegration.TestCreator;
import com.intellij.testIntegration.createTest.CreateTestAction;
import com.intellij.util.IncorrectOperationException;

public class JavaTestCreator
implements TestCreator {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.testIntegration.JavaTestCreator");

    public boolean isAvailable(Project project, Editor editor, PsiFile file) {
        CreateTestAction action = new CreateTestAction();
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        return CreateTestAction.isAvailableForElement(element);
    }

    public void createTest(Project project, Editor editor, PsiFile file) {
        try {
            CreateTestAction action = new CreateTestAction();
            PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
            if (CreateTestAction.isAvailableForElement(element)) {
                action.invoke(project, editor, file.getContainingFile());
            }
        }
        catch (IncorrectOperationException e) {
            LOG.warn((Throwable)e);
        }
    }
}

