/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.navigation.GotoTargetHandler;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testIntegration.LanguageTestCreators;
import com.intellij.testIntegration.TestCreator;
import com.intellij.testIntegration.TestFinderHelper;
import com.intellij.util.SmartList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoTestOrCodeHandler
extends GotoTargetHandler {
    @Override
    protected String getFeatureUsedKey() {
        return "navigation.goto.testOrCode";
    }

    @Override
    @Nullable
    protected GotoTargetHandler.GotoData getSourceAndTargetElements(final Editor editor, final PsiFile file) {
        List<PsiElement> candidates;
        PsiElement selectedElement = GotoTestOrCodeHandler.getSelectedElement(editor, file);
        PsiElement sourceElement = TestFinderHelper.findSourceElement(selectedElement);
        if (sourceElement == null) {
            return null;
        }
        SmartList actions = new SmartList();
        if (TestFinderHelper.isTest(selectedElement)) {
            candidates = TestFinderHelper.findClassesForTest(selectedElement);
        } else {
            candidates = TestFinderHelper.findTestsForClass(selectedElement);
            final TestCreator creator = (TestCreator)LanguageTestCreators.INSTANCE.forLanguage(file.getLanguage());
            if (creator != null && creator.isAvailable(file.getProject(), editor, file)) {
                actions.add(new GotoTargetHandler.AdditionalAction(){

                    @Override
                    public String getText() {
                        return "Create New Test...";
                    }

                    @Override
                    public Icon getIcon() {
                        return AllIcons.Actions.IntentionBulb;
                    }

                    @Override
                    public void execute() {
                        creator.createTest(file.getProject(), editor, file);
                    }
                });
            }
        }
        return new GotoTargetHandler.GotoData(sourceElement, PsiUtilCore.toPsiElementArray(candidates), (List<GotoTargetHandler.AdditionalAction>)actions);
    }

    @NotNull
    public static PsiElement getSelectedElement(Editor editor, PsiFile file) {
        PsiElement psiElement = PsiUtilCore.getElementAtOffset((PsiFile)file, (int)editor.getCaretModel().getOffset());
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testIntegration/GotoTestOrCodeHandler", "getSelectedElement"));
        }
        return psiElement;
    }

    @Override
    protected boolean shouldSortTargets() {
        return false;
    }

    @Override
    protected String getChooserTitle(PsiElement sourceElement, String name, int length) {
        if (TestFinderHelper.isTest(sourceElement)) {
            return CodeInsightBundle.message((String)"goto.test.chooserTitle.subject", (Object[])new Object[]{name, length});
        }
        return CodeInsightBundle.message((String)"goto.test.chooserTitle.test", (Object[])new Object[]{name, length});
    }

    @Override
    protected String getFindUsagesTitle(PsiElement sourceElement, String name, int length) {
        if (TestFinderHelper.isTest(sourceElement)) {
            return CodeInsightBundle.message((String)"goto.test.findUsages.subject.title", (Object[])new Object[]{name});
        }
        return CodeInsightBundle.message((String)"goto.test.findUsages.test.title", (Object[])new Object[]{name});
    }

    @Override
    protected String getNotFoundMessage(Project project, Editor editor, PsiFile file) {
        return CodeInsightBundle.message((String)"goto.test.notFound", (Object[])new Object[0]);
    }

    @Override
    @Nullable
    protected String getAdText(PsiElement source, int length) {
        Keymap keymap;
        Shortcut[] shortcuts;
        if (length > 0 && !TestFinderHelper.isTest(source) && (shortcuts = (keymap = KeymapManager.getInstance().getActiveKeymap()).getShortcuts("Run")).length > 0) {
            return "Press " + KeymapUtil.getShortcutText((Shortcut)shortcuts[0]) + " to run selected tests";
        }
        return null;
    }

    @Override
    protected void navigateToElement(Navigatable element) {
        if (element instanceof PsiElement) {
            NavigationUtil.activateFileWithPsiElement((PsiElement)element, true);
        } else {
            element.navigate(true);
        }
    }
}

