/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.testFramework.LightProjectDescriptor;
import com.intellij.testFramework.builders.EmptyModuleFixtureBuilder;
import com.intellij.testFramework.builders.ModuleFixtureBuilder;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.testFramework.fixtures.IdeaProjectTestFixture;
import com.intellij.testFramework.fixtures.IdeaTestFixtureFactory;
import com.intellij.testFramework.fixtures.ModuleFixture;
import com.intellij.testFramework.fixtures.TempDirTestFixture;
import com.intellij.testFramework.fixtures.TestFixtureBuilder;
import com.intellij.testFramework.fixtures.impl.CodeInsightTestFixtureImpl;
import com.intellij.testFramework.fixtures.impl.EmptyModuleFixtureBuilderImpl;
import com.intellij.testFramework.fixtures.impl.HeavyIdeaTestFixtureImpl;
import com.intellij.testFramework.fixtures.impl.HeavyTestFixtureBuilderImpl;
import com.intellij.testFramework.fixtures.impl.LightIdeaTestFixtureImpl;
import com.intellij.testFramework.fixtures.impl.LightTestFixtureBuilderImpl;
import com.intellij.testFramework.fixtures.impl.ModuleFixtureImpl;
import com.intellij.testFramework.fixtures.impl.TempDirTestFixtureImpl;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeaTestFixtureFactoryImpl
extends IdeaTestFixtureFactory {
    protected final Map<Class<? extends ModuleFixtureBuilder>, Class<? extends ModuleFixtureBuilder>> myFixtureBuilderProviders = new HashMap<Class<? extends ModuleFixtureBuilder>, Class<? extends ModuleFixtureBuilder>>();

    public IdeaTestFixtureFactoryImpl() {
        this.registerFixtureBuilder(EmptyModuleFixtureBuilder.class, MyEmptyModuleFixtureBuilderImpl.class);
    }

    @Override
    public final <T extends ModuleFixtureBuilder> void registerFixtureBuilder(@NotNull Class<T> aClass, @NotNull Class<? extends T> implClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/testFramework/fixtures/impl/IdeaTestFixtureFactoryImpl", "registerFixtureBuilder"));
        }
        if (implClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/testFramework/fixtures/impl/IdeaTestFixtureFactoryImpl", "registerFixtureBuilder"));
        }
        this.myFixtureBuilderProviders.put(aClass, implClass);
    }

    @Override
    public void registerFixtureBuilder(@NotNull Class<? extends ModuleFixtureBuilder> aClass, @NotNull String implClassName) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/testFramework/fixtures/impl/IdeaTestFixtureFactoryImpl", "registerFixtureBuilder"));
        }
        if (implClassName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/testFramework/fixtures/impl/IdeaTestFixtureFactoryImpl", "registerFixtureBuilder"));
        }
        try {
            Class<?> implClass = Class.forName(implClassName);
            assert (aClass.isAssignableFrom(implClass));
            this.registerFixtureBuilder(aClass, implClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Cannot instantiate fixture builder implementation", e);
        }
    }

    @Override
    public TestFixtureBuilder<IdeaProjectTestFixture> createFixtureBuilder(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/testFramework/fixtures/impl/IdeaTestFixtureFactoryImpl", "createFixtureBuilder"));
        }
        return new HeavyTestFixtureBuilderImpl(new HeavyIdeaTestFixtureImpl(name), this.myFixtureBuilderProviders);
    }

    @Override
    public TestFixtureBuilder<IdeaProjectTestFixture> createLightFixtureBuilder() {
        return new LightTestFixtureBuilderImpl<IdeaProjectTestFixture>(new LightIdeaTestFixtureImpl(LightProjectDescriptor.EMPTY_PROJECT_DESCRIPTOR));
    }

    @Override
    public TestFixtureBuilder<IdeaProjectTestFixture> createLightFixtureBuilder(@Nullable LightProjectDescriptor projectDescriptor) {
        if (projectDescriptor == null) {
            projectDescriptor = LightProjectDescriptor.EMPTY_PROJECT_DESCRIPTOR;
        }
        return new LightTestFixtureBuilderImpl<IdeaProjectTestFixture>(new LightIdeaTestFixtureImpl(projectDescriptor));
    }

    @Override
    public CodeInsightTestFixture createCodeInsightFixture(@NotNull IdeaProjectTestFixture projectFixture) {
        if (projectFixture == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/testFramework/fixtures/impl/IdeaTestFixtureFactoryImpl", "createCodeInsightFixture"));
        }
        return this.createCodeInsightFixture(projectFixture, new TempDirTestFixtureImpl());
    }

    @Override
    public CodeInsightTestFixture createCodeInsightFixture(@NotNull IdeaProjectTestFixture projectFixture, @NotNull TempDirTestFixture tempDirFixture) {
        if (projectFixture == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/testFramework/fixtures/impl/IdeaTestFixtureFactoryImpl", "createCodeInsightFixture"));
        }
        if (tempDirFixture == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/testFramework/fixtures/impl/IdeaTestFixtureFactoryImpl", "createCodeInsightFixture"));
        }
        return new CodeInsightTestFixtureImpl(projectFixture, tempDirFixture);
    }

    @Override
    public TempDirTestFixture createTempDirTestFixture() {
        return new TempDirTestFixtureImpl();
    }

    public static class MyEmptyModuleFixtureBuilderImpl
    extends EmptyModuleFixtureBuilderImpl {
        public MyEmptyModuleFixtureBuilderImpl(TestFixtureBuilder<? extends IdeaProjectTestFixture> testFixtureBuilder) {
            super(testFixtureBuilder);
        }

        @Override
        protected ModuleFixture instantiateFixture() {
            return new ModuleFixtureImpl(this);
        }
    }
}

