/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.Project;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class TestDataProvider
implements DataProvider {
    private final Project myProject;

    public TestDataProvider(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/testFramework/TestDataProvider", "<init>"));
        }
        this.myProject = project;
    }

    public Object getData(@NonNls String dataId) {
        if (this.myProject.isDisposed()) {
            throw new RuntimeException("TestDataProvider is already disposed for " + this.myProject + "\n" + "If you closed a project in test, please reset IdeaTestApplication.setDataProvider.");
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        if (CommonDataKeys.EDITOR.is(dataId) || OpenFileDescriptor.NAVIGATE_IN_EDITOR.is(dataId)) {
            return FileEditorManager.getInstance((Project)this.myProject).getSelectedTextEditor();
        }
        Editor editor = (Editor)this.getData(CommonDataKeys.EDITOR.getName());
        if (editor != null) {
            FileEditorManagerEx manager = FileEditorManagerEx.getInstanceEx(this.myProject);
            Object managerData = manager.getData(dataId, editor, manager.getSelectedFiles()[0]);
            if (managerData != null) {
                return managerData;
            }
            JComponent component = editor.getContentComponent();
            if (component instanceof EditorComponentImpl) {
                return ((EditorComponentImpl)component).getData(dataId);
            }
        }
        return null;
    }
}

