/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.mock.MockApplication;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import org.jetbrains.annotations.NotNull;

public class PlatformUltraLiteTestFixture {
    private Disposable myAppDisposable = null;

    @NotNull
    public static PlatformUltraLiteTestFixture getFixture() {
        PlatformUltraLiteTestFixture platformUltraLiteTestFixture = new PlatformUltraLiteTestFixture();
        if (platformUltraLiteTestFixture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/PlatformUltraLiteTestFixture", "getFixture"));
        }
        return platformUltraLiteTestFixture;
    }

    private PlatformUltraLiteTestFixture() {
    }

    public void setUp() {
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            this.myAppDisposable = Disposer.newDisposable();
            ApplicationManager.setApplication((Application)new MockApplication(this.myAppDisposable), (Disposable)this.myAppDisposable);
        }
    }

    public void tearDown() {
        if (this.myAppDisposable != null) {
            Disposer.dispose((Disposable)this.myAppDisposable);
        }
    }
}

