/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import org.apache.log4j.Logger;
import org.jetbrains.annotations.NonNls;

@NonNls
public abstract class LoggedErrorProcessor {
    private static final LoggedErrorProcessor DEFAULT;
    private static LoggedErrorProcessor ourInstance;

    public static LoggedErrorProcessor getInstance() {
        return ourInstance;
    }

    public static void setNewInstance(LoggedErrorProcessor newInstance) {
        ourInstance = newInstance;
    }

    public static void restoreDefaultProcessor() {
        ourInstance = DEFAULT;
    }

    public abstract void processError(String var1, Throwable var2, String[] var3, Logger var4);

    static {
        ourInstance = DEFAULT = new LoggedErrorProcessor(){

            @Override
            public void processError(String message, Throwable t, String[] details, Logger logger) {
                logger.info((Object)message, t);
                System.err.println("ERROR: " + message);
                if (t != null) {
                    t.printStackTrace();
                }
                if (details != null && details.length > 0) {
                    System.out.println("details: ");
                    for (String detail : details) {
                        System.out.println(detail);
                    }
                }
                throw new AssertionError((Object)message);
            }
        };
    }
}

