/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.featureStatistics.FeatureDescriptor;
import com.intellij.featureStatistics.ProductivityFeaturesRegistry;
import com.intellij.ide.util.TipAndTrickBean;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.testFramework.PlatformTestCase;
import com.intellij.util.ResourceUtil;
import com.intellij.util.containers.ContainerUtil;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class IdeResourcesTestCase
extends PlatformTestCase {
    @Override
    protected boolean isRunInWriteAction() {
        return false;
    }

    public void testFeatureTipsRegistered() {
        ProductivityFeaturesRegistry registry = ProductivityFeaturesRegistry.getInstance();
        Set ids = registry.getFeatureIds();
        IdeResourcesTestCase.assertNotEmpty(ids);
        ArrayList errors = ContainerUtil.newArrayList();
        for (String id : ids) {
            FeatureDescriptor descriptor = registry.getFeatureDescriptor(id);
            TipAndTrickBean tip = TipAndTrickBean.findByFileName(descriptor.getTipFileName());
            if (tip != null) continue;
            errors.add("<tipAndTrick file=\"" + descriptor.getTipFileName() + "\" feature-id=\"" + id + "\"/>");
        }
        IdeResourcesTestCase.assertEquals((String)("Register the following extensions:\n" + StringUtil.join((Collection)errors, (String)"\n")), (int)0, (int)errors.size());
    }

    public void testTipFilesPresent() {
        ArrayList errors = ContainerUtil.newArrayList();
        TipAndTrickBean[] tips = (TipAndTrickBean[])TipAndTrickBean.EP_NAME.getExtensions();
        IdeResourcesTestCase.assertNotEmpty(Arrays.asList(tips));
        for (TipAndTrickBean tip : tips) {
            URL url = ResourceUtil.getResource((ClassLoader)tip.getPluginDescriptor().getPluginClassLoader(), (String)"/tips/", (String)tip.fileName);
            if (url != null) continue;
            errors.add(tip.fileName);
        }
        IdeResourcesTestCase.assertEquals((String)(tips.length + " tips are checked, the following files are missing:\n" + StringUtil.join((Collection)errors, (String)"\n")), (int)0, (int)errors.size());
    }

    public void testTipFilesDuplicates() {
        ArrayList errors = ContainerUtil.newArrayList();
        TipAndTrickBean[] tips = (TipAndTrickBean[])TipAndTrickBean.EP_NAME.getExtensions();
        IdeResourcesTestCase.assertNotEmpty(Arrays.asList(tips));
        LinkedHashSet visited = ContainerUtil.newLinkedHashSet();
        for (TipAndTrickBean tip : tips) {
            if (visited.add(tip.fileName)) continue;
            errors.add(tip.fileName);
        }
        IdeResourcesTestCase.assertEquals((String)("The following tip files are registered more than once:\n" + StringUtil.join((Collection)errors, (String)"\n")), (int)0, (int)errors.size());
    }
}

